---
generated_at: 2026-01-29 11:10:00
metrics:
  claims_total: 23
  claims_with_evidence: 22
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：49-post.tag.attached

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：22 / 23、根拠なし：1
- 優先レビュー（高）
  1. **リトライ間隔の詳細**: @tryghost/requestのデフォルト設定の具体値が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/webhooks/listen.js` (10-68行目)
- E-02: `ghost/core/core/server/services/webhooks/webhook-trigger.js` (1-147行目)
- E-03: `ghost/core/core/server/services/webhooks/payload.js` (1-17行目)
- E-04: `ghost/core/core/server/services/webhooks/serialize.js` (1-82行目)
- E-05: `ghost/core/core/server/models/post.js` (482-532行目)
- E-06: `ghost/core/core/server/models/webhook.js` (1-86行目)
- E-07: `ghost/core/core/server/data/schema/schema.js` (61-105行目 posts, 297-305行目 posts_tags, 353-370行目 webhooks)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | post.tag.attachedイベントがWEBHOOKSリストに定義されている | E-01 (41行目) | ○ |
| C-02 | handleAttachedModelsでtags関連のイベント処理を行う | E-05 (482-516行目) | ○ |
| C-03 | tags.once('attaching')でattachingイベントを監視 | E-05 (496行目) | ○ |
| C-04 | tags.once('attached')でattachedイベントを監視 | E-05 (497行目) | ○ |
| C-05 | 各タグに対してtag.emitChange('attached')を呼び出す | E-05 (499行目) | ○ |
| C-06 | model.emitChange('tag.attached')でイベントを発火 | E-05 (500行目) | ○ |
| C-07 | 複数タグの場合、各タグごとにイベント発火 | E-05 (498行目 forEach) | ○ |
| C-08 | handleAttachedModelsはonSaving内で呼び出される | E-05 (669行目) | ○ |
| C-09 | webhooksテーブルからevent一致するレコードを取得 | E-06 (46-53行目) | ○ |
| C-10 | リトライ回数は5回（本番）、0回（テスト） | E-02 (133-134行目) | ○ |
| C-11 | タイムアウトは2000ms（2秒） | E-02 (129-131行目) | ○ |
| C-12 | posts/pagesの場合、tagsとauthorsをwithRelatedに含める | E-04 (21-27行目) | ○ |
| C-13 | resourceNameはeventから正規表現で抽出 | E-04 (7行目) | ○ |
| C-14 | posts_tagsテーブルでpost_id, tag_idを管理 | E-07 (297-305行目) | ○ |
| C-15 | postsテーブルにtype='post'の投稿が格納 | E-07 (73行目) | ○ |
| C-16 | secretが設定されている場合X-Ghost-Signatureヘッダーを付与 | E-02 (122-124行目) | ○ |
| C-17 | 410レスポンスでWebhookを削除 | E-02 (83-86行目) | ○ |
| C-18 | options.importingがtrueの場合は送信しない | E-01 (61-63行目) | ○ |
| C-19 | ステータス変更時もtag.attachedが発火される | E-05 (524-532行目) | ○ |
| C-20 | ペイロードにcurrentとpreviousを含む | E-04 (73-78行目) | ○ |
| C-21 | emitChangeでresourceType + '.' + eventを構成 | E-05 (356-366行目) | ○ |
| C-22 | Content-Typeはapplication/json | E-02 (118行目) | ○ |
| C-23 | リトライ間隔は@tryghost/requestのデフォルト設定に従う | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **リトライ間隔の具体値**: @tryghost/requestパッケージの内部実装に依存しており、具体的な間隔は外部パッケージのコードを確認する必要がある
  - 候補: @tryghost/requestのソースコード / got パッケージのデフォルト設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - handleAttachedModelsの実装は明確
- 0: 低リスク - Bookshelfのattaching/attachedイベント使用は標準的パターン
- 0: 低リスク - 複数タグ追加時の挙動（各タグごとにイベント発火）は明確
- 1: 中リスク - リトライ間隔の具体値は外部依存のため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] E-05 (post.js:496-501) のタグattached処理が設計書の記載と一致しているか確認
- [ ] E-05 (post.js:669) のhandleAttachedModels呼び出し箇所を確認
- [ ] E-04 (serialize.js:21-27) のwithRelated設定を確認
- [ ] 複数タグ追加時に各タグごとにWebhookが発火されることを確認
