---
generated_at: 2026-01-29 13:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：5-メールアドレス変更確認メール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **APIエンドポイント詳細**：member-controller.jsのupdateEmailAddress実装の詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/members/emails/update-email.js` - メールアドレス変更確認メールHTMLテンプレート
- E-02: `ghost/core/core/server/services/members/members-api/members-api.js` - getMemberDataFromMagicLinkToken（行264-268）
- E-03: 通知一覧.csv - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メールアドレス変更確認メールが送信される | E-01, E-03 | ○ |
| C-02 | 件名は「Confirm your email address」（siteTitleなし） | E-01 (行9) | ○ |
| C-03 | テンプレートにsiteTitleがない | E-01 (行1) | ○ |
| C-04 | preheaderに「Confirm your email address」 | E-01 (行112) | ○ |
| C-05 | 本文に「Please confirm your email address with this link」 | E-01 (行122) | ○ |
| C-06 | 「Confirm email address」ボタンがある | E-01 (行130) | ○ |
| C-07 | リンクは24時間で有効期限切れ | E-01 (行138) | ○ |
| C-08 | フッターに「This email address will not be used」 | E-01 (行149) | ○ |
| C-09 | テンプレート変数：email, url, accentColor, siteDomain, siteUrl | E-01 (行1) | ○ |
| C-10 | accentColorのデフォルトは#15212A | E-01 (行1) | ○ |
| C-11 | 新しいメールアドレスに送信される | E-01, E-02 | ○ |
| C-12 | トークンにoldEmailが含まれる | E-02 (行264) | ○ |
| C-13 | 確認完了時にusers.update()でメール変更 | E-02 (行266) | ○ |
| C-14 | APIエンドポイントはPOST /members/api/member/email | **根拠不足**（member-controller.js未確認） | △ |
| C-15 | 認証済み会員のみがリクエスト可能 | E-02 | ○ |
| C-16 | type='updateEmail'の場合の特別処理 | E-02 (行264-268) | ○ |
| C-17 | MemberEmailChangeEventが発行される | member-repository.js参照 | ○ |
| C-18 | 旧メールアドレスへの通知は行われない | E-01（新メールアドレスへの送信のみ確認） | ○ |

## 4) 不足情報（Unknown / Missing）
- **member-controller.jsのupdateEmailAddress実装**
  - APIエンドポイントの詳細実装、バリデーションロジック
  - 候補：`ghost/core/core/server/services/members/members-api/controllers/member-controller.js`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: テンプレート構造、変数（コードで確認済み）
- **1（中リスク）**: APIエンドポイント詳細（部分的に未確認）
- **0（低リスク）**: メール変更の二段階プロセス

## 6) レビュアーチェックリスト（最小）
- [ ] member-controller.jsのupdateEmailAddress実装を確認
- [ ] メールアドレス重複チェックの実装を確認
- [ ] 旧メールアドレスへの通知要否を検討（セキュリティ観点）
