---
generated_at: 2026-01-29 10:35:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：52-page.tag.detached

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認されました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/webhooks/listen.js` - Webhookイベントリスト定義（10-45行目）
- E-02: `ghost/core/core/server/services/webhooks/webhook-trigger.js` - WebhookTriggerクラス（1-147行目）
- E-03: `ghost/core/core/server/services/webhooks/payload.js` - ペイロード生成（1-16行目）
- E-04: `ghost/core/core/server/services/webhooks/serialize.js` - シリアライズ処理（1-82行目）
- E-05: `ghost/core/core/server/models/post.js` - Postモデル、handleAttachedModels（482-516行目）
- E-06: `ghost/core/core/server/models/webhook.js` - Webhookモデル（1-85行目）
- E-07: `ghost/core/core/server/lib/common/events.js` - EventRegistry（1-33行目）
- E-08: `ghost/core/core/server/data/schema/schema.js` - webhooksテーブル（353-370行目）
- E-09: `ghost/core/core/server/data/schema/schema.js` - posts_tagsテーブル（297-305行目）
- E-10: `ghost/core/test/e2e-webhooks/pages.test.js` - E2Eテスト（463-523行目）
- E-11: `ghost/core/test/e2e-webhooks/__snapshots__/pages.test.js.snap` - スナップショット（1711-1900行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | page.tag.detachedイベントがWebhookリストに定義されている | E-01 (44行目) | ○ |
| C-02 | イベント発火時にWebhookTrigger.triggerが呼び出される | E-01 (65行目), E-02 (98-143行目) | ○ |
| C-03 | HTTPメソッドはPOST | E-02 (139行目) | ○ |
| C-04 | Content-Typeはapplication/json | E-02 (118行目) | ○ |
| C-05 | リトライ回数は最大5回（テスト環境では0回） | E-02 (133-134行目) | ○ |
| C-06 | タイムアウトは2秒 | E-02 (129-131行目) | ○ |
| C-07 | secretが設定されている場合X-Ghost-Signatureが付与される | E-02 (122-124行目) | ○ |
| C-08 | 署名形式はsha256={署名}, t={タイムスタンプ} | E-02 (123行目) | ○ |
| C-09 | 410レスポンスでWebhookは自動削除される | E-02 (83-87行目) | ○ |
| C-10 | ペイロードにcurrentとpreviousが含まれる | E-04 (73-78行目) | ○ |
| C-11 | インポート中はイベントが発火しない | E-01 (61-63行目) | ○ |
| C-12 | customIntegrations制限時は内部インテグレーションのみ送信 | E-02 (24-43行目) | ○ |
| C-13 | Webhook.findAllByEventでeventに一致するWebhookを取得 | E-06 (46-52行目) | ○ |
| C-14 | webhooksテーブルにevent, target_url, secretカラムがある | E-08 (354-359行目) | ○ |
| C-15 | posts_tagsテーブルでページとタグの関連を管理 | E-09 (297-305行目) | ○ |
| C-16 | handleAttachedModelsでタグのdetachingイベントを設定 | E-05 (489-494行目) | ○ |
| C-17 | detachingイベントのスコープでtagを保持する | E-05 (489行目) | ○ |
| C-18 | emitChangeで'tag.detached'イベントが発火される | E-05 (492行目) | ○ |
| C-19 | EventRegistryはNode.jsのEventEmitterを継承 | E-07 (14-28行目) | ○ |
| C-20 | 送信成功時にlast_triggered_atが更新される | E-02 (51-62行目) | ○ |
| C-21 | 送信失敗時にlast_triggered_errorが記録される | E-02 (89-92行目) | ○ |
| C-22 | ペイロードにpages/postsのフォーマットが適用される | E-04 (21-27行目) | ○ |
| C-23 | Content-Versionヘッダーにゴーストバージョンが含まれる | E-02 (119行目) | ○ |
| C-24 | E2Eテストでpage.tag.detachedイベントの動作が検証されている | E-10 (463-523行目) | ○ |
| C-25 | スナップショットでpreviousにタグが含まれることが検証されている | E-11 (1899-1900行目) | ○ |
| C-26 | resourceNameはイベント名から抽出される（page.から'page'） | E-04 (7行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全ての主張に根拠が確認されました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードとテストコードで裏付けられています

## 6) レビュアーチェックリスト（最小）
- [ ] listen.jsのWEBHOOKSリストに'page.tag.detached'が含まれていることを確認
- [ ] post.jsのhandleAttachedModelsでdetachingイベント内でtagが正しく保持されることを確認
- [ ] E2Eテストでpreviousに削除されたタグが含まれることを確認
- [ ] webhook-trigger.jsのtriggerメソッドの署名生成ロジックが正しいことを確認
