---
generated_at: 2026-01-29 10:40:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：53-site.changed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認されました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/web/parent/middleware/emit-events.js` - site.changedイベント発火（1-21行目）
- E-02: `ghost/core/core/server/services/webhooks/listen.js` - Webhookイベントリスト定義（10-45行目）
- E-03: `ghost/core/core/server/services/webhooks/webhook-trigger.js` - WebhookTriggerクラス（1-147行目）
- E-04: `ghost/core/core/server/services/webhooks/payload.js` - ペイロード生成、空オブジェクト（1-16行目）
- E-05: `ghost/core/core/server/models/webhook.js` - Webhookモデル（1-85行目）
- E-06: `ghost/core/core/server/lib/common/events.js` - EventRegistry（1-33行目）
- E-07: `ghost/core/core/server/data/schema/schema.js` - webhooksテーブル（353-370行目）
- E-08: `ghost/core/core/server/api/endpoints/pages.js` - X-Cache-Invalidate設定（123行目、169-171行目）
- E-09: `ghost/core/core/server/services/posts-public/service.js` - site.changedリスナー（16-18行目）
- E-10: `ghost/core/core/server/services/tags-public/service.js` - site.changedリスナー（16-18行目）
- E-11: `ghost/core/core/server/services/link-redirection/link-redirect-repository.js` - site.changedリスナー（36-38行目）
- E-12: `ghost/core/test/e2e-webhooks/site.test.js` - E2Eテスト（1-126行目）
- E-13: `ghost/core/test/e2e-webhooks/__snapshots__/site.test.js.snap` - スナップショット（1-26行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | site.changedイベントがWebhookリストの最初に定義されている | E-02 (11行目) | ○ |
| C-02 | X-Cache-Invalidate === '/*'の時にイベントが発火する | E-01 (13-14行目) | ○ |
| C-03 | INVALIDATE_ALL定数が'/*'と定義されている | E-01 (1行目) | ○ |
| C-04 | res.on('finish')でレスポンス完了時にチェックする | E-01 (12行目) | ○ |
| C-05 | events.emit('site.changed')でイベントが発火される | E-01 (14行目) | ○ |
| C-06 | HTTPメソッドはPOST | E-03 (139行目) | ○ |
| C-07 | Content-Typeはapplication/json | E-03 (118行目) | ○ |
| C-08 | リトライ回数は最大5回（テスト環境では0回） | E-03 (133-134行目) | ○ |
| C-09 | タイムアウトは2秒 | E-03 (129-131行目) | ○ |
| C-10 | secretが設定されている場合X-Ghost-Signatureが付与される | E-03 (122-124行目) | ○ |
| C-11 | 署名形式はsha256={署名}, t={タイムスタンプ} | E-03 (123行目) | ○ |
| C-12 | 410レスポンスでWebhookは自動削除される | E-03 (83-87行目) | ○ |
| C-13 | modelがない場合は空オブジェクト{}が返却される | E-04 (13-15行目) | ○ |
| C-14 | customIntegrations制限時は内部インテグレーションのみ送信 | E-03 (24-43行目) | ○ |
| C-15 | Webhook.findAllByEventでeventに一致するWebhookを取得 | E-05 (46-52行目) | ○ |
| C-16 | webhooksテーブルにevent, target_url, secretカラムがある | E-07 (354-359行目) | ○ |
| C-17 | EventRegistryはNode.jsのEventEmitterを継承 | E-06 (14-28行目) | ○ |
| C-18 | 送信成功時にlast_triggered_atが更新される | E-03 (51-62行目) | ○ |
| C-19 | 送信失敗時にlast_triggered_errorが記録される | E-03 (89-92行目) | ○ |
| C-20 | Content-Versionヘッダーにゴーストバージョンが含まれる | E-03 (119行目) | ○ |
| C-21 | ページ公開時にX-Cache-Invalidateが設定される | E-08 (123行目) | ○ |
| C-22 | ページ編集時にキャッシュ無効化判定が行われる | E-08 (169-171行目) | ○ |
| C-23 | posts-publicサービスがsite.changedをリッスンしてキャッシュをリセットする | E-09 (16-18行目) | ○ |
| C-24 | tags-publicサービスがsite.changedをリッスンしてキャッシュをリセットする | E-10 (16-18行目) | ○ |
| C-25 | link-redirectionサービスがsite.changedをリッスンしてキャッシュをリセットする | E-11 (36-38行目) | ○ |
| C-26 | E2Eテストでsite.changedイベントの動作が検証されている | E-12 (22-50行目) | ○ |
| C-27 | スナップショットでペイロードが空オブジェクトであることが検証されている | E-13 (13行目) | ○ |
| C-28 | customIntegrations制限下でも内部Webhookは送信される | E-12 (91-125行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全ての主張に根拠が確認されました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードとテストコードで裏付けられています

## 6) レビュアーチェックリスト（最小）
- [ ] emit-events.jsでX-Cache-Invalidate === '/*'の条件でsite.changedが発火することを確認
- [ ] payload.jsでmodelがundefinedの場合に空オブジェクトが返却されることを確認
- [ ] listen.jsのWEBHOOKSリストに'site.changed'が含まれていることを確認
- [ ] E2Eテストでペイロードが空オブジェクトであることを確認
- [ ] customIntegrations制限下でのテストが正しく動作することを確認
