---
generated_at: 2026-01-29 13:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-会員ウェルカムメール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/member-welcome-emails/service.js` - メインサービス実装
- E-02: `ghost/core/core/server/services/member-welcome-emails/member-welcome-email-renderer.js` - レンダラー実装
- E-03: `ghost/core/core/server/services/member-welcome-emails/constants.js` - 定数定義
- E-04: 通知一覧.csv - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 新規会員登録完了後にウェルカムメールを送信 | E-01, E-04 | ○ |
| C-02 | free会員用とpaid会員用で別テンプレート | E-03 (行4-6) | ○ |
| C-03 | slug名は'member-welcome-email-free'と'member-welcome-email-paid' | E-03 (行4-6) | ○ |
| C-04 | automated_emailsテーブルから設定を取得 | E-01 (行34-49) | ○ |
| C-05 | status='active'の場合のみ送信 | E-01 (行64-68, 106) | ○ |
| C-06 | lexical列がnullの場合は送信しない | E-01 (行36-38) | ○ |
| C-07 | Lexical形式のコンテンツをHTMLにレンダリング | E-02 (行91) | ○ |
| C-08 | 変数置換対応（first_name, name, email, site_title, site_url） | E-02 (行38-49) | ○ |
| C-09 | 変数にフォールバック値を指定可能 | E-02 (行66-71) | ○ |
| C-10 | HTMLエスケープを実施 | E-02 (行71) | ○ |
| C-11 | CSSインライン化（juice使用） | E-02 (行110) | ○ |
| C-12 | GhostMailerで送信 | E-01 (行20-21, 89-95) | ○ |
| C-13 | 件名も変数置換対応 | E-02 (行100) | ○ |
| C-14 | sender_name, sender_email, sender_reply_toを設定から取得 | E-01 (行45-47) | ○ |
| C-15 | テスト用インボックス設定対応 | E-01 (行80-81) | ○ |
| C-16 | forceTextContent: trueで送信 | E-01 (行94) | ○ |
| C-17 | テストメール送信機能あり | E-01 (行109-150) | ○ |
| C-18 | サイト設定からtitle, url, accentColorを取得 | E-01 (行24-29) | ○ |
| C-19 | first_nameはnameから抽出（スペース区切りの最初の部分） | E-02 (行38-44) | ○ |
| C-20 | 未マッチのトークンは空文字に置換 | E-02 (行76) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要な主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張に根拠あり
- **0（低リスク）**: Lexicalレンダリング処理
- **0（低リスク）**: 変数置換処理

## 6) レビュアーチェックリスト（最小）
- [ ] MemberCreatedEventの発火タイミングとイベントハンドラーの紐付けを確認
- [ ] wrapper.hbsテンプレートの構造を確認
- [ ] Lexicalライブラリのrenderメソッドの動作を確認
