---
generated_at: 2026-01-29 13:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-ニュースレターメール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/email-service/email-service.js` - メインサービス実装
- E-02: `ghost/core/core/server/services/email-service/batch-sending-service.js` - バッチ送信処理
- E-03: `ghost/core/core/server/services/email-service/email-renderer.js` - メールレンダリング
- E-04: `ghost/core/core/server/services/email-service/email-segmenter.js` - 購読者セグメント
- E-05: `ghost/core/core/server/services/email-service/sending-service.js` - Mailgun連携
- E-06: 通知一覧.csv - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 投稿公開時にニュースレターが配信される | E-01, E-06 | ○ |
| C-02 | バッチサイズは最大1000件/バッチ | E-02 (行250, 273) | ○ |
| C-03 | 並列送信は最大2バッチ同時 | E-02 (行12, 468) | ○ |
| C-04 | バッチ送信はジョブキュー経由で非同期実行 | E-02 (行122-129) | ○ |
| C-05 | scheduleEmail()でジョブを登録 | E-02 (行122-129) | ○ |
| C-06 | emailJob()がメイン送信処理 | E-02 (行135-192) | ○ |
| C-07 | createBatches()でバッチ作成 | E-02 (行239-342) | ○ |
| C-08 | sendBatches()でバッチ送信 | E-02 (行430-480) | ○ |
| C-09 | DB操作のリトライは最大10-20回 | E-02 (行39-40) | ○ |
| C-10 | Mailgun APIリトライは最大6回、10秒間隔 | E-02 (行41) | ○ |
| C-11 | emailsテーブルにステータス更新 | E-02 (行164-170, 185-190) | ○ |
| C-12 | email_batchesテーブルにバッチレコード作成 | E-02 (行393-398) | ○ |
| C-13 | email_recipientsテーブルに受信者レコード作成 | E-02 (行419-426) | ○ |
| C-14 | ステータスは'pending'→'submitting'→'submitted'/'failed' | E-02 (行144, 166, 188) | ○ |
| C-15 | ドメインウォームアップ機能対応 | E-02 (行243-246, 335-337) | ○ |
| C-16 | セグメント別配信対応（free/paid/all） | E-02 (行248, 253-256) | ○ |
| C-17 | getBatchMembers()で受信者取得 | E-02 (行610-636) | ○ |
| C-18 | updateStatusLock()でステータスロック | E-02 (行647-660) | ○ |
| C-19 | retryDb()でリトライ処理 | E-02 (行676-729) | ○ |
| C-20 | 送信失敗時はエラーメッセージを保存 | E-02 (行577-587) | ○ |
| C-21 | 部分失敗時はemailErrorPartialFailureメッセージ | E-02 (行7-8, 471-475) | ○ |
| C-22 | 全失敗時はemailErrorメッセージ | E-02 (行9, 476-478) | ○ |
| C-23 | getDeliveryDeadline()で配信期限計算 | E-02 (行737-750) | ○ |
| C-24 | calculateDeliveryTimes()で配信時刻分散 | E-02 (行757-774) | ○ |
| C-25 | EmailBodyCacheでレンダリング結果キャッシュ | E-02 (行438) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要な主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: バッチ送信ロジック（コードで確認済み）
- **0（低リスク）**: リトライ設定（コードで確認済み）
- **0（低リスク）**: ドメインウォームアップ機能

## 6) レビュアーチェックリスト（最小）
- [ ] email-service.jsのcreateEmail()実装を確認
- [ ] sending-service.jsのMailgun連携を確認
- [ ] email-renderer.jsのレンダリング処理を確認
