---
generated_at: 2026-01-29 13:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-新規コメント通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/comments/comments-service-emails.js` - メインサービス実装
- E-02: `ghost/core/core/server/services/comments/comments-service-email-renderer.js` - レンダラー実装
- E-03: `ghost/core/core/server/services/comments/email-templates/new-comment.hbs` - HTMLテンプレート
- E-04: 通知一覧.csv - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 新規コメント投稿時に著者へメール通知 | E-01 (行35-78), E-04 | ○ |
| C-02 | 件名は「New comment on your post: {postTitle}」 | E-01 (行45) | ○ |
| C-03 | comment_notificationsがtrueの著者にのみ送信 | E-01 (行40-42) | ○ |
| C-04 | 投稿の全著者をループ処理 | E-01 (行39) | ○ |
| C-05 | コメント投稿者名がない場合は'Anonymous' | E-01 (行47) | ○ |
| C-06 | commentPermalinksフラグでURL形式が変わる | E-01 (行29-32) | ○ |
| C-07 | labsフラグON時は#ghost-comments-{commentId} | E-01 (行30) | ○ |
| C-08 | labsフラグOFF時は#ghost-comments-root | E-01 (行32) | ○ |
| C-09 | templateDataにsiteTitle, siteUrl, siteDomain等含む | E-01 (行49-63) | ○ |
| C-10 | memberInitialsはextractInitials()で生成 | E-01 (行59), E-01 (行208-212) | ○ |
| C-11 | extractInitials()は名前からイニシャルを抽出 | E-01 (行208-212) | ○ |
| C-12 | Handlebarsでテンプレートレンダリング | E-02 (行8, 26) | ○ |
| C-13 | 't'ヘルパーでi18n対応 | E-02 (行9-17) | ○ |
| C-14 | 'concat'ヘルパーで文字列連結 | E-02 (行18-21) | ○ |
| C-15 | renderEmailTemplate()でHTML/テキスト生成 | E-02 (行24-33) | ○ |
| C-16 | 送信元はgetMembersSupportAddress() | E-01 (行204-206) | ○ |
| C-17 | sendMail()でforceTextContent: true設定 | E-01 (行221) | ○ |
| C-18 | 本番以外では本文をログ出力 | E-01 (行215-217) | ○ |
| C-19 | staffUrlは/settings/staff/{slug}/email-notifications | E-01 (行63) | ○ |
| C-20 | preheaderは「Someone left a comment on your post」 | E-03 (行114) | ○ |
| C-21 | View commentsボタンでpostUrlへリンク | E-03 (行160) | ○ |
| C-22 | commentHtmlは三重中括弧でエスケープなし出力 | E-03 (行147) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要な主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: テンプレート構造、変数（コードで確認済み）
- **0（低リスク）**: 送信条件とループ処理
- **0（低リスク）**: URLフラグメント生成

## 6) レビュアーチェックリスト（最小）
- [ ] CommentCreatedEventのイベントハンドラー登録を確認
- [ ] new-comment.txt.jsのテキストテンプレート実装を確認
- [ ] comment_notificationsのデフォルト値を確認
