---
generated_at: 2026-01-29 13:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-コメント返信通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/comments/comments-service-emails.js` - メインサービス実装
- E-02: `ghost/core/core/server/services/comments/comments-service-email-renderer.js` - レンダラー実装
- E-03: `ghost/core/core/server/services/comments/email-templates/new-comment-reply.hbs` - HTMLテンプレート
- E-04: 通知一覧.csv - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コメント返信時に親コメント投稿者へメール通知 | E-01 (行80-139), E-04 | ○ |
| C-02 | 件名は「New reply to your comment on {siteTitle}」 | E-01 (行101-104) | ○ |
| C-03 | type='in_reply_to'の場合はin_reply_to_idで親コメント取得 | E-01 (行82-83) | ○ |
| C-04 | type='parent'の場合はparent_idで親コメント取得 | E-01 (行85) | ○ |
| C-05 | 親コメントのstatusが'published'でないと送信しない | E-01 (行89) | ○ |
| C-06 | enable_comment_notificationsがfalseだと送信しない | E-01 (行89) | ○ |
| C-07 | 自己返信（parentMember.id === memberId）には送信しない | E-01 (行96-98) | ○ |
| C-08 | 返信投稿者名がない場合は'Anonymous' | E-01 (行109) | ○ |
| C-09 | templateDataにsiteTitle, siteUrl, siteDomain等含む | E-01 (行111-126) | ○ |
| C-10 | replyHtml, replyDateを使用（commentHtml, commentDateでない） | E-01 (行117-118) | ○ |
| C-11 | profileUrlはcreateUnsubscribeUrl(uuid, {comments: true}) | E-01 (行125) | ○ |
| C-12 | new-comment-reply.hbsでレンダリング | E-01 (行131) | ○ |
| C-13 | テンプレートはi18n対応（{{t '...'}}形式） | E-03 (行6, 114, 123-124) | ○ |
| C-14 | preheaderは「Someone just replied to your comment」 | E-03 (行114) | ○ |
| C-15 | View commentsボタンのラベルは「View comments」 | E-03 (行160) | ○ |
| C-16 | 購読解除リンクは「Unsubscribe from comment reply notifications」 | E-03 (行182) | ○ |
| C-17 | replyHtmlは三重中括弧でエスケープなし出力 | E-03 (行147) | ○ |
| C-18 | memberInitials, memberName, memberExpertise表示 | E-03 (行134, 138-139) | ○ |
| C-19 | replyDateはD MMM YYYY形式 | E-01 (行118) | ○ |
| C-20 | Handlebarsの'concat'ヘルパー使用 | E-03 (行124, 177) | ○ |
| C-21 | フッターにsiteDomain, toEmail表示 | E-03 (行177) | ○ |
| C-22 | sendMail()でforceTextContent: true設定 | E-01 (行221) | ○ |
| C-23 | notifyParentCommentAuthorはPromiseを返す | E-01 (行133) | ○ |
| C-24 | parent.related('member')で親コメント投稿者取得 | E-01 (行87) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要な主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: テンプレート構造、変数（コードで確認済み）
- **0（低リスク）**: 送信条件チェック（3条件すべて確認済み）
- **0（低リスク）**: 購読解除URL生成

## 6) レビュアーチェックリスト（最小）
- [ ] CommentReplyCreatedEventのイベントハンドラー登録を確認
- [ ] new-comment-reply.txt.jsのテキストテンプレート実装を確認
- [ ] createUnsubscribeUrl()の{comments: true}オプション動作を確認
- [ ] enable_comment_notificationsのデフォルト値を確認
