---
generated_at: 2026-01-29 12:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 38
  claims_without_evidence: 7
confidence_derived: 0.84
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.84**
  - 根拠あり：38 / 45、根拠なし：7
- 優先レビュー（高）
  1. **コメント管理機能の詳細**：画面設計書に詳細なコメント管理画面の記載が見つからない
  2. **パスワードリセットの詳細手順**：画面設計書にリセット確認画面の詳細が不足
  3. **エラーメッセージの網羅性**：実際のエラーケースをすべて網羅しているか要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - システム概要
- E-02: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移・構成
- E-03: `docs/code-to-docs/画面設計書/1-サインイン画面.md` - サインイン画面の仕様
- E-04: `docs/code-to-docs/画面設計書/11-投稿一覧画面.md` - 投稿一覧画面の仕様
- E-05: `docs/code-to-docs/画面設計書/13-エディタ画面.md` - エディタ画面の仕様
- E-06: `docs/code-to-docs/画面設計書/17-メンバー一覧画面.md` - メンバー一覧画面の仕様
- E-07: `docs/code-to-docs/画面設計書/32-設定画面.md` - 設定画面の仕様
- E-08: `docs/code-to-docs/機能設計書/1-記事管理.md` - 記事管理機能の仕様
- E-09: `docs/code-to-docs/機能設計書/19-ニュースレター配信.md` - ニュースレター配信機能の仕様
- E-10: `CLAUDE.md` - プロジェクト概要・技術スタック

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Ghostはパブリッシングプラットフォームである | E-01, E-10 | ○ |
| C-02 | ログインにはメールアドレスとパスワードが必要 | E-03 | ○ |
| C-03 | サインイン画面URL `/ghost/signin` | E-03 | ○ |
| C-04 | 2段階認証（2FA）に対応している | E-03 | ○ |
| C-05 | パスワードリセット機能がある | E-03 | ○ |
| C-06 | パスワードリセットの詳細手順 | **根拠不足** | △ |
| C-07 | ホーム画面にPosts/Pages/Tags/Members/Stats/Settingsメニューがある | E-02 | ○ |
| C-08 | 新規投稿は「New post」ボタンから作成 | E-04, E-05 | ○ |
| C-09 | エディタでLexical形式のリッチテキスト編集が可能 | E-05 | ○ |
| C-10 | 自動保存は3秒後、強制保存は60秒ごと | E-05 | ○ |
| C-11 | 利用可能なコンテンツブロック（画像、ギャラリー等） | E-05 | ○ |
| C-12 | タグ設定が可能 | E-04, E-08 | ○ |
| C-13 | 公開範囲（Public/Members/Paid-members/Tiers）設定が可能 | E-04, E-08 | ○ |
| C-14 | 即時公開・予約投稿が可能 | E-08 | ○ |
| C-15 | 予約日時は2分以上先を指定 | E-08 | ○ |
| C-16 | ニュースレター配信設定が可能 | E-09 | ○ |
| C-17 | Mailgun APIでメール送信 | E-09 | ○ |
| C-18 | メンバー一覧でフィルタリングが可能 | E-06 | ○ |
| C-19 | メンバーのインポート・エクスポートが可能 | E-06 | ○ |
| C-20 | CSVファイル形式でインポート | E-06 | ○ |
| C-21 | ユーザー権限（Owner/Administrator/Editor/Author/Contributor） | E-03, E-04, E-05, E-08 | ○ |
| C-22 | Contributorは下書きのみ作成可能 | E-04, E-08 | ○ |
| C-23 | 設定画面は6カテゴリに分かれている | E-07 | ○ |
| C-24 | テーマの変更が可能 | E-07 | ○ |
| C-25 | スタッフの招待が可能 | E-07 | ○ |
| C-26 | 統計・分析画面でアクセス解析が可能 | E-02 | ○ |
| C-27 | 投稿履歴（Post history）から復元可能 | E-05 | ○ |
| C-28 | 対応ブラウザ（Chrome/Edge/Safari/Firefox） | **根拠不足** | △ |
| C-29 | コメント管理機能の詳細 | **根拠不足** | △ |
| C-30 | コメントのモデレーション操作 | **根拠不足** | △ |
| C-31 | プロフィール編集が可能 | E-07 | ○ |
| C-32 | 画面左下にユーザーアイコンがある | E-02 | ○ |
| C-33 | 「/」キーでコマンドメニュー表示 | E-05 | ○ |
| C-34 | 「+」ボタンでコンテンツ追加 | E-05 | ○ |
| C-35 | アイキャッチ画像設定が可能 | E-05, E-08 | ○ |
| C-36 | SEO設定（メタタイトル・説明）が可能 | E-05, E-08 | ○ |
| C-37 | SNSシェア設定（Twitter/Facebook）が可能 | E-05 | ○ |
| C-38 | プレビュー機能がある | E-05 | ○ |
| C-39 | 一括操作（ラベル追加・削除など）が可能 | E-06 | ○ |
| C-40 | 検索機能がある | E-06 | ○ |
| C-41 | エラーメッセージ一覧の網羅性 | **根拠不足** | △ |
| C-42 | 手動保存（Cmd/Ctrl+S）が可能 | E-05 | ○ |
| C-43 | 記事の非公開・削除が可能 | E-04, E-08 | ○ |
| C-44 | メール開封率の確認が可能 | E-06 | ○ |
| C-45 | Labs機能（実験的機能）がある | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）

- **コメント管理機能の詳細**
  - 理由：画面設計書にコメント管理画面（93-コメント一覧）が存在するが、詳細な操作手順が確認できなかった
  - 候補：`docs/code-to-docs/画面設計書/93-コメント一覧.md` を詳細確認 / 実際の管理画面で確認

- **パスワードリセット確認画面**
  - 理由：パスワードリセット画面（4-パスワードリセット画面）の設計書は存在するが、リセット後の確認フローが不明確
  - 候補：`docs/code-to-docs/画面設計書/4-パスワードリセット画面.md` を詳細確認

- **対応ブラウザ**
  - 理由：公式ドキュメントまたは設計書に明確な記載がない
  - 候補：Ghost公式ドキュメント（ghost.org/docs）で確認

- **エラーメッセージの網羅性**
  - 理由：各画面設計書にエラーメッセージが記載されているが、すべてを網羅しているか未確認
  - 候補：実際の運用環境で発生しうるエラーケースをテスト

## 5) リスクフラグ（レビュー観点）

- **1: 中リスク** - コメント管理機能の記述が不十分。実際のUIと異なる可能性あり
- **1: 中リスク** - エラーメッセージ一覧が網羅的でない可能性あり
- **0: 低リスク** - 対応ブラウザは一般的な記述であり、大きな問題なし
- **0: 低リスク** - パスワードリセット手順は基本的な流れを記載済み

## 6) レビュアーチェックリスト（最小）

- [ ] サインイン画面の実際の表示とマニュアル記載が一致しているか確認
- [ ] エディタ画面の操作手順が実際の操作と一致しているか確認
- [ ] ニュースレター配信の設定画面とマニュアル記載が一致しているか確認
- [ ] メンバー管理画面の操作手順が実際の操作と一致しているか確認
- [ ] 設定画面のカテゴリ構成が実際の画面と一致しているか確認
- [ ] コメント管理機能の詳細を実際の画面で確認し、必要に応じて追記
- [ ] エラーメッセージ一覧に追加すべきものがないか確認
- [ ] 各ユーザー権限での操作制限が正しく記載されているか確認
