# Ghost 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [ログイン・ログアウト手順](#2-ログインログアウト手順)
3. [トップページ（ホーム画面）](#3-トップページホーム画面)

**【業務フローに沿った機能】**
4. [【STEP1】コンテンツ計画・作成（記事の作成）](#4-step1コンテンツ計画作成記事の作成)
5. [【STEP2-3】コンテンツ編集・レビュー（記事の編集・確認）](#5-step2-3コンテンツ編集レビュー記事の編集確認)
6. [【STEP3-4】コンテンツ公開・配信（記事の公開・ニュースレター配信）](#6-step3-4コンテンツ公開配信記事の公開ニュースレター配信)
7. [【STEP4-5】メンバー管理・分析（購読者管理・効果測定）](#7-step4-5メンバー管理分析購読者管理効果測定)

**【サポート機能】**
8. [コメント管理機能](#8-コメント管理機能)
9. [設定機能](#9-設定機能)
10. [ユーザー管理機能](#10-ユーザー管理機能)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 Ghostとは

Ghostは、プロフェッショナルなパブリッシング（コンテンツ配信）を支援するオープンソースのコンテンツ管理システム（CMS）です。ブログ記事の作成・公開、ニュースレターの配信、有料メンバーシップの運営を統合的に行うことができます。

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **コンテンツ作成** | 記事の作成、ページの作成、アイキャッチ画像の設定、タグ付け |
| **コンテンツ配信** | 記事の公開、予約投稿、ニュースレター配信、公開範囲の設定 |
| **メンバー管理** | 購読者の管理、有料会員の管理、メンバーのインポート・エクスポート |
| **分析・改善** | 閲覧数の確認、メンバー増加の分析、ニュースレター開封率の確認 |
| **サイト設定** | テーマの変更、ナビゲーションの設定、メール配信の設定 |

### 1.3 業務フロー概要

本システムにおける業務は、以下の流れで進行します：

```
+----------------------------------------------------------------------+
|                        業務フロー                                     |
+----------------------------------------------------------------------+
|                                                                      |
|  【STEP 1】コンテンツ計画・作成                                       |
|      記事のアイデアを整理し、エディタで記事を執筆します                 |
|      ↓                                                               |
|  【STEP 2】コンテンツ編集・レビュー                                    |
|      下書きを確認し、タグや公開設定を行います                          |
|      ↓                                                               |
|  【STEP 3】コンテンツ公開・配信                                        |
|      記事を公開し、必要に応じてニュースレターとして配信します           |
|      ↓                                                               |
|  【STEP 4】メンバー管理・分析                                          |
|      購読者の管理と、記事の閲覧状況を分析します                        |
|      ↓                                                               |
|  【STEP 5】改善・次のコンテンツ計画                                    |
|      分析結果をもとに、次のコンテンツ計画を立てます                    |
|                                                                      |
+----------------------------------------------------------------------+
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **Owner/Administrator** | サイト全体の設定管理、スタッフの管理、全記事の編集・公開、メンバー管理 |
| **Editor** | 全スタッフの記事の編集・公開、タグ管理 |
| **Author** | 自分の記事の作成・編集・公開 |
| **Contributor** | 自分の下書き記事の作成のみ（公開はEditor以上が行う） |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| 記事管理 | 記事の作成・編集・削除・公開 | STEP 1-3 |
| ページ管理 | 固定ページの作成・編集 | STEP 1-3 |
| タグ管理 | 記事の分類・整理 | STEP 1-2 |
| メンバー管理 | 購読者の管理・分析 | STEP 4 |
| 統計・分析 | アクセス解析・メール分析 | STEP 4-5 |
| ニュースレター | メール配信機能 | STEP 3 |
| テーマ設定 | サイトデザインの変更 | 随時利用 |
| 設定 | サイト全般の設定 | 随時利用 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| Owner | サイト所有者。すべての機能にアクセス可能 |
| Administrator | 管理者。Owner以外のすべての機能にアクセス可能 |
| Editor | 編集者。全スタッフの記事を編集・公開可能 |
| Author | 著者。自分の記事のみ作成・編集・公開可能 |
| Contributor | 寄稿者。下書きのみ作成可能（公開不可） |

### 1.6 対応ブラウザ

推奨ブラウザ：
- Google Chrome（最新版）
- Microsoft Edge（最新版）
- Safari（最新版）
- Firefox（最新版）

---

## 2. ログイン・ログアウト手順

### 2.1 ログイン方法

1. ブラウザでGhost管理画面のURL（`https://あなたのサイト/ghost/`）にアクセスします
2. サインイン画面が表示されます

**入力項目：**

| 項目 | 入力内容 |
|------|---------|
| メールアドレス | スタッフとして登録されているメールアドレス |
| パスワード | 設定したパスワード |

3. 「Sign in」ボタンをクリックします
4. 認証に成功すると、ホーム画面（ダッシュボード）が表示されます

**注意事項：**
- 2段階認証（2FA）が有効な場合は、確認コードの入力が求められます
- 複数回ログインに失敗すると、アカウントが一時的にロックされる場合があります

### 2.2 ログアウト方法

1. 画面左下のユーザーアイコン（プロフィール画像）をクリックします
2. 表示されるメニューから「Sign out」を選択します
3. サインイン画面に戻ります

### 2.3 パスワードを忘れた場合

1. サインイン画面で「Forgot?」リンクをクリックします
2. 登録済みのメールアドレスを入力します
3. パスワードリセット用のメールが送信されます
4. メール内のリンクをクリックして、新しいパスワードを設定します

---

## 3. トップページ（ホーム画面）

### 3.1 ホーム画面の構成

ログイン後に表示されるホーム画面（ダッシュボード）では、以下の情報を確認できます：

**左側サイドバー：**
- 「Home」- ダッシュボードへ戻る
- 「Posts」- 投稿一覧画面へ
- 「Pages」- ページ一覧画面へ
- 「Tags」- タグ一覧画面へ
- 「Members」- メンバー一覧画面へ（Editor以上）
- 「Stats」- 統計画面へ
- 「Settings」- 設定画面へ（Administrator以上）

**メインエリア：**
- サイトの概要情報
- 最近の活動
- クイックアクション（新規投稿作成など）

### 3.2 クイック操作

ホーム画面から以下の操作を素早く行えます：

| 操作 | 方法 |
|------|------|
| 新規投稿作成 | 「New post」ボタンをクリック |
| サイトプレビュー | サイドバー上部のサイト名をクリック |
| 設定変更 | サイドバーの「Settings」をクリック |

---

## 4. 【STEP1】コンテンツ計画・作成（記事の作成）

> **業務フローでの位置**: 新しいコンテンツを作成する最初のステップです。記事のアイデアを整理し、エディタで執筆します。

### 4.1 新規記事を作成する

1. サイドバーの「Posts」をクリックして投稿一覧画面を開きます
2. 画面右上の「New post」ボタンをクリックします
3. エディタ画面が表示されます

### 4.2 エディタ画面での操作

**タイトルの入力：**
1. 「Post title」と表示されている欄をクリックします
2. 記事のタイトルを入力します

**本文の入力：**
1. タイトルの下の本文エリアをクリックします
2. 文章を入力します
3. 以下の方法でリッチコンテンツを追加できます：
   - 「/」キーを押すとコマンドメニューが表示されます
   - 「+」ボタンをクリックして画像や埋め込みを追加できます

**利用可能なコンテンツブロック：**

| ブロック | 説明 | 挿入方法 |
|---------|------|---------|
| 画像 | 写真や図を挿入 | `/image` と入力または「+」ボタン |
| ギャラリー | 複数の画像をギャラリー形式で表示 | `/gallery` と入力 |
| 埋め込み | YouTube、Twitterなどを埋め込み | `/embed` と入力またはURLを貼り付け |
| 引用 | 引用文を強調表示 | `/quote` と入力 |
| 区切り線 | セクション区切り | `/divider` と入力 |
| コールアウト | 重要な情報を強調 | `/callout` と入力 |
| ブックマーク | Webページのプレビュー | `/bookmark` と入力 |

### 4.3 アイキャッチ画像の設定

1. エディタ画面上部の「Add feature image」をクリックします
2. 画像をアップロードするか、Unsplashから選択します
3. 必要に応じてAltテキスト（代替テキスト）を設定します

### 4.4 下書きの保存

- 入力内容は自動的に保存されます（「Saving...」「Saved」と表示）
- 手動で保存する場合は「Cmd+S」（Mac）または「Ctrl+S」（Windows）を押します

---

## 5. 【STEP2-3】コンテンツ編集・レビュー（記事の編集・確認）

> **業務フローでの位置**: 作成した下書きを確認し、タグや公開設定を行うステップです。

### 5.1 投稿設定パネルを開く

1. エディタ画面右上の設定アイコン（歯車マーク）をクリックします
2. 投稿設定パネルが画面右側にスライドインします

### 5.2 基本設定

**URLスラッグの設定：**
1. 「Post URL」欄で記事のURLを確認・編集します
2. 自動生成されたスラッグを必要に応じて変更します

**タグの設定：**
1. 「Tags」欄をクリックします
2. 既存のタグを選択するか、新しいタグ名を入力します
3. 複数のタグを設定できます

**著者の設定：**
1. 「Authors」欄をクリックします
2. 共著者を追加する場合は著者を選択します

### 5.3 公開範囲の設定

「Post access」欄で、記事を閲覧できるユーザーを設定します：

| 設定 | 説明 |
|------|------|
| Public | 誰でも閲覧可能 |
| Members only | サインインしたメンバーのみ閲覧可能 |
| Paid-members only | 有料会員のみ閲覧可能 |
| Specific tier(s) | 特定のティア（プラン）の会員のみ閲覧可能 |

### 5.4 SEO・SNS設定

**メタデータの設定：**
1. 「Meta data」セクションを展開します
2. 以下を設定できます：
   - Meta title（検索結果に表示されるタイトル）
   - Meta description（検索結果に表示される説明文）

**SNSシェア設定：**
1. 「Twitter card」「Facebook card」セクションを展開します
2. SNSでシェアされた際の表示をカスタマイズできます

### 5.5 記事のプレビュー

1. エディタ画面右上の「Preview」ボタンをクリックします
2. 公開前の記事の見た目を確認できます
3. デスクトップ/モバイルの切り替えが可能です

---

## 6. 【STEP3-4】コンテンツ公開・配信（記事の公開・ニュースレター配信）

> **業務フローでの位置**: 編集が完了した記事を公開し、必要に応じてニュースレターとして購読者に配信するステップです。

### 6.1 即時公開

1. エディタ画面右上の「Publish」ボタンをクリックします
2. 公開確認画面が表示されます
3. 「Publish」を選択し、「Continue, final review」をクリックします
4. 最終確認後、「Publish post, right now」をクリックします

### 6.2 予約投稿

1. 「Publish」ボタンをクリックします
2. 「Right now」の代わりに「Schedule for later」を選択します
3. 公開日時を設定します
4. 「Schedule」をクリックして予約を確定します

**注意事項：**
- 予約日時は現在時刻から2分以上先を指定する必要があります
- 予約投稿は「Scheduled」タブで確認できます

### 6.3 ニュースレターとして配信

記事を公開すると同時に、メールでメンバーに配信できます。

1. 「Publish」ボタンをクリックします
2. 「Email newsletter」セクションで配信設定を行います：
   - 「Send to」で配信対象を選択します
   - ニュースレターを選択します
3. 「Publish and send」を選択して公開と配信を同時に行います

**配信対象の選択肢：**

| 選択肢 | 説明 |
|--------|------|
| All members | 全メンバーに配信 |
| Free members | 無料会員のみに配信 |
| Paid members | 有料会員のみに配信 |
| Specific segment | 特定のセグメント（条件）に配信 |

### 6.4 公開済み記事の更新

1. 投稿一覧から編集したい記事をクリックします
2. 内容を編集します
3. 「Update」ボタンをクリックして変更を保存します

**注意事項：**
- 既に公開済みの記事を更新しても、ニュースレターは再送信されません
- 変更内容は即座にサイトに反映されます

### 6.5 記事の非公開・削除

**非公開にする場合：**
1. 投稿一覧で該当記事を右クリックします
2. 「Unpublish」を選択します
3. 記事は下書き状態に戻ります

**削除する場合：**
1. エディタ画面の設定パネルを開きます
2. 一番下の「Delete post」をクリックします
3. 確認ダイアログで「Delete」をクリックします

---

## 7. 【STEP4-5】メンバー管理・分析（購読者管理・効果測定）

> **業務フローでの位置**: 購読者を管理し、記事のパフォーマンスを分析して次のコンテンツ計画に活かすステップです。

### 7.1 メンバー一覧の確認

1. サイドバーの「Members」をクリックします
2. メンバー一覧画面が表示されます

**表示される情報：**
- メンバー名またはメールアドレス
- ステータス（Free/Paid/Comped）
- メール開封率（設定有効時）
- 登録日

### 7.2 メンバーのフィルタリング

画面上部のフィルターを使用して、メンバーを絞り込むことができます：

| フィルター | 説明 |
|-----------|------|
| All members | 全メンバーを表示 |
| Free members | 無料会員のみ表示 |
| Paid members | 有料会員のみ表示 |
| ラベル | 特定のラベルが付いたメンバーを表示 |

### 7.3 メンバー詳細の確認

1. メンバー一覧で確認したいメンバーをクリックします
2. メンバー詳細画面が表示されます

**確認できる情報：**
- 基本情報（名前、メールアドレス）
- 購読しているニュースレター
- サブスクリプション情報（有料会員の場合）
- アクティビティ履歴

### 7.4 メンバーのインポート

1. メンバー一覧画面の「...」メニューをクリックします
2. 「Import members」を選択します
3. CSVファイルをアップロードします

**CSVファイルの形式：**
- email（必須）: メールアドレス
- name: 名前
- labels: ラベル（カンマ区切り）

### 7.5 メンバーのエクスポート

1. メンバー一覧画面の「...」メニューをクリックします
2. 「Export all members」を選択します
3. CSVファイルがダウンロードされます

### 7.6 統計・分析の確認

**サイト統計の確認：**
1. サイドバーの「Stats」をクリックします
2. 以下の情報を確認できます：
   - Webトラフィック（アクセス数）
   - メンバーの増減
   - ニュースレターのパフォーマンス

**個別記事の分析：**
1. 投稿一覧で分析したい記事の統計アイコンをクリックします
2. 記事の詳細な分析データを確認できます：
   - 閲覧数
   - メール開封率（配信した場合）
   - リンククリック数

---

## 8. コメント管理機能

### 8.1 コメントの確認

メンバーから投稿されたコメントを管理できます。

1. 設定画面から「Membership」>「Access」を開きます
2. コメント設定を確認します

### 8.2 コメントのモデレーション

不適切なコメントがある場合は、以下の操作が可能です：

- コメントの非表示
- コメントの削除
- コメント投稿者のブロック

---

## 9. 設定機能

### 9.1 設定画面へのアクセス

1. サイドバーの「Settings」をクリックします
2. 設定画面が表示されます

### 9.2 主要な設定カテゴリ

**General（一般設定）：**
- Title and description: サイト名と説明
- Time zone: タイムゾーン
- Publication language: サイトの言語
- Users: スタッフの管理

**Site（サイト設定）：**
- Design: デザインのカスタマイズ
- Theme: テーマの変更・アップロード
- Navigation: メニューの編集
- Announcement bar: お知らせバーの設定

**Membership（メンバーシップ設定）：**
- Access: 登録設定
- Tiers: 料金プランの設定
- Portal: 会員ポータルの設定

**Email newsletter（メール設定）：**
- Enable newsletters: ニュースレターの有効化
- Newsletters: ニュースレターの管理
- Mailgun: メール配信設定

**Growth（成長設定）：**
- Recommendations: 他サイトのおすすめ設定
- Offers: 割引オファーの設定

**Advanced（高度な設定）：**
- Integrations: 外部サービス連携
- Code injection: カスタムコードの挿入
- Labs: 実験的機能
- Danger zone: 危険な操作（データ削除など）

### 9.3 テーマの変更

1. 「Settings」>「Site」>「Theme」を開きます
2. 「Change theme」をクリックします
3. 以下の方法でテーマを変更できます：
   - 公式テーマから選択
   - カスタムテーマをアップロード

---

## 10. ユーザー管理機能

### 10.1 スタッフの招待

1. 「Settings」>「General」>「Users」を開きます
2. 「Invite people」をクリックします
3. 招待するユーザーのメールアドレスを入力します
4. 役割（Administrator/Editor/Author/Contributor）を選択します
5. 「Send invitation」をクリックします

### 10.2 スタッフの権限変更

1. 「Settings」>「General」>「Users」を開きます
2. 変更したいユーザーをクリックします
3. 「Role」ドロップダウンで新しい役割を選択します
4. 「Save」をクリックします

### 10.3 自分のプロフィール編集

1. 画面左下のプロフィール画像をクリックします
2. 「Your profile」を選択します
3. 以下の情報を編集できます：
   - 名前
   - プロフィール画像
   - カバー画像
   - 自己紹介
   - SNSリンク

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
============================================================
【STEP 1】コンテンツ計画・作成 -> 4章参照
    ↓
【STEP 2】コンテンツ編集・レビュー -> 5章参照
    ↓
【STEP 3】コンテンツ公開・配信 -> 6章参照
    ↓
【STEP 4】メンバー管理・分析 -> 7章参照
    ↓
【STEP 5】改善・次のコンテンツ計画 -> 分析結果をもとに次のコンテンツへ
============================================================
```

### 11.1 【Author/Contributor】STEP1: 記事の作成

新規コンテンツを作成する場合の手順：

1. 「Posts」画面を開きます
2. 「New post」をクリックしてエディタを開きます
3. タイトルと本文を入力します
4. アイキャッチ画像を設定します
5. タグを設定します
6. 下書きとして保存されます

**Contributorの場合：**
- 下書きの作成までで完了です
- 公開はEditorまたはAdministratorに依頼します

### 11.2 【Editor/Administrator】STEP2: 記事のレビュー

下書き記事をレビュー・編集する場合の手順：

1. 「Posts」画面で「Drafts」タブを開きます
2. レビューする記事をクリックします
3. 内容を確認・修正します
4. タグ、公開範囲などの設定を確認します
5. 問題なければ公開に進みます

### 11.3 【Author/Editor/Administrator】STEP3: 記事の公開

記事を公開する場合の手順：

1. エディタ画面で「Publish」をクリックします
2. 公開方法を選択します：
   - 「Right now」: 即時公開
   - 「Schedule」: 予約投稿
3. ニュースレター配信を行う場合は設定します
4. 「Publish」または「Schedule」をクリックして確定します

### 11.4 【Editor/Administrator】STEP4-5: 分析と改善

公開後の分析とフィードバックを行う手順：

1. 「Stats」画面でサイト全体の統計を確認します
2. 個別記事の分析を確認します
3. メンバーの反応（コメント、開封率）を確認します
4. 分析結果をもとに次のコンテンツ計画を立てます

---

## 12. よくある質問と対処法

### 12.1 ログインに関するQ&A

**Q: ログインできません**

A: 以下を確認してください：
- メールアドレスとパスワードが正しいか確認してください
- Caps Lockがオンになっていないか確認してください
- 「Forgot?」リンクからパスワードをリセットしてください
- 複数回失敗した場合は、数分待ってから再試行してください

**Q: 2段階認証のコードが届きません**

A: 以下を確認してください：
- 認証アプリの設定を確認してください
- 迷惑メールフォルダを確認してください
- Administratorに連絡して2FAのリセットを依頼してください

### 12.2 記事作成に関するQ&A

**Q: 下書きが保存されているか不安です**

A: エディタ画面上部に「Saved」と表示されていれば保存されています。自動保存は3秒ごとに行われます。

**Q: 画像がアップロードできません**

A: 以下を確認してください：
- 画像ファイルの形式（JPEG、PNG、GIF、WebP）を確認してください
- ファイルサイズが制限内か確認してください
- インターネット接続を確認してください

**Q: 予約投稿を取り消したい**

A: 投稿一覧の「Scheduled」タブから該当記事を開き、「Unschedule」をクリックしてください。記事は下書き状態に戻ります。

### 12.3 メンバー管理に関するQ&A

**Q: メンバーを一括で削除したい**

A: メンバー一覧画面でフィルターを設定し、「...」メニューから「Delete members」を選択してください。ただし、Stripeサブスクリプションがあるメンバーは個別対応が必要です。

**Q: メンバーのメールアドレスを変更したい**

A: メンバー詳細画面でメールアドレスを編集し、保存してください。

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| "There is no user with that email address." | 入力したメールアドレスが登録されていない | 正しいメールアドレスを入力してください |
| "Your password is incorrect." | パスワードが間違っている | 正しいパスワードを入力するか、リセットしてください |
| "Your account was suspended." | アカウントが停止されている | Administratorに連絡してください |
| "Saving failed" | 保存に失敗した | インターネット接続を確認し、再試行してください |
| "Unable to connect" | サーバーに接続できない | インターネット接続を確認してください |

### 13.2 よくあるトラブルと解決方法

**トラブル: 編集内容が消えた**

解決方法：
1. ブラウザの戻るボタンを押さないでください
2. 「Post history」機能で過去のリビジョンを確認してください
3. エディタ設定パネル下部の「Post history」をクリックします
4. 復元したいバージョンを選択して「Restore」をクリックします

**トラブル: ニュースレターが配信されない**

解決方法：
1. Mailgun設定を確認してください
2. 送信ステータスを確認してください
3. エラーがある場合は、「Retry」ボタンで再送信を試みてください

**トラブル: メンバーが登録できない**

解決方法：
1. 「Settings」>「Membership」>「Access」を確認してください
2. 登録が有効になっているか確認してください
3. Stripeの設定を確認してください（有料プランの場合）

### 13.3 サポートへの連絡方法

上記の対処法で解決しない場合は、以下の方法でサポートに連絡してください：

1. 公式ドキュメント（ghost.org/docs）を確認する
2. Ghost Forum（forum.ghost.org）で質問する
3. サイト管理者（Owner/Administrator）に連絡する

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-01-29 | 初版作成 |

---

*本マニュアルは、Ghost CMSのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
