---
generated_at: 2026-01-29 22:40:00
metrics:
  claims_total: 70
  claims_with_evidence: 58
  claims_without_evidence: 12
confidence_derived: 0.83
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された非機能要件テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：58 / 70、根拠なし：12
- 優先レビュー（高）
  1. **NFT-001～NFT-012（性能テスト）**：具体的な応答時間の閾値はコードから導出不可、業界標準を適用
  2. **NFT-044～NFT-048（スケーラビリティテスト）**：具体的なスケーラビリティ要件の定義が不明
  3. **NFT-057～NFT-060（ブラウザ互換性）**：対応ブラウザの明示的な定義がない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/web/shared/middleware/api/spam-prevention.js`
- E-02: `ghost/core/core/server/services/auth/session/session-service.js`
- E-03: `ghost/core/core/shared/config/env/config.production.json`
- E-04: `ghost/core/core/server/ghost-server.js`
- E-05: `ghost/core/core/server/adapters/cache/Redis.js`
- E-06: `ghost/core/core/server/adapters/lib/redis/AdapterCacheRedis.js`
- E-07: `ghost/core/core/server/lib/request-external.js`
- E-08: `ghost/core/package.json`
- E-09: `compose.yml`
- E-10: `compose.dev.yaml`
- E-11: `ghost/core/test/e2e-api/admin/rate-limiting.test.js`
- E-12: `ghost/core/test/e2e-api/admin/authentication.test.js`
- E-13: `ghost/core/core/server/data/schema/default-settings/default-settings.json`
- E-14: `ghost/core/core/server/api/endpoints/session.js`
- E-15: `ghost/core/core/server/api/endpoints/posts.js`
- E-16: `ghost/core/core/server/api/endpoints/members.js`
- E-17: `ghost/core/core/server/models/base/plugins/sanitize.js`
- E-18: `ghost/core/core/server/data/db/backup.js`
- E-19: `ghost/core/core/server/data/migrations/`
- E-20: `ghost/i18n/`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001: ログインAPI応答時間200ms以内 | E-14 | △ |
| C-02 | NFT-002: 投稿一覧API応答時間500ms以内 | E-15 | △ |
| C-03 | NFT-003: メンバー一覧API応答時間1000ms以内 | E-16 | △ |
| C-04 | NFT-004: 画像アップロードAPI応答時間3000ms以内 | **根拠なし** | △ |
| C-05 | NFT-005: フロントエンドページ表示時間2000ms以内 | **根拠なし** | △ |
| C-06 | NFT-006: 同時接続数100以上 | **根拠なし** | △ |
| C-07 | NFT-007: 1分間あたりの投稿作成数60件以上 | **根拠なし** | △ |
| C-08 | NFT-008: メモリ使用量512MB以下 | **根拠なし** | △ |
| C-09 | NFT-009: CPU使用率50%以下 | **根拠なし** | △ |
| C-10 | NFT-010: Redisキャッシュヒット率80%以上 | E-05, E-06 | △ |
| C-11 | NFT-011: キャッシュTTL動作確認 | E-06 | ○ |
| C-12 | NFT-012: MySQLクエリ応答時間100ms以内 | **根拠なし** | △ |
| C-13 | NFT-013: ログインレート制限5回で429 | E-01, E-11 | ○ |
| C-14 | NFT-014: パスワードリセットレート制限5回で429 | E-01 | ○ |
| C-15 | NFT-015: グローバルレート制限50回/時間 | E-01 | ○ |
| C-16 | NFT-016: メンバー認証レート制限 | E-01 | ○ |
| C-17 | NFT-017: OTP検証レート制限 | E-01 | ○ |
| C-18 | NFT-018: 2要素認証動作確認 | E-02, E-12 | ○ |
| C-19 | NFT-019: セッションCSRF保護 | E-02 | ○ |
| C-20 | NFT-020: APIキー認証 | E-01 | ○ |
| C-21 | NFT-021: ロールベースアクセス制御 | E-14 | ○ |
| C-22 | NFT-022: 投稿編集権限 | E-15 | ○ |
| C-23 | NFT-023: パスワードハッシュ化 | E-13 | ○ |
| C-24 | NFT-024: 機密情報のマスキング | E-14 | ○ |
| C-25 | NFT-025: SQLインジェクション対策 | E-17 | ○ |
| C-26 | NFT-026: XSS対策 | E-17 | ○ |
| C-27 | NFT-027: URLバリデーション | E-07 | ○ |
| C-28 | NFT-028: プライベートIP遮断 | E-07 | ○ |
| C-29 | NFT-029: HTTPS強制 | E-09 | ○ |
| C-30 | NFT-030: メールプレビューレート制限 | E-01 | ○ |
| C-31 | NFT-031: Webmentionsレート制限 | E-01 | ○ |
| C-32 | NFT-032: プライベートブログアクセス制限 | E-01 | ○ |
| C-33 | NFT-033: サーバー正常起動 | E-04 | ○ |
| C-34 | NFT-034: ポート使用中エラー | E-04 | ○ |
| C-35 | NFT-035: MySQLヘルスチェック | E-09 | ○ |
| C-36 | NFT-036: Redisヘルスチェック | E-09 | ○ |
| C-37 | NFT-037: Ghostヘルスチェック | E-10 | ○ |
| C-38 | NFT-038: MySQL依存起動 | E-09 | ○ |
| C-39 | NFT-039: Redis依存起動 | E-09 | ○ |
| C-40 | NFT-040: グレースフルシャットダウン | E-04 | ○ |
| C-41 | NFT-041: 自動再起動 | E-09 | ○ |
| C-42 | NFT-042: データベース接続切断復旧 | E-09 | ○ |
| C-43 | NFT-043: Redis接続切断復旧 | E-06 | ○ |
| C-44 | NFT-044: 10,000メンバー対応 | **根拠なし** | △ |
| C-45 | NFT-045: 10,000投稿対応 | **根拠なし** | △ |
| C-46 | NFT-046: 大量画像対応 | **根拠なし** | △ |
| C-47 | NFT-047: 複数ユーザー同時編集 | E-15 | ○ |
| C-48 | NFT-048: 大量メール配信 | E-16 | ○ |
| C-49 | NFT-049: ログレベル設定 | E-03 | ○ |
| C-50 | NFT-050: ログローテーション | E-03 | ○ |
| C-51 | NFT-051: エラーログ出力 | E-03 | ○ |
| C-52 | NFT-052: Prometheusメトリクス | E-09 | ○ |
| C-53 | NFT-053: Grafanaダッシュボード | E-09 | ○ |
| C-54 | NFT-054: デバッグモード有効化 | E-09 | ○ |
| C-55 | NFT-055: データベースバックアップ | E-18 | ○ |
| C-56 | NFT-056: データベースマイグレーション | E-19 | ○ |
| C-57 | NFT-057: Chrome最新版対応 | **根拠なし** | △ |
| C-58 | NFT-058: Firefox最新版対応 | **根拠なし** | △ |
| C-59 | NFT-059: Safari最新版対応 | **根拠なし** | △ |
| C-60 | NFT-060: Edge最新版対応 | **根拠なし** | △ |
| C-61 | NFT-061: Node.js 22.x対応 | E-08 | ○ |
| C-62 | NFT-062: MySQL 8.4対応 | E-09 | ○ |
| C-63 | NFT-063: SQLite対応 | E-03 | ○ |
| C-64 | NFT-064: Redis 7.0対応 | E-09 | ○ |
| C-65 | NFT-065: モバイル表示 | **根拠なし** | △ |
| C-66 | NFT-066: タブレット表示 | **根拠なし** | △ |
| C-67 | NFT-067: Content API v5互換 | E-14 | ○ |
| C-68 | NFT-068: Admin API v5互換 | E-14 | ○ |
| C-69 | NFT-069: 60言語以上のロケール対応 | E-20 | ○ |
| C-70 | NFT-070: Casperテーマ互換 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- **性能要件の具体的な閾値**：コードには明示的なSLA定義がない。API応答時間、スループット、リソース使用量の合格基準は一般的なベストプラクティスに基づいて設定した。
  - 候補：SLA定義書 / 性能要件定義書 / 負荷テスト結果レポート
- **スケーラビリティ要件**：最大メンバー数、最大投稿数などの明示的な定義がコードベースにない。
  - 候補：要件定義書 / キャパシティプランニング文書
- **ブラウザ互換性**：明示的な対応ブラウザリストがない。一般的なモダンブラウザを対象とした。
  - 候補：要件定義書 / 互換性マトリクス
- **レスポンシブデザイン**：明示的なブレークポイント定義がない。
  - 候補：デザインガイドライン / UIスタイルガイド

## 5) リスクフラグ（レビュー観点）
- **1 (中リスク)**: 性能要件（NFT-001～NFT-012）の合格基準は推定値のため、本番環境での実測値と照合が必要
- **1 (中リスク)**: スケーラビリティ要件（NFT-044～NFT-048）は実際の利用規模に応じた調整が必要
- **0 (低リスク)**: セキュリティテスト（NFT-013～NFT-032）はコードに基づく根拠あり
- **0 (低リスク)**: 可用性テスト（NFT-033～NFT-043）はDocker Compose設定に基づく根拠あり
- **1 (中リスク)**: ブラウザ互換性（NFT-057～NFT-060）は明示的な要件がないため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] 性能要件の閾値がビジネス要件と合致しているか確認
- [ ] レート制限の設定値が運用要件に適切か確認
- [ ] スケーラビリティ要件が想定利用規模に対応しているか確認
- [ ] ブラウザ互換性の対象範囲が適切か確認
- [ ] ヘルスチェックの間隔・リトライ回数が運用要件に適切か確認
- [ ] ログローテーション設定が運用環境に適切か確認
- [ ] セキュリティテストの網羅性が十分か確認（OWASP Top 10等との照合）
