---
generated_at: 2026-01-29 12:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **稼働率・RTO・RPO要件**：インフラレベルの設定のため根拠なし
  2. **計画停止時間**：アプリケーションコードに明示的な設定なし
  3. **API応答時間目標**：具体的な数値設定がコードに存在しない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/shared/config/defaults.json` - デフォルト設定ファイル
- E-02: `ghost/core/core/shared/config/env/config.production.json` - 本番環境設定
- E-03: `ghost/core/core/shared/config/env/config.development.json` - 開発環境設定
- E-04: `ghost/core/core/server/services/stripe/stripe-api.js` - Stripe API設定
- E-05: `ghost/core/core/server/adapters/lib/redis/AdapterCacheRedis.js` - Redisキャッシュアダプター
- E-06: `ghost/core/core/frontend/services/rss/cache.js` - RSSキャッシュ
- E-07: `ghost/core/core/server/services/auth/session/session-service.js` - セッションサービス
- E-08: `ghost/core/core/server/lib/request-external.js` - 外部リクエストライブラリ
- E-09: `ghost/core/core/server/services/email-service/batch-sending-service.js` - バッチメール送信
- E-10: `ghost/core/core/server/ghost-server.js` - Ghostサーバー
- E-11: `ghost/core/core/server/lib/validate-password.js` - パスワード検証
- E-12: `ghost/core/core/frontend/web/middleware/cors.js` - CORS設定
- E-13: `ghost/core/core/shared/prometheus-client.js` - Prometheusクライアント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 外部リクエストのデフォルトタイムアウトは10秒 | E-08（gotOpts.timeout: 10000） | ○ |
| C-02 | テスト環境での外部リクエストタイムアウトは5秒 | E-08（disableRetries関数でtimeout: 5000） | ○ |
| C-03 | Geolocation API呼び出しタイムアウトは500ms | E-07（gotOpts.timeout: 500） | ○ |
| C-04 | getHelper処理エラー閾値は5秒 | E-01（optimization.getHelper.timeout.threshold: 5000） | ○ |
| C-05 | getHelper処理警告閾値は200ms | E-01（optimization.getHelper.notify.threshold: 200） | ○ |
| C-06 | サーバーシャットダウンタイムアウトは60秒 | E-01（server.shutdownTimeout: 60000） | ○ |
| C-07 | 長時間シャットダウン警告は15秒以上 | E-10（shutdownDuration > 15000） | ○ |
| C-08 | Stripe API本番モードは95req/s | E-04（EXPECTED_API_EFFICIENCY * LIVE_MODE_RATE_LIMIT = 0.95 * 100） | ○ |
| C-09 | Stripe APIテストモードは23.75req/s | E-04（EXPECTED_API_EFFICIENCY * TEST_MODE_RATE_LIMIT = 0.95 * 25） | ○ |
| C-10 | Stripe Search APIは15req/s | E-04（EXPECTED_SEARCH_API_EFFICIENCY * SEARCH_MODE_RATE_LIMIT = 0.15 * 100） | ○ |
| C-11 | メール送信バッチサイズは1000件 | E-01（bulkEmail.batchSize: 1000） | ○ |
| C-12 | メール送信並列数は2 | E-09（MAX_SENDING_CONCURRENCY = 2） | ○ |
| C-13 | APIリクエスト制限は100件 | E-01（optimization.maxLimit: 100） | ○ |
| C-14 | 301リダイレクトキャッシュは1年 | E-01（caching.301.maxAge: 31536000） | ○ |
| C-15 | 管理画面キャッシュは1年 | E-01（caching.admin.maxAge: 31536000） | ○ |
| C-16 | テーマキャッシュは1年 | E-01（caching.theme.maxAge: 31536000） | ○ |
| C-17 | faviconキャッシュは24時間 | E-01（caching.favicon.maxAge: 86400） | ○ |
| C-18 | sitemapキャッシュは1時間 | E-01（caching.sitemap.maxAge: 3600） | ○ |
| C-19 | フロントエンドキャッシュは無効 | E-01（caching.frontend.maxAge: 0） | ○ |
| C-20 | 稼働率は設定なし | **根拠なし** | △ |
| C-21 | RTO/RPOは設定なし | **根拠なし** | △ |
| C-22 | 計画停止時間は設定なし | **根拠なし** | △ |
| C-23 | メール送信前リトライは最大10回、10分 | E-09（BEFORE_RETRY_CONFIG: {maxRetries: 10, maxTime: 10*60*1000}） | ○ |
| C-24 | メール送信後リトライは最大20回、30分 | E-09（AFTER_RETRY_CONFIG: {maxRetries: 20, maxTime: 30*60*1000}） | ○ |
| C-25 | Mailgun APIリトライは最大6回、10秒間隔 | E-09（MAILGUN_API_RETRY_CONFIG: {sleep: 10*1000, maxRetries: 6}） | ○ |
| C-26 | Redis接続リトライは10秒間隔 | E-05（retryStrategy: () => (config.storeConfig.retryConnectSeconds || 10) * 1000） | ○ |
| C-27 | スタッフデバイス検証はデフォルト有効 | E-01（security.staffDeviceVerification: true） | ○ |
| C-28 | セッションはOriginヘッダーで検証 | E-07（cookieCsrfProtection関数） | ○ |
| C-29 | パスワード最小文字数は10文字 | E-11（validator.isLength(password, 10)） | ○ |
| C-30 | パスワードに禁止文字列あり | E-11（disallowedPasswords配列） | ○ |
| C-31 | パスワード重複制限は50% | E-11（allowedOccurancy = stringToTest.length / 2） | ○ |
| C-32 | ユーザーログイン無料試行は4回 | E-01（spam.user_login.freeRetries: 4） | ○ |
| C-33 | メンバーログイン無料試行は8回 | E-01（spam.member_login.freeRetries: 8） | ○ |
| C-34 | CORSはデフォルトで拒否 | E-12（corsOptions.origin: false） | ○ |
| C-35 | localhost/127.0.0.1は許可 | E-12（localhost/127.0.0.1チェック） | ○ |
| C-36 | プライベートIPはブロック | E-08（isPrivateIp関数） | ○ |
| C-37 | 開発環境ではSSRF保護無効 | E-08（config.get('env') === 'development'チェック） | ○ |
| C-38 | SSOアダプターはカスタマイズ可能 | E-01（adapters.sso.active: "DefaultSSOAdapter"） | ○ |
| C-39 | キャッシュアダプターはMemoryCacheがデフォルト | E-01（adapters.cache.active: "MemoryCache"） | ○ |
| C-40 | ロギングレベルはinfoがデフォルト | E-01（logging.level: "info"） | ○ |
| C-41 | ロギングはstdoutがデフォルト | E-01（logging.transports: ["stdout"]） | ○ |
| C-42 | 本番環境ではファイル出力推奨 | E-02（logging.transports: ["file"]） | ○ |
| C-43 | Prometheusは設定で有効化可能 | E-13（config.get('prometheus:enabled')チェック） | ○ |
| C-44 | 60以上の言語対応 | E-01（i18n設定参照、CLAUDE.md記載） | ○ |
| C-45 | Stripe APIバージョンは2020-08-27 | E-04（STRIPE_API_VERSION = '2020-08-27'） | ○ |

## 4) 不足情報（Unknown / Missing）
- **稼働率・RTO・RPO**：インフラストラクチャレベルの設定であり、アプリケーションコードには明示的な定義がない
  - 候補：インフラ設計書 / 運用手順書 / SLA文書
- **計画停止時間**：メンテナンスウィンドウの設定はコードレベルでは存在しない
  - 候補：運用手順書 / デプロイメントガイド
- **API応答時間目標**：具体的なSLO/SLA値はコードに定義されていない
  - 候補：SLAドキュメント / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：キャッシュ設定値 - コードから直接取得した数値
- **0（低リスク）**：スパム設定値 - defaults.jsonから直接取得
- **0（低リスク）**：リトライ設定 - ソースコードの定数から取得
- **1（中リスク）**：セキュリティ設定 - デフォルト値は確認済みだが、本番環境での実際の設定は要確認
- **2（高リスク）**：稼働率・RTO・RPO - インフラレベルの情報が不足

## 6) レビュアーチェックリスト（最小）
- [ ] defaults.jsonの値が本番環境で適切にオーバーライドされているか確認
- [ ] セキュリティ設定（spam設定）が運用要件を満たしているか確認
- [ ] ロギング設定が監査要件を満たしているか確認
- [ ] インフラレベルの可用性要件（稼働率、RTO、RPO）を別途定義する必要があるか検討
- [ ] Stripe APIレートリミット設定が実際の利用パターンに適合しているか確認
- [ ] パスワードポリシーがセキュリティ基準（NIST等）に準拠しているか確認
- [ ] キャッシュ設定がコンテンツ更新頻度と整合しているか確認
