# 非機能要件定義書

## 概要

本ドキュメントは、Ghostパブリッシングプラットフォームの非機能要件を定義するものです。Ghostはオープンソースのパブリッシングプラットフォームであり、Node.js/Expressバックエンド、Ember.js/React管理クライアントで構成されるモノレポ構造を持ちます。本ドキュメントでは、ソースコードの解析結果に基づいて、性能、可用性、セキュリティ、拡張性、保守性、運用・監視の各観点から要件を定義します。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| 外部リクエスト（デフォルト） | 10秒以内 | `request-external.js`でのデフォルトタイムアウト設定 |
| 外部リクエスト（テスト環境） | 5秒以内 | テスト環境ではリトライ無効化と短いタイムアウトを適用 |
| Geolocation API呼び出し | 500ms以内 | `session-service.js`でのIPジオロケーション取得タイムアウト |
| getHelper処理 | 5秒以内（エラー閾値） | テーマヘルパー処理の最大許容時間、超過時はエラーログ出力 |
| getHelper処理 | 200ms以内（警告閾値） | テーマヘルパー処理の推奨時間、超過時は警告ログ出力 |
| サーバーシャットダウン | 60秒以内 | グレースフルシャットダウンのタイムアウト |
| 長時間シャットダウン警告 | 15秒以上 | シャットダウンが15秒以上かかる場合はメトリクス記録 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| Stripe API（本番モード） | 95リクエスト/秒 | 100req/sのStripe制限に対し95%効率で設定 |
| Stripe API（テストモード） | 23.75リクエスト/秒 | 25req/sのStripe制限に対し95%効率で設定 |
| Stripe Search API | 15リクエスト/秒 | 20req/sのStripe制限に対し15%効率で設定 |
| メール送信バッチサイズ | 1000件/バッチ | 一括メール送信の最大バッチサイズ |
| メール送信並列数 | 2 | 同時バッチ送信の最大数 |
| APIリクエスト制限 | 100件/リクエスト | maxLimit設定によるAPI応答の上限 |

### キャッシュ設定

| キャッシュ対象 | maxAge（秒） | 備考 |
| --- | --- | --- |
| 301リダイレクト | 31,536,000 | 1年間キャッシュ |
| 管理画面静的ファイル | 31,536,000 | 1年間キャッシュ |
| テーマ静的ファイル | 31,536,000 | 1年間キャッシュ |
| 公開アセット | 31,536,000 | 1年間キャッシュ |
| カスタムリダイレクト | 31,536,000 | 1年間キャッシュ |
| favicon | 86,400 | 24時間キャッシュ |
| sitemap.xsl | 86,400 | 24時間キャッシュ |
| .well-known | 86,400 | 24時間キャッシュ |
| CORS preflight | 86,400 | 24時間キャッシュ |
| IndexNow key | 86,400 | 24時間キャッシュ |
| sitemap | 3,600 | 1時間キャッシュ |
| robots.txt | 3,600 | 1時間キャッシュ |
| フロントエンド | 0 | キャッシュ無効（動的コンテンツ） |
| Content API | 0 | キャッシュ無効（動的コンテンツ） |
| Comments Count API | 0 | キャッシュ無効（動的コンテンツ） |

### Redisキャッシュ設定

| 設定項目 | 説明 |
| --- | --- |
| TTL | 設定可能（config.ttl） |
| refreshAheadFactor | 0-1の値、TTLの割合に基づいて事前リフレッシュ |
| getTimeoutMilliseconds | キャッシュ取得のタイムアウト設定可能 |
| retryConnectSeconds | 接続リトライ間隔（デフォルト10秒） |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | 設定なし（運用依存） | インフラストラクチャレベルで設定 |
| 計画停止時間 | 設定なし | アプリケーションレベルでは明示的な設定なし |
| 障害復旧時間（RTO） | 設定なし | インフラストラクチャレベルで設定 |
| 目標復旧時点（RPO） | 設定なし | データベースバックアップポリシーに依存 |

### リトライ設定

| 処理種別 | 最大リトライ数 | 最大待機時間 | リトライ間隔 | 備考 |
| --- | --- | --- | --- | --- |
| メール送信前DB操作 | 10回 | 10分 | 2秒（指数バックオフ） | BEFORE_RETRY_CONFIG |
| メール送信後DB操作 | 20回 | 30分 | 2秒（指数バックオフ） | AFTER_RETRY_CONFIG |
| Mailgun API呼び出し | 6回 | - | 10秒 | MAILGUN_API_RETRY_CONFIG |
| Redis接続 | 無限 | - | 10秒 | retryStrategy設定 |
| 外部リクエスト（テスト環境） | 0回 | - | - | リトライ無効化 |

### グレースフルシャットダウン

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| シャットダウンタイムアウト | 60,000ms | stoppableライブラリによる制御 |
| 新規接続 | 拒否 | シャットダウン開始後は新規接続を拒否 |
| アイドル接続 | 即座にクローズ | |
| アクティブ接続 | リクエスト完了まで待機 | タイムアウト超過時は強制終了 |

## セキュリティ要件

### 認証・認可

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| スタッフデバイス検証 | 有効（デフォルト） | security.staffDeviceVerification設定 |
| 2要素認証（MFA） | Email OTP | 設定により必須化可能 |
| セッション管理 | Origin検証 | CSRF保護としてOriginヘッダーを検証 |
| セッション情報 | user_id, origin, user_agent, ip, verified | セッションに保存される情報 |

### パスワードポリシー

| 項目 | 要件 |
| --- | --- |
| 最小文字数 | 10文字以上 |
| 禁止パスワード | 'password', 'ghost', 'passw0rd'を含むものは禁止 |
| 禁止パターン | 連続数字（1234567890）、キーボード配列（qwertyuiop）等 |
| 文字重複制限 | 50%以上の同一文字は禁止 |
| 個人情報との一致禁止 | メールアドレス、ブログタイトル、ブログURLとの一致禁止 |

### ブルートフォース対策（スパム設定）

| 保護対象 | 無料試行回数 | 最小待機時間 | 最大待機時間 | ライフタイム |
| --- | --- | --- | --- | --- |
| ユーザーログイン | 4回 | 10分 | 7日 | - |
| パスワードリセット | 4回 | 1時間 | 1時間 | 1時間 |
| ユーザー検証 | 4回 | 1時間 | 1時間 | 1時間 |
| 検証コード送信 | 4回 | 1時間 | 1時間 | 1時間 |
| グローバルリセット | 4回 | 1時間 | 1時間 | 1時間 |
| グローバルブロック | 99回 | 1時間 | 1時間 | 1時間 |
| プライベートブロック | 99回 | 1時間 | 1時間 | 1時間 |
| Content APIキー | 99回 | 1時間 | 24時間 | 1時間 |
| メンバーログイン | 8回 | 10分 | 12時間 | 12時間 |
| Webmentions | 100回 | 10ms | 100ms | 1秒 |
| メールプレビュー | 10回 | 6分 | 6分 | 1時間 |
| OTC検証（列挙防止） | 8回 | 10分 | 12時間 | 12時間 |
| OTC検証 | 4回 | 1時間 | 1時間 | 1時間 |

### CORS設定

| 設定項目 | 値 | 備考 |
| --- | --- | --- |
| デフォルトオリジン | 拒否 | 許可リスト方式 |
| localhost/127.0.0.1 | 許可 | 全ポートで許可 |
| サイトURL | 許可 | 設定されたサイトURLのホストを許可 |
| Admin URL | 許可 | 設定されている場合のみ |
| 認証情報 | 許可 | credentials: true |

### SSRFプロテクション

| 項目 | 設定 |
| --- | --- |
| プライベートIP | ブロック | 10.x.x.x, 192.168.x.x, 172.16-31.x.x, 127.x.x.x, 169.254.x.x, fc/fd, fe80, ::1, :: |
| 開発環境 | 全許可 | 開発モードではSSRF保護を無効化 |
| 自サイトURL | 許可 | 自身のGhostインスタンスへのリクエストは許可 |

### フレーム保護

| 項目 | 設定 |
| --- | --- |
| Admin Frame Protection | 有効（デフォルト） | adminFrameProtection設定 |

## 拡張性要件

### アダプターシステム

| アダプタータイプ | デフォルト | カスタマイズ可能 |
| --- | --- | --- |
| SSO | DefaultSSOAdapter | はい |
| キャッシュ | MemoryCache | はい（Redis等に変更可能） |
| ストレージ（画像） | LocalImagesStorage | はい |
| ストレージ（メディア） | LocalMediaStorage | はい |
| ストレージ（ファイル） | LocalFilesStorage | はい |
| スケジューリング | scheduling-default | はい |

### データベース対応

| データベース | 用途 | 備考 |
| --- | --- | --- |
| SQLite3 | 開発/小規模 | デフォルト開発環境 |
| MySQL | 本番推奨 | mysql2クライアント使用、UTF8MB4対応 |

### API制限設定

| 設定項目 | デフォルト値 | 備考 |
| --- | --- | --- |
| maxLimit | 100 | API応答の最大レコード数 |
| allowLimitAll | false | 全件取得の許可/禁止 |

### 画像最適化

| 項目 | 設定 |
| --- | --- |
| リサイズ | 有効 |
| srcsets生成 | 有効 |

## 保守性要件

### モジュール構造

| コンポーネント | 技術スタック | 説明 |
| --- | --- | --- |
| ghost/core | Node.js/Express | メインバックエンド |
| ghost/admin | Ember.js | 管理画面（レガシー） |
| apps/* | React/Vite | 新管理画面UI |
| 設計パターン | Monorepo (Yarn v1 + Nx) | ビルド依存関係管理 |

### ロギング設定

| 設定項目 | デフォルト値 | 説明 |
| --- | --- | --- |
| level | info | ログレベル |
| useLocalTime | false | UTC使用 |
| rotation.enabled | false | ログローテーション（本番環境では有効化推奨） |
| rotation.period | 1d | ローテーション周期 |
| rotation.count | 10 | 保持するログファイル数 |
| transports | ["stdout"] | 出力先（本番では"file"推奨） |

### 本番環境ロギング設定

| 設定項目 | 値 | 説明 |
| --- | --- | --- |
| level | info | ログレベル |
| rotation.enabled | true | ログローテーション有効 |
| transports | ["file"] | ファイル出力 |

### 国際化（i18n）

| 項目 | 設定 |
| --- | --- |
| 対応言語数 | 60以上 |
| 翻訳管理 | ghost/i18n パッケージに集約 |
| 名前空間 | ghost, portal, signup-form, comments, search |

## 運用・監視要件

### メトリクス収集

| 項目 | ツール | 備考 |
| --- | --- | --- |
| Prometheus | @tryghost/prometheus-metrics | 設定により有効化可能 |
| Pushgateway | 設定可能 | prometheus.pushgateway設定 |
| 内部メトリクス | @tryghost/metrics | cache-reset, long-shutdownなど |

### Sentryエラー監視

| 項目 | 設定 |
| --- | --- |
| エラーキャプチャ | 依存性注入で設定可能 |
| メール送信エラー | 自動キャプチャ |
| メールカウント不整合 | 1%以上の差異でキャプチャ |

### バックグラウンドジョブ

| ジョブ | デフォルト | 説明 |
| --- | --- | --- |
| emailAnalytics | 有効 | メール分析ジョブ |
| clickTrackingLastSeenAtUpdater | 有効 | クリックトラッキング更新 |

### メール分析設定

| 設定項目 | デフォルト値 | 説明 |
| --- | --- | --- |
| enabled | true | メール分析有効 |
| batchProcessing | false | バッチ処理モード |
| openedJobLagWarningMinutes | 30 | 開封ジョブ遅延警告閾値 |
| openThroughput.enabled | false | 開封スループットメトリクス |
| openThroughput.threshold | 500 | 開封スループット閾値 |

### ヘルスチェック

| 項目 | 方式 |
| --- | --- |
| サーバー起動通知 | notify.notifyServerStarted() |
| シグナルハンドリング | SIGINT, SIGTERM対応 |
| 接続監視（テストモード） | 5秒間隔で接続数をログ出力 |

### 外部サービス連携

| サービス | 用途 | 設定 |
| --- | --- | --- |
| Stripe | 決済処理 | APIバージョン 2020-08-27 |
| Mailgun | メール配信 | リトライ設定あり |
| GeoJS | IPジオロケーション | 500msタイムアウト |
| CDN (jsDelivr) | フロントエンドアセット配信 | Portal, Sodo Search, Comments UI等 |
| Tinybird | 分析（オプション） | Docker開発環境で利用可能 |

## 備考

### 環境別設定

| 環境 | 特記事項 |
| --- | --- |
| development | SSRFプロテクション無効、リトライ無効、デバッグログ有効 |
| testing | 短いタイムアウト、リトライ無効、高スループット制限（Stripe API 10,000 req/s） |
| production | 全セキュリティ機能有効、ログローテーション推奨 |

### 制限事項

- 本ドキュメントはソースコード解析に基づいており、実際の運用環境での設定値は異なる場合があります
- インフラストラクチャレベルの要件（稼働率、RTO、RPO等）は別途定義が必要です
- パフォーマンス目標値の一部はコードから直接取得できないため、推奨値として記載しています

### 参照ファイル

- `/ghost/core/core/shared/config/defaults.json` - デフォルト設定値
- `/ghost/core/core/shared/config/env/config.production.json` - 本番環境設定
- `/ghost/core/core/server/services/stripe/stripe-api.js` - Stripe API設定
- `/ghost/core/core/server/adapters/lib/redis/AdapterCacheRedis.js` - Redisキャッシュ設定
- `/ghost/core/core/server/services/auth/session/session-service.js` - セッション管理
- `/ghost/core/core/server/lib/request-external.js` - 外部リクエスト設定
- `/ghost/core/core/server/services/email-service/batch-sending-service.js` - バッチメール送信設定
- `/ghost/core/core/server/ghost-server.js` - サーバー設定
- `/ghost/core/core/server/lib/validate-password.js` - パスワードポリシー
