# API設計書

## 概要

本ドキュメントは、GitLab REST API v4の設計仕様を記載します。GitLabはGrape APIフレームワークを使用してREST APIを提供しており、プロジェクト管理、ユーザー管理、CI/CD、マージリクエストなど、GitLabの全機能にプログラマティックにアクセスできます。

## 共通仕様

### ベースURL

```
/api/v4
```

注: API v3は廃止されており、v3へのリクエストは410エラーを返します。

### 認証方式

GitLab APIは複数の認証方式をサポートしています:

| 認証方式 | 説明 |
| --- | --- |
| Personal Access Token | ユーザーが生成するアクセストークン。`PRIVATE-TOKEN`ヘッダーまたは`private_token`パラメータで指定 |
| OAuth 2.0 Bearer Token | OAuth 2.0認証フロー経由で取得。`Authorization: Bearer <token>`ヘッダーで指定 |
| Project Access Token | プロジェクトスコープのアクセストークン |
| Group Access Token | グループスコープのアクセストークン |
| Job Token | CI/CDジョブ内で使用可能な一時トークン。`JOB-TOKEN`ヘッダーで指定 |
| Deploy Token | デプロイ専用のトークン |

### 共通ヘッダー

| ヘッダー名 | 必須 | 説明 |
| --- | --- | --- |
| PRIVATE-TOKEN | 条件付 | Personal Access Token（Bearer Token未使用時） |
| Authorization | 条件付 | Bearer Token形式のOAuth 2.0トークン |
| Content-Type | - | `application/json`（POSTリクエスト時） |
| Accept | - | `application/json` |
| X-Frame-Options | - | 自動付与: `SAMEORIGIN` |
| X-Content-Type-Options | - | 自動付与: `nosniff` |

### 共通エラーレスポンス

| ステータスコード | 説明 |
| --- | --- |
| 400 | Bad Request - リクエストパラメータ不正 |
| 401 | Unauthorized - 認証エラー（トークン無効、期限切れ、取り消し済み） |
| 403 | Forbidden - 権限エラー（スコープ不足、アクセス拒否） |
| 404 | Not Found - リソース未検出 |
| 405 | Method Not Allowed - 許可されていないHTTPメソッド |
| 408 | Request Timeout - リクエストタイムアウト |
| 409 | Conflict - リソースロックまたは重複 |
| 410 | Gone - API v3は廃止 |
| 422 | Unprocessable Entity - バリデーションエラー |
| 429 | Too Many Requests - レート制限超過 |
| 500 | Internal Server Error - サーバーエラー |
| 503 | Service Unavailable - Gitリソース枯渇 |

### ページネーション

APIはオフセットベースのページネーションをサポートしています:

| パラメータ | 型 | デフォルト | 説明 |
| --- | --- | --- | --- |
| page | Integer | 1 | ページ番号 |
| per_page | Integer | 20 | 1ページあたりの件数（最大100） |

レスポンスヘッダー:
- `X-Page`: 現在のページ
- `X-Per-Page`: 1ページあたりの件数
- `X-Total`: 総件数
- `X-Total-Pages`: 総ページ数
- `X-Next-Page`: 次のページ番号
- `X-Prev-Page`: 前のページ番号

## API一覧

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| Projects | /api/v4/projects | GET | プロジェクト一覧取得 |
| Projects | /api/v4/projects | POST | プロジェクト作成 |
| Projects | /api/v4/projects/:id | GET | プロジェクト詳細取得 |
| Projects | /api/v4/projects/:id | PUT | プロジェクト更新 |
| Projects | /api/v4/projects/:id | DELETE | プロジェクト削除 |
| Users | /api/v4/users | GET | ユーザー一覧取得 |
| Users | /api/v4/users | POST | ユーザー作成（管理者のみ） |
| Users | /api/v4/users/:id | GET | ユーザー詳細取得 |
| Users | /api/v4/users/:id | PUT | ユーザー更新（管理者のみ） |
| Users | /api/v4/user | GET | 現在のユーザー情報取得 |
| Groups | /api/v4/groups | GET | グループ一覧取得 |
| Groups | /api/v4/groups | POST | グループ作成 |
| Groups | /api/v4/groups/:id | GET | グループ詳細取得 |
| Groups | /api/v4/groups/:id | PUT | グループ更新 |
| Groups | /api/v4/groups/:id | DELETE | グループ削除 |
| Merge Requests | /api/v4/merge_requests | GET | マージリクエスト一覧取得 |
| Merge Requests | /api/v4/projects/:id/merge_requests | GET | プロジェクトのMR一覧 |
| Merge Requests | /api/v4/projects/:id/merge_requests | POST | マージリクエスト作成 |
| Merge Requests | /api/v4/projects/:id/merge_requests/:iid | GET | MR詳細取得 |
| Merge Requests | /api/v4/projects/:id/merge_requests/:iid | PUT | MR更新 |
| Merge Requests | /api/v4/projects/:id/merge_requests/:iid/merge | PUT | MRマージ |
| Issues | /api/v4/issues | GET | Issue一覧取得 |
| Issues | /api/v4/projects/:id/issues | GET | プロジェクトのIssue一覧 |
| Issues | /api/v4/projects/:id/issues | POST | Issue作成 |
| Issues | /api/v4/projects/:id/issues/:iid | GET | Issue詳細取得 |
| Issues | /api/v4/projects/:id/issues/:iid | PUT | Issue更新 |
| Pipelines | /api/v4/projects/:id/pipelines | GET | パイプライン一覧取得 |
| Pipelines | /api/v4/projects/:id/pipeline | POST | パイプライン作成 |
| Pipelines | /api/v4/projects/:id/pipelines/:id | GET | パイプライン詳細取得 |
| Pipelines | /api/v4/projects/:id/pipelines/:id/jobs | GET | パイプラインジョブ一覧 |

## 各APIエンドポイント定義

### Projects

#### 1. プロジェクト一覧取得

認証ユーザーがアクセス可能なプロジェクトの一覧を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/v4/projects` |
| 認証 | 不要（パブリックプロジェクトのみ）/ 必要（全プロジェクト） |
| 権限 | read_project |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| archived | Boolean | - | - | アーカイブ状態でフィルタ |
| visibility | String | - | - | 可視性（private/internal/public） |
| search | String | - | - | 検索キーワード |
| owned | Boolean | - | false | 所有プロジェクトのみ |
| starred | Boolean | - | false | スター付きプロジェクトのみ |
| membership | Boolean | - | false | メンバーのプロジェクトのみ |
| order_by | String | - | created_at | ソートフィールド |
| sort | String | - | desc | ソート順（asc/desc） |
| simple | Boolean | - | false | 簡略表示 |
| statistics | Boolean | - | false | 統計情報を含める |
| per_page | Integer | - | 20 | 1ページあたりの件数 |
| page | Integer | - | 1 | ページ番号 |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
[
  {
    "id": 1,
    "name": "Project Name",
    "path": "project-name",
    "path_with_namespace": "namespace/project-name",
    "description": "Project description",
    "visibility": "private",
    "created_at": "2024-01-01T00:00:00.000Z",
    "default_branch": "main",
    "web_url": "https://gitlab.example.com/namespace/project-name",
    "star_count": 0,
    "forks_count": 0,
    "namespace": {
      "id": 1,
      "name": "Namespace",
      "path": "namespace"
    }
  }
]
```

#### 2. プロジェクト作成

新しいプロジェクトを作成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /api/v4/projects` |
| 認証 | 必要 |
| 権限 | create_project |

**リクエストボディ**

```json
{
  "name": "New Project",
  "path": "new-project",
  "namespace_id": 1,
  "description": "Project description",
  "visibility": "private",
  "default_branch": "main"
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| name | String | いずれか必須 | - | プロジェクト名 |
| path | String | いずれか必須 | - | リポジトリパス |
| namespace_id | Integer | - | - | 名前空間ID |
| description | String | - | - | 説明 |
| visibility | String | - | private/internal/public | 可視性 |
| default_branch | String | - | - | デフォルトブランチ |
| import_url | String | - | 有効なURL | インポート元URL |

**レスポンス（成功時）**

ステータスコード: `201 Created`

```json
{
  "id": 1,
  "name": "New Project",
  "path": "new-project",
  "path_with_namespace": "namespace/new-project",
  "visibility": "private",
  "created_at": "2024-01-01T00:00:00.000Z",
  "web_url": "https://gitlab.example.com/namespace/new-project"
}
```

**レスポンス（エラー時）**

ステータスコード: `400 Bad Request`

```json
{
  "message": {
    "name": ["can't be blank"],
    "path": ["can't be blank"]
  }
}
```

#### 3. プロジェクト詳細取得

単一のプロジェクトの詳細情報を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/v4/projects/:id` |
| 認証 | 条件付き（パブリックプロジェクトは不要） |
| 権限 | read_project |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| id | String/Integer | ○ | プロジェクトIDまたはURLエンコードされたパス |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| statistics | Boolean | - | false | 統計情報を含める |
| license | Boolean | - | false | ライセンス情報を含める |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "id": 1,
  "name": "Project Name",
  "path": "project-name",
  "path_with_namespace": "namespace/project-name",
  "description": "Project description",
  "visibility": "private",
  "created_at": "2024-01-01T00:00:00.000Z",
  "default_branch": "main",
  "web_url": "https://gitlab.example.com/namespace/project-name",
  "permissions": {
    "project_access": {
      "access_level": 40,
      "notification_level": 3
    }
  }
}
```

### Users

#### 1. ユーザー一覧取得

ユーザーの一覧を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/v4/users` |
| 認証 | 条件付き（username指定時は不要） |
| 権限 | read_user |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| username | String | - | - | ユーザー名で検索 |
| search | String | - | - | 検索キーワード |
| active | Boolean | - | false | アクティブユーザーのみ |
| blocked | Boolean | - | false | ブロック済みユーザーのみ |
| order_by | String | - | id | ソートフィールド |
| sort | String | - | desc | ソート順 |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
[
  {
    "id": 1,
    "username": "john_doe",
    "name": "John Doe",
    "state": "active",
    "avatar_url": "https://gitlab.example.com/uploads/user/avatar/1/avatar.png",
    "web_url": "https://gitlab.example.com/john_doe"
  }
]
```

#### 2. 現在のユーザー情報取得

認証済みユーザー自身の情報を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/v4/user` |
| 認証 | 必要 |
| 権限 | read_user |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "id": 1,
  "username": "john_doe",
  "email": "john@example.com",
  "name": "John Doe",
  "state": "active",
  "avatar_url": "https://gitlab.example.com/uploads/user/avatar/1/avatar.png",
  "web_url": "https://gitlab.example.com/john_doe",
  "created_at": "2024-01-01T00:00:00.000Z",
  "is_admin": false,
  "can_create_group": true,
  "can_create_project": true
}
```

### Groups

#### 1. グループ一覧取得

グループの一覧を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/v4/groups` |
| 認証 | 条件付き |
| 権限 | - |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| skip_groups | Array[Integer] | - | - | 除外するグループID |
| all_available | Boolean | - | - | 全アクセス可能グループ |
| search | String | - | - | 検索キーワード |
| owned | Boolean | - | false | 所有グループのみ |
| order_by | String | - | name | ソートフィールド |
| sort | String | - | asc | ソート順 |
| statistics | Boolean | - | false | 統計情報を含める |
| top_level_only | Boolean | - | - | トップレベルグループのみ |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
[
  {
    "id": 1,
    "name": "Group Name",
    "path": "group-name",
    "description": "Group description",
    "visibility": "private",
    "web_url": "https://gitlab.example.com/groups/group-name",
    "full_name": "Group Name",
    "full_path": "group-name"
  }
]
```

#### 2. グループ作成

新しいグループを作成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /api/v4/groups` |
| 認証 | 必要 |
| 権限 | create_group |

**リクエストボディ**

```json
{
  "name": "New Group",
  "path": "new-group",
  "description": "Group description",
  "visibility": "private",
  "parent_id": 1
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| name | String | ○ | - | グループ名 |
| path | String | ○ | - | グループパス |
| description | String | - | - | 説明 |
| visibility | String | - | private/internal/public | 可視性 |
| parent_id | Integer | - | - | 親グループID（サブグループ作成時） |

**レスポンス（成功時）**

ステータスコード: `201 Created`

```json
{
  "id": 1,
  "name": "New Group",
  "path": "new-group",
  "description": "Group description",
  "visibility": "private",
  "web_url": "https://gitlab.example.com/groups/new-group"
}
```

### Merge Requests

#### 1. マージリクエスト一覧取得

マージリクエストの一覧を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/v4/merge_requests` |
| 認証 | 条件付き（scope=all以外は必要） |
| 権限 | - |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| state | String | - | all | 状態（opened/closed/merged/all） |
| scope | String | - | created_by_me | スコープ |
| author_id | Integer | - | - | 作成者ID |
| assignee_id | Integer | - | - | 担当者ID |
| reviewer_ids | Array[Integer] | - | - | レビュアーID |
| labels | String | - | - | ラベル（カンマ区切り） |
| milestone | String | - | - | マイルストーン |
| order_by | String | - | created_at | ソートフィールド |
| sort | String | - | desc | ソート順 |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
[
  {
    "id": 1,
    "iid": 1,
    "title": "Merge Request Title",
    "description": "Description",
    "state": "opened",
    "source_branch": "feature-branch",
    "target_branch": "main",
    "author": {
      "id": 1,
      "username": "john_doe",
      "name": "John Doe"
    },
    "web_url": "https://gitlab.example.com/namespace/project/-/merge_requests/1"
  }
]
```

#### 2. マージリクエスト作成

新しいマージリクエストを作成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /api/v4/projects/:id/merge_requests` |
| 認証 | 必要 |
| 権限 | create_merge_request_from |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| id | String/Integer | ○ | プロジェクトIDまたはURLエンコードされたパス |

**リクエストボディ**

```json
{
  "title": "New Merge Request",
  "source_branch": "feature-branch",
  "target_branch": "main",
  "description": "Description",
  "assignee_id": 1,
  "reviewer_ids": [2, 3],
  "labels": "bug,urgent",
  "remove_source_branch": true
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| title | String | ○ | - | タイトル |
| source_branch | String | ○ | - | ソースブランチ |
| target_branch | String | ○ | - | ターゲットブランチ |
| description | String | - | max:1048576 | 説明 |
| assignee_id | Integer | - | - | 担当者ID |
| assignee_ids | Array[Integer] | - | - | 担当者ID配列 |
| reviewer_ids | Array[Integer] | - | - | レビュアーID配列 |
| labels | String | - | - | ラベル（カンマ区切り） |
| milestone_id | Integer | - | - | マイルストーンID |
| remove_source_branch | Boolean | - | - | マージ後にソースブランチを削除 |
| squash | Boolean | - | - | スカッシュマージ |

**レスポンス（成功時）**

ステータスコード: `201 Created`

```json
{
  "id": 1,
  "iid": 1,
  "title": "New Merge Request",
  "description": "Description",
  "state": "opened",
  "source_branch": "feature-branch",
  "target_branch": "main",
  "web_url": "https://gitlab.example.com/namespace/project/-/merge_requests/1"
}
```

#### 3. マージリクエストのマージ

マージリクエストをマージします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `PUT /api/v4/projects/:id/merge_requests/:merge_request_iid/merge` |
| 認証 | 必要 |
| 権限 | merge権限 |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| id | String/Integer | ○ | プロジェクトIDまたはURLエンコードされたパス |
| merge_request_iid | Integer | ○ | マージリクエストの内部ID |

**リクエストボディ**

```json
{
  "merge_commit_message": "Merge commit message",
  "squash_commit_message": "Squash commit message",
  "should_remove_source_branch": true,
  "auto_merge": true,
  "sha": "abc123"
}
```

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| merge_commit_message | String | - | マージコミットメッセージ |
| squash_commit_message | String | - | スカッシュコミットメッセージ |
| should_remove_source_branch | Boolean | - | ソースブランチを削除 |
| auto_merge | Boolean | - | 自動マージを設定 |
| sha | String | - | ソースブランチのHEAD SHA |
| squash | Boolean | - | スカッシュマージ |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "id": 1,
  "iid": 1,
  "title": "Merged Request",
  "state": "merged",
  "merge_commit_sha": "abc123def456"
}
```

### Issues

#### 1. Issue一覧取得

Issueの一覧を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/v4/issues` |
| 認証 | 条件付き |
| 権限 | - |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| state | String | - | all | 状態（opened/closed/all） |
| labels | String | - | - | ラベル（カンマ区切り） |
| milestone | String | - | - | マイルストーン |
| scope | String | - | created_by_me | スコープ |
| author_id | Integer | - | - | 作成者ID |
| assignee_id | Integer | - | - | 担当者ID |
| order_by | String | - | created_at | ソートフィールド |
| sort | String | - | desc | ソート順 |
| search | String | - | - | 検索キーワード |
| confidential | Boolean | - | - | 機密Issueフィルタ |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
[
  {
    "id": 1,
    "iid": 1,
    "title": "Issue Title",
    "description": "Description",
    "state": "opened",
    "labels": ["bug", "urgent"],
    "author": {
      "id": 1,
      "username": "john_doe",
      "name": "John Doe"
    },
    "assignees": [],
    "web_url": "https://gitlab.example.com/namespace/project/-/issues/1"
  }
]
```

#### 2. Issue作成

新しいIssueを作成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /api/v4/projects/:id/issues` |
| 認証 | 必要 |
| 権限 | create_issue |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| id | String/Integer | ○ | プロジェクトIDまたはURLエンコードされたパス |

**リクエストボディ**

```json
{
  "title": "New Issue",
  "description": "Issue description",
  "assignee_ids": [1, 2],
  "labels": "bug,urgent",
  "milestone_id": 1,
  "due_date": "2024-12-31",
  "confidential": false
}
```

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| title | String | ○ | タイトル |
| description | String | - | 説明 |
| assignee_ids | Array[Integer] | - | 担当者ID配列 |
| labels | String | - | ラベル（カンマ区切り） |
| milestone_id | Integer | - | マイルストーンID |
| due_date | String | - | 期日（YYYY-MM-DD） |
| confidential | Boolean | - | 機密フラグ |

**レスポンス（成功時）**

ステータスコード: `201 Created`

```json
{
  "id": 1,
  "iid": 1,
  "title": "New Issue",
  "description": "Issue description",
  "state": "opened",
  "web_url": "https://gitlab.example.com/namespace/project/-/issues/1"
}
```

### Pipelines

#### 1. パイプライン一覧取得

パイプラインの一覧を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/v4/projects/:id/pipelines` |
| 認証 | 必要 |
| 権限 | read_pipeline |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| id | String/Integer | ○ | プロジェクトIDまたはURLエンコードされたパス |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| scope | String | - | - | スコープ（running/pending/finished/branches/tags） |
| status | String | - | - | ステータス |
| ref | String | - | - | ブランチ/タグ名 |
| sha | String | - | - | コミットSHA |
| username | String | - | - | トリガーユーザー名 |
| source | String | - | - | ソース（push/web/trigger等） |
| order_by | String | - | id | ソートフィールド |
| sort | String | - | desc | ソート順 |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
[
  {
    "id": 1,
    "iid": 1,
    "status": "success",
    "ref": "main",
    "sha": "abc123def456",
    "source": "push",
    "created_at": "2024-01-01T00:00:00.000Z",
    "updated_at": "2024-01-01T00:05:00.000Z",
    "web_url": "https://gitlab.example.com/namespace/project/-/pipelines/1"
  }
]
```

#### 2. パイプライン作成

新しいパイプラインを作成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /api/v4/projects/:id/pipeline` |
| 認証 | 必要 |
| 権限 | create_pipeline |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| id | String/Integer | ○ | プロジェクトIDまたはURLエンコードされたパス |

**リクエストボディ**

```json
{
  "ref": "main",
  "variables": [
    {
      "key": "VAR1",
      "value": "value1"
    }
  ]
}
```

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| ref | String | ○ | ブランチまたはタグ名 |
| variables | Array | - | パイプライン変数 |

**レスポンス（成功時）**

ステータスコード: `201 Created`

```json
{
  "id": 1,
  "iid": 1,
  "status": "pending",
  "ref": "main",
  "sha": "abc123def456",
  "web_url": "https://gitlab.example.com/namespace/project/-/pipelines/1"
}
```

#### 3. パイプラインジョブ一覧取得

パイプラインのジョブ一覧を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/v4/projects/:id/pipelines/:pipeline_id/jobs` |
| 認証 | 必要 |
| 権限 | read_pipeline, read_build |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| id | String/Integer | ○ | プロジェクトIDまたはURLエンコードされたパス |
| pipeline_id | Integer | ○ | パイプラインID |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| scope | String | - | - | ジョブスコープ |
| include_retried | Boolean | - | false | リトライジョブを含める |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
[
  {
    "id": 1,
    "name": "build",
    "status": "success",
    "stage": "build",
    "duration": 120.5,
    "started_at": "2024-01-01T00:00:00.000Z",
    "finished_at": "2024-01-01T00:02:00.000Z",
    "web_url": "https://gitlab.example.com/namespace/project/-/jobs/1"
  }
]
```

## 備考

### スコープ

APIトークンには以下のスコープを設定できます:

| スコープ | 説明 |
| --- | --- |
| api | 完全なAPI読み書きアクセス |
| read_api | API読み取りアクセス |
| read_user | ユーザー情報読み取り |
| read_repository | リポジトリ読み取り |
| write_repository | リポジトリ書き込み |
| read_registry | コンテナレジストリ読み取り |
| write_registry | コンテナレジストリ書き込み |
| sudo | 管理者として他ユーザーになりすまし |
| admin_mode | 管理者モード |

### レート制限

APIにはレート制限が適用されます。制限を超えた場合は429エラーが返されます。レスポンスヘッダーで残りのリクエスト数を確認できます:

- `RateLimit-Limit`: 制限値
- `RateLimit-Remaining`: 残りリクエスト数
- `RateLimit-Reset`: 制限リセット時刻

### 内部API

`/api/v4/internal/`以下のエンドポイントは、GitLabの内部コンポーネント（Gitaly、Workhorse、Pages等）間の通信に使用され、外部からのアクセスは想定されていません。
