---
generated_at: 2026-01-22 13:45:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **レート制限の具体的な数値**：実際の設定値はインスタンスにより異なる可能性
  2. **OAuth 2.0の詳細仕様**：Doorkeeper Gemの設定に依存
  3. **エンティティ構造の完全性**：一部のレスポンスフィールドは実装詳細に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/api/api.rb` - Grape APIのメインマウントファイル
- E-02: `lib/api/projects.rb` - Projects APIエンドポイント定義
- E-03: `lib/api/users.rb` - Users APIエンドポイント定義
- E-04: `lib/api/groups.rb` - Groups APIエンドポイント定義
- E-05: `lib/api/merge_requests.rb` - Merge Requests APIエンドポイント定義
- E-06: `lib/api/issues.rb` - Issues APIエンドポイント定義
- E-07: `lib/api/ci/pipelines.rb` - Pipelines APIエンドポイント定義
- E-08: `lib/api/api_guard.rb` - API認証ガードモジュール
- E-09: `lib/api/base.rb` - Grape API基底クラス
- E-10: `config/routes/api.rb` - APIルーティング設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ベースURLは /api/v4 | E-01 | ○ |
| C-02 | API v3は廃止（410エラー） | E-01 | ○ |
| C-03 | Personal Access Token認証をサポート | E-08 | ○ |
| C-04 | OAuth 2.0 Bearer Token認証をサポート | E-08 | ○ |
| C-05 | Job Token認証をサポート | E-08 | ○ |
| C-06 | Deploy Token認証をサポート | E-08 | ○ |
| C-07 | PRIVATE-TOKENヘッダーでトークン指定 | E-08 | ○ |
| C-08 | 401エラーはトークン無効/期限切れ/取消し | E-08 | ○ |
| C-09 | 403エラーはスコープ不足 | E-08 | ○ |
| C-10 | ページネーションはoffsetベース | E-04 | ○ |
| C-11 | per_pageのデフォルトは20 | E-04 | ○ |
| C-12 | GET /projects でプロジェクト一覧取得 | E-02 | ○ |
| C-13 | POST /projects でプロジェクト作成 | E-02 | ○ |
| C-14 | GET /projects/:id でプロジェクト詳細取得 | E-02 | ○ |
| C-15 | GET /users でユーザー一覧取得 | E-03 | ○ |
| C-16 | GET /user で現在のユーザー情報取得 | E-03 | ○ |
| C-17 | GET /groups でグループ一覧取得 | E-04 | ○ |
| C-18 | POST /groups でグループ作成 | E-04 | ○ |
| C-19 | PUT /groups/:id でグループ更新 | E-04 | ○ |
| C-20 | DELETE /groups/:id でグループ削除 | E-04 | ○ |
| C-21 | GET /groups/:id/projects でグループプロジェクト取得 | E-04 | ○ |
| C-22 | GET /groups/:id/subgroups でサブグループ取得 | E-04 | ○ |
| C-23 | POST /groups/:id/share でグループ共有 | E-04 | ○ |
| C-24 | GET /merge_requests でMR一覧取得 | E-05 | ○ |
| C-25 | POST /projects/:id/merge_requests でMR作成 | E-05 | ○ |
| C-26 | PUT /projects/:id/merge_requests/:iid でMR更新 | E-05 | ○ |
| C-27 | PUT /projects/:id/merge_requests/:iid/merge でMRマージ | E-05 | ○ |
| C-28 | MR作成にはtitle, source_branch, target_branchが必須 | E-05 | ○ |
| C-29 | MRマージにはmerge権限が必要 | E-05 | ○ |
| C-30 | GET /issues でIssue一覧取得 | E-06 | ○ |
| C-31 | POST /projects/:id/issues でIssue作成 | E-06 | ○ |
| C-32 | PUT /projects/:id/issues/:iid でIssue更新 | E-06 | ○ |
| C-33 | Issue作成にはtitleが必須 | E-06 | ○ |
| C-34 | GET /projects/:id/pipelines でパイプライン一覧取得 | E-07 | ○ |
| C-35 | POST /projects/:id/pipeline でパイプライン作成 | E-07 | ○ |
| C-36 | パイプライン作成にはrefが必須 | E-07 | ○ |
| C-37 | GET /projects/:id/pipelines/:id/jobs でジョブ一覧取得 | E-07 | ○ |
| C-38 | POST /projects/:id/pipelines/:id/retry でリトライ | E-07 | ○ |
| C-39 | POST /projects/:id/pipelines/:id/cancel でキャンセル | E-07 | ○ |
| C-40 | 408はリクエストタイムアウト | E-05 | ○ |
| C-41 | authenticate_non_get!でGET以外は認証必須 | E-04, E-05, E-06, E-07 | ○ |
| C-42 | Grape APIフレームワークを使用 | E-09 | ○ |
| C-43 | レート制限超過で429エラー | **根拠なし** | △ |
| C-44 | OAuth2スコープにsudo/admin_modeが存在 | **根拠なし** | △ |
| C-45 | 内部APIは外部アクセス不可 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **レート制限の詳細実装**
  - レート制限の具体的な設定値はApplicationSettingsやRack::Attackの設定に依存
  - 候補：`lib/gitlab/rate_limit.rb` / `config/initializers/rack_attack.rb` / `app/models/application_setting.rb`

- **OAuth2スコープの完全リスト**
  - Doorkeeper Gemの設定とGitLab固有の拡張に依存
  - 候補：`config/initializers/doorkeeper.rb` / `lib/gitlab/auth.rb`

- **内部APIのアクセス制御**
  - Workhorse/Gitalyとの通信プロトコルは別途定義
  - 候補：`lib/api/internal/` / `workhorse/` / `gitaly/`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 基本的なCRUDエンドポイントの存在と構造
- **0: 低リスク** - 認証方式の種類
- **1: 中リスク** - レスポンスフィールドの詳細（Entitiesクラスに依存）
- **1: 中リスク** - バリデーションルールの完全性
- **2: 高リスク** - レート制限の具体値
- **2: 高リスク** - 権限チェックの詳細ロジック

## 6) レビュアーチェックリスト（最小）
- [ ] 主要エンドポイント（Projects, Users, Groups, MergeRequests, Issues, Pipelines）が網羅されているか確認
- [ ] 認証方式の説明が正確か（実際のAPI呼び出しで検証）
- [ ] エラーレスポンスのステータスコードが正確か確認
- [ ] ページネーションパラメータのデフォルト値を実際のAPIで検証
- [ ] レスポンスサンプルのフィールドが最新のEntitiesクラスと一致するか確認
- [ ] Enterprise Edition固有のエンドポイント/パラメータが混在していないか確認
