# GitLab

## 概要

GitLabは、Git リポジトリ管理、コードレビュー、CI/CD、プロジェクト管理を統合したオープンソースのDevSecOpsプラットフォームです。Ruby on Rails を基盤とし、100,000以上の組織で利用されている、オンプレミスGitリポジトリ管理ソリューションとして最も人気のあるプラットフォームです。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| ソースコード管理 | 細かなアクセス制御によるGitリポジトリ管理 |
| コードレビュー | マージリクエストによるコラボレーションの強化 |
| CI/CD | アプリケーションのビルド、テスト、デプロイのための完全なCI/CDパイプライン |
| イシュートラッカー | プロジェクトごとのイシュー管理とイシューボード |
| Wiki | プロジェクトドキュメント管理 |
| パッケージレジストリ | npm、Maven、NuGet等のパッケージ管理 |
| コンテナレジストリ | Dockerイメージの保存・配布 |
| セキュリティスキャン | SAST、DAST、依存関係スキャン |
| プロジェクト管理 | マイルストーン、ラベル、タイムトラッキング |

## 技術スタック

### コア

- フレームワーク: Ruby on Rails 7.2.3
- 言語: Ruby 3.3.10
- データベース: PostgreSQL 16.5+
- キャッシュ/キュー: Redis 6.0+
- バージョン管理: Git 2.33+
- Webサーバー: Puma
- バックグラウンドジョブ: Sidekiq

### フロントエンド

- JavaScript/TypeScript (Node.js 22.12.0)
- Vue.js 2.7 (Vue 3 互換モード対応中)
- Webpack / Vite
- Apollo Client (GraphQL)
- TailwindCSS

### 主要ライブラリ

- grape: REST API フレームワーク
- graphql-ruby: GraphQL API
- devise: 認証
- doorkeeper: OAuth 2.0 プロバイダー
- sidekiq: バックグラウンドジョブ処理
- carrierwave: ファイルアップロード
- rugged: Git操作 (libgit2)
- faraday: HTTP クライアント
- rspec: テストフレームワーク

## ディレクトリ構成

```
gitlabhq-master/
├── app/                    # Rails アプリケーションコード
│   ├── assets/            # スタイルシート、画像
│   ├── controllers/       # コントローラー
│   ├── finders/           # データベースクエリロジック
│   ├── graphql/           # GraphQL スキーマ・リゾルバ
│   ├── helpers/           # ビューヘルパー
│   ├── mailers/           # メール送信
│   ├── models/            # ActiveRecord モデル
│   ├── policies/          # 認可ポリシー (DeclarativePolicy)
│   ├── presenters/        # プレゼンター
│   ├── serializers/       # JSON シリアライザ
│   ├── services/          # ビジネスロジック
│   ├── validators/        # カスタムバリデーター
│   ├── views/             # ビューテンプレート (HAML)
│   └── workers/           # Sidekiq ワーカー
├── bin/                    # 実行可能スクリプト
├── config/                 # Rails 設定ファイル
│   ├── initializers/      # 初期化スクリプト
│   ├── locales/           # 国際化ファイル
│   └── routes/            # ルーティング定義
├── db/                     # データベース関連
│   ├── migrate/           # マイグレーション
│   ├── post_migrate/      # ポストデプロイマイグレーション
│   └── structure.sql      # スキーマ定義
├── doc/                    # ドキュメント
├── gems/                   # GitLab 内部 gem
├── lib/                    # ライブラリコード
│   ├── api/               # Grape API エンドポイント
│   ├── gitlab/            # GitLab コア機能
│   └── tasks/             # Rake タスク
├── locale/                 # 翻訳ファイル
├── public/                 # 静的ファイル
├── qa/                     # E2E テストスイート
├── rubocop/                # カスタム RuboCop cop
├── scripts/                # 開発・CI スクリプト
├── spec/                   # RSpec テスト
├── storybook/              # Storybook (UI コンポーネント)
├── tooling/                # 開発ツール
├── vendor/                 # ベンダーライブラリ
│   └── gems/              # ベンダー gem
└── workhorse/              # GitLab Workhorse (Go)
```

## セットアップ

### 必要条件

- Ruby 3.3.10
- Node.js 22.12.0
- Yarn 1.22+
- PostgreSQL 16.5+
- Redis 6.0+
- Git 2.33+

### 推奨インストール方法

GitLab Development Kit (GDK) を使用することを推奨します。

```bash
# GDK をクローン
git clone https://gitlab.com/gitlab-org/gitlab-development-kit.git
cd gitlab-development-kit

# GDK をインストール
make
```

詳細は [GitLab Development Kit](https://gitlab.com/gitlab-org/gitlab-development-kit) を参照してください。

### 手動セットアップ（非推奨）

GDK を使用しない場合は、以下の手順でセットアップします。

```bash
# 依存関係のインストール
bundle install
yarn install

# Puma 設定のコピー
cp config/puma.example.development.rb config/puma.rb

# データベースのセットアップ
bundle exec rails db:setup

# サーバーの起動
bundle exec rails server
```

## 開発

### コードスタイル

- Ruby: RuboCop (`.rubocop.yml`)
- JavaScript/Vue: ESLint (`eslint.config.mjs`)
- CSS/SCSS: Stylelint (`.stylelintrc`)
- HAML: haml-lint (`.haml-lint.yml`)

### Linter の実行

```bash
# Ruby
bundle exec rubocop

# JavaScript/Vue
yarn lint:eslint

# CSS/SCSS
yarn lint:stylelint

# HAML
bundle exec haml-lint
```

### テストの実行

```bash
# Ruby テスト (RSpec)
bundle exec rspec

# 特定のファイルをテスト
bundle exec rspec spec/models/user_spec.rb

# JavaScript テスト (Jest)
yarn jest

# 特定のファイルをテスト
yarn jest spec/frontend/user_spec.js
```

### フロントエンドビルド

```bash
# 開発サーバー
yarn dev-server

# 本番ビルド
yarn webpack-prod

# Vite ビルド
yarn vite-prod

# Storybook
yarn storybook:start
```

### Git Hooks

Lefthook を使用した Git フックが設定されています。

```bash
# Lefthook のインストール
lefthook install
```
