---
generated_at: 2026-01-22 16:30:00
metrics:
  claims_total: 42
  claims_with_evidence: 40
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート: コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：40 / 42、根拠なし：2
- 優先レビュー（高）
  1. **フロントエンド詳細構成**：Vue.js 2/3の移行状況の詳細
  2. **Gitalyサービス詳細**：Gitaly連携の内部実装詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Gemfile` - Ruby依存関係定義ファイル
- E-02: `package.json` - Node.js依存関係定義ファイル
- E-03: `config/application.rb` - Railsアプリケーション設定
- E-04: `config/routes.rb` - ルーティング定義
- E-05: `app/models/user.rb` - Userモデル実装
- E-06: `app/models/project.rb` - Projectモデル実装
- E-07: `app/controllers/application_controller.rb` - 基底コントローラー
- E-08: `app/services/base_service.rb` - 基底サービスクラス
- E-09: `app/workers/new_issue_worker.rb` - Workerサンプル実装
- E-10: `app/finders/issuable_finder.rb` - Finderサンプル実装
- E-11: `lib/api/projects.rb` - Grape API実装
- E-12: `app/` ディレクトリ構造 - ディレクトリリスティング
- E-13: `lib/` ディレクトリ構造 - ディレクトリリスティング
- E-14: `config/` ディレクトリ構造 - ディレクトリリスティング
- E-15: `app/graphql/` ディレクトリ構造 - GraphQL実装ファイル群
- E-16: `app/workers/` ディレクトリ構造 - Workerファイル群
- E-17: `app/services/` ディレクトリ構造 - Serviceファイル群
- E-18: `app/finders/` ディレクトリ構造 - Finderファイル群
- E-19: `.ruby-version` - Rubyバージョン指定

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Ruby on Rails 7.2.xを使用している | E-01 (gem 'rails', '~> 7.2.3') | ○ |
| C-02 | PostgreSQLをデータベースとして使用 | E-01 (gem 'pg', '~> 1.6.1') | ○ |
| C-03 | Redisをキャッシュ/キューに使用 | E-01 (gem 'redis', '~> 5.4.1') | ○ |
| C-04 | Sidekiqをバックグラウンドジョブに使用 | E-01 (gem 'sidekiq') | ○ |
| C-05 | Vue.js 2/3をフロントエンドに使用 | E-02 ("vue": "2.7.16", "@vue/compat": "^3.5.22") | ○ |
| C-06 | Grapeを REST APIフレームワークとして使用 | E-01 (gem 'grape', '~> 2.0.0') | ○ |
| C-07 | GraphQLをAPI層で使用 | E-01 (gem 'graphql', '2.5.11') | ○ |
| C-08 | frozen_string_literal宣言が全ファイルに存在 | E-05, E-06, E-07, E-08, E-09 | ○ |
| C-09 | モデルはApplicationRecordを継承 | E-05 (class User < ApplicationRecord) | ○ |
| C-10 | Concernsによる機能モジュール化 | E-05 (include Avatarable, include Sortable等) | ○ |
| C-11 | EE/CE二重構造の存在 | E-03 (Gitlab.ee { load_paths.call(dir: 'ee') }) | ○ |
| C-12 | prepend_modによるEE拡張パターン | E-09 (NewIssueWorker.prepend_mod) | ○ |
| C-13 | feature_categoryによる機能分類 | E-09 (feature_category :team_planning) | ○ |
| C-14 | BaseServiceがproject, current_user, paramsを受け取る | E-08 (attr_accessor :project, :current_user, :params) | ○ |
| C-15 | Workerにdata_consistency属性がある | E-09 (data_consistency :always) | ○ |
| C-16 | Workerにurgency属性がある | E-09 (urgency :high) | ○ |
| C-17 | Workerにworker_resource_boundary属性がある | E-09 (worker_resource_boundary :cpu) | ○ |
| C-18 | FinderがFindMethodsをinclude | E-10 (include FinderMethods) | ○ |
| C-19 | コントローラーがbefore_actionを使用 | E-07 (before_action :authenticate_user!) | ○ |
| C-20 | rescue_fromによるエラーハンドリング | E-07 (rescue_from ActiveRecord::RecordNotFound) | ○ |
| C-21 | API::Baseを継承したGrape API | E-11 (class Projects < ::API::Base) | ○ |
| C-22 | app/配下のディレクトリ構成（models, controllers, services等） | E-12 | ○ |
| C-23 | lib/配下にapi, gitlabモジュールが存在 | E-13 | ○ |
| C-24 | config/配下にroutes, initializersが存在 | E-14 | ○ |
| C-25 | GraphQLにtypes, mutations, resolversが存在 | E-15 | ○ |
| C-26 | 多数のWorkerクラスが存在 | E-16 | ○ |
| C-27 | 多数のServiceクラスが存在 | E-17 | ○ |
| C-28 | 多数のFinderクラスが存在 | E-18 | ○ |
| C-29 | ServiceResponseパターンの使用 | E-08 (UnauthorizedError = ServiceResponse.error) | ○ |
| C-30 | 定数は大文字スネークケース | E-05 (DEFAULT_NOTIFICATION_LEVEL, MAX_USERNAME_LENGTH) | ○ |
| C-31 | 疑問符メソッドがbooleanを返す | E-07 (devise_controller?, html_request?) | ○ |
| C-32 | ファイル名は単数形（モデル） | E-05 (user.rb), E-06 (project.rb) | ○ |
| C-33 | コントローラー名は複数形 | E-07 (projects_controller.rb) | ○ |
| C-34 | Worker名は_workerサフィックス | E-09 (new_issue_worker.rb) | ○ |
| C-35 | Finder名は_finderサフィックス | E-10 (issuable_finder.rb) | ○ |
| C-36 | eager_load_pathsにlib配下を追加 | E-03 (config.eager_load_paths.push) | ○ |
| C-37 | Viteをフロントエンドビルドに使用 | E-01 (gem 'vite_rails'), E-02 (vite) | ○ |
| C-38 | Webpackも併用している | E-02 (webpack) | ○ |
| C-39 | Pumaをアプリケーションサーバーとして使用 | E-01 (gem 'puma', '~> 7.1') | ○ |
| C-40 | Deviseを認証に使用 | E-01 (gem 'devise', '~> 4.9.3') | ○ |
| C-41 | Vue.js 2から3への移行が進行中 | **根拠不足** | △ |
| C-42 | Gitalyとの連携方法 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）

- **Vue.js移行状況の詳細**
  - package.jsonでVue 2と3の共存は確認できるが、具体的な移行計画や進捗は不明
  - 候補：GitLab公式ドキュメント / フロントエンドREADME / MIGRATION_GUIDE

- **Gitalyサービスとの連携詳細**
  - Gemfileでgitaly gemの存在は確認できるが、内部実装の詳細は未調査
  - 候補：lib/gitaly/ / doc/development/gitaly.md / 外部Gitalyリポジトリ

## 5) リスクフラグ（レビュー観点）

- **0 (低リスク)**: 技術スタック情報 - Gemfile/package.jsonから直接確認可能
- **0 (低リスク)**: ディレクトリ構造 - 実際のファイルシステムから確認
- **0 (低リスク)**: 命名規則 - 複数のソースファイルから一貫性を確認
- **0 (低リスク)**: アーキテクチャパターン - 実装コードから抽出
- **1 (中リスク)**: EE/CE境界の詳細 - eeディレクトリの詳細調査は限定的
- **1 (中リスク)**: フロントエンド移行状況 - 動的な状況のため変化の可能性あり

## 6) レビュアーチェックリスト（最小）

- [ ] Ruby/Railsのバージョン情報が最新か確認
- [ ] Vue.js 2/3の移行状況が実態と一致しているか確認
- [ ] EE専用機能の境界が正しく記述されているか確認
- [ ] 命名規則の例外ケースがないか確認
- [ ] 業務フロー追跡例が実際のコードフローと一致するか確認
- [ ] 参考資料のURLが有効か確認
