---
generated_at: 2026-01-22 14:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **ClickHouseのバージョン情報**：設定ファイルにバージョン明記なし
  2. **Zoekt検索エンジンの詳細設定**：EE専用機能の可能性、CE版での確認不足
  3. **キャッシュTTL詳細値**：具体的なTTL値は設定依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Gemfile` - Rails 7.2.3、各種gem依存関係
- E-02: `config/application.rb` - Rails設定、レイヤー構成
- E-03: `config/routes.rb` - ルーティング定義
- E-04: `config/database.yml.postgresql` - データベース構成（main, ci, geo, embedding）
- E-05: `config/redis.yml.example` - Redis構成（cache, sessions, queues等）
- E-06: `config/gitlab.yml.example` - GitLab全体設定
- E-07: `config/sidekiq_queues.yml` - Sidekiqキュー定義
- E-08: `config/bounded_contexts.yml` - DDD境界コンテキスト定義
- E-09: `app/models/application_record.rb` - モデル基底クラス
- E-10: `app/services/base_service.rb` - サービス基底クラス
- E-11: `app/policies/base_policy.rb` - 認可ポリシー基底クラス
- E-12: `app/channels/application_cable/connection.rb` - ActionCable接続
- E-13: `lib/api/api.rb` - Grape API定義
- E-14: `app/` ディレクトリ構成 - レイヤー構造
- E-15: `lib/gitlab/` ディレクトリ構成 - コアライブラリ
- E-16: `config/initializers/` - 初期化設定
- E-17: `workhorse/` ディレクトリ - Workhorseコンポーネント
- E-18: `app/graphql/` ディレクトリ - GraphQL API構成
- E-19: `db/` ディレクトリ構成 - データベーススキーマ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Ruby on Rails 7.2 ベースのアプリケーション | E-01 | ○ |
| C-02 | PostgreSQLをプライマリデータストアとして使用 | E-01, E-04 | ○ |
| C-03 | Decomposed Database構成（main, ci, geo, embedding） | E-04 | ○ |
| C-04 | Redis Clusterを使用（cache, sessions, queues等） | E-05 | ○ |
| C-05 | Sidekiqによるバックグラウンドジョブ処理 | E-01, E-07 | ○ |
| C-06 | Pumaをアプリケーションサーバーとして使用 | E-01 | ○ |
| C-07 | DeclarativePolicyによる認可システム | E-01, E-11 | ○ |
| C-08 | Deviseによる認証 | E-01 | ○ |
| C-09 | Doorkeeperによる OAuth 2.0 | E-01 | ○ |
| C-10 | Grapeによる REST API | E-01, E-13 | ○ |
| C-11 | GraphQL APIの実装 | E-01, E-18 | ○ |
| C-12 | ActionCableによるWebSocket通信 | E-02, E-12 | ○ |
| C-13 | Elasticsearchによる全文検索 | E-01 | ○ |
| C-14 | CarrierWaveによるファイルアップロード | E-01 | ○ |
| C-15 | fog-* gemsによるオブジェクトストレージ連携 | E-01 | ○ |
| C-16 | Sentryによるエラートラッキング | E-01 | ○ |
| C-17 | OpenTelemetryによる分散トレーシング | E-01 | ○ |
| C-18 | Prometheusメトリクス収集 | E-01 | ○ |
| C-19 | レイヤードアーキテクチャの採用 | E-02, E-14 | ○ |
| C-20 | Service層のパターン（app/services/） | E-10, E-14 | ○ |
| C-21 | Finder層のパターン（app/finders/） | E-14 | ○ |
| C-22 | Presenter層のパターン（app/presenters/） | E-14 | ○ |
| C-23 | Policy層のパターン（app/policies/） | E-11, E-14 | ○ |
| C-24 | Workers層のパターン（app/workers/） | E-07, E-14 | ○ |
| C-25 | DDD Bounded Contextsの定義 | E-08 | ○ |
| C-26 | EE/JH拡張のモジュールシステム | E-02 | ○ |
| C-27 | Gitaly gRPC連携 | E-01 | ○ |
| C-28 | kubeclient によるKubernetes連携 | E-01 | ○ |
| C-29 | LDAP/SAML認証連携 | E-01 | ○ |
| C-30 | 2FA対応（TOTP/WebAuthn） | E-01 | ○ |
| C-31 | Jira/Slack連携 | E-01 | ○ |
| C-32 | Rack::Attackによるレート制限 | E-01 | ○ |
| C-33 | ミドルウェアスタック構成 | E-02 | ○ |
| C-34 | Feature Flag管理 | E-02, E-16 | ○ |
| C-35 | マイグレーション分離（migrate/post_migrate） | E-19 | ○ |
| C-36 | Loose Foreign Keys | E-06 | ○ |
| C-37 | RuboCopによる静的解析 | E-01 | ○ |
| C-38 | ESLintによるJS静的解析 | ディレクトリ構成 | ○ |
| C-39 | Viteによるフロントエンドビルド | E-01 | ○ |
| C-40 | View Component使用 | E-01 | ○ |
| C-41 | I18n国際化対応 | E-01, E-02 | ○ |
| C-42 | ClickHouseの分析データストア使用 | E-01 | ○ |
| C-43 | ClickHouseの具体的バージョン | **根拠なし** | △ |
| C-44 | Zoekt検索エンジンの詳細構成 | **根拠なし** | △ |
| C-45 | キャッシュTTLの具体的な値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-43 ClickHouseバージョン**: `config/click_house.yml.example` には接続設定のみ記載。バージョン情報は運用ドキュメントまたはインフラ設定を確認する必要がある
  - 候補：インフラ設計書 / デプロイメントガイド / 運用マニュアル
- **C-44 Zoekt検索エンジン**: `GITLAB_ZOEKT_VERSION` ファイルは存在するが、詳細な構成・設定ファイルの確認が不足
  - 候補：EE版ドキュメント / 管理画面設定 / 外部ドキュメント
- **C-45 キャッシュTTL**: Redis設定ファイルではTTLは動的に設定される。アプリケーションコード内での設定値を確認する必要がある
  - 候補：`lib/gitlab/cache/` / 各種キャッシュ関連クラス / ApplicationSettingモデル

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 基本的なアーキテクチャ構成（Rails、PostgreSQL、Redis）
- **0 (低リスク)**: レイヤー構成とモジュール分割
- **0 (低リスク)**: 認証・認可システム
- **1 (中リスク)**: EE専用機能の記載（Geo、一部のセキュリティ機能）- CE版では利用不可の可能性
- **1 (中リスク)**: ミドルウェアバージョン - 実際の運用環境と異なる可能性
- **0 (低リスク)**: 外部連携（Jira、Slack等）- Gemfile記載済み

## 6) レビュアーチェックリスト（最小）
- [ ] Rails 7.2.3 のバージョンは実環境と一致しているか確認
- [ ] PostgreSQL の Decomposed Database 構成（main, ci, geo, embedding）は正確か確認
- [ ] Redis Cluster の各用途（cache, sessions, queues等）は正確か確認
- [ ] EE専用機能（Geo、Zoekt等）がCE版ドキュメントとして適切か確認
- [ ] Sidekiqキューの優先度設定が `config/sidekiq_queues.yml` と一致しているか確認
- [ ] Bounded Contexts の一覧が `config/bounded_contexts.yml` と一致しているか確認
- [ ] 認証方式（Devise、OAuth、SAML、LDAP、2FA）の記載が正確か確認
- [ ] Workhorse/Gitaly/Shell等の補助サービスの役割説明が正確か確認
- [ ] ClickHouse、Zoektの具体的なバージョン・設定を別途確認し補完が必要か判断
