# アーキテクチャ構成図

## システム全体構成図

```mermaid
flowchart TB
    subgraph Clients["クライアント"]
        Browser["Web ブラウザ"]
        GitClient["Git クライアント"]
        APIClient["API クライアント"]
        Runner["GitLab Runner"]
    end

    subgraph LoadBalancer["ロードバランサー"]
        LB["Nginx / HAProxy"]
    end

    subgraph GitLabCore["GitLab Core"]
        subgraph FrontProxy["フロントプロキシ"]
            Workhorse["GitLab Workhorse<br/>(Go)"]
        end

        subgraph WebServer["Web サーバー"]
            Puma["Puma"]
            Rails["Rails Application"]
        end

        subgraph BackgroundJobs["バックグラウンドジョブ"]
            Sidekiq["Sidekiq"]
            SidekiqCron["Sidekiq-Cron"]
        end

        subgraph GitServices["Git サービス"]
            Gitaly["Gitaly<br/>(gRPC)"]
            Shell["GitLab Shell<br/>(Go)"]
        end

        subgraph AdditionalServices["追加サービス"]
            Pages["GitLab Pages"]
            Registry["Container Registry"]
        end
    end

    subgraph DataStores["データストア"]
        subgraph PostgreSQLCluster["PostgreSQL"]
            MainDB["Main DB"]
            CIDB["CI DB"]
            GeoDB["Geo DB"]
        end

        subgraph RedisCluster["Redis Cluster"]
            Cache["Cache"]
            Sessions["Sessions"]
            Queues["Queues"]
            SharedState["Shared State"]
        end

        ClickHouse["ClickHouse"]
        Elasticsearch["Elasticsearch"]
        ObjectStorage["Object Storage<br/>(S3/GCS/Azure)"]
    end

    subgraph ExternalServices["外部サービス"]
        LDAP["LDAP"]
        SAML["SAML IdP"]
        OAuth["OAuth Provider"]
        Slack["Slack"]
        Jira["Jira"]
        K8s["Kubernetes"]
    end

    Browser --> LB
    GitClient --> LB
    APIClient --> LB
    Runner --> LB

    LB --> Workhorse
    Workhorse --> Puma
    Workhorse --> Gitaly
    Workhorse --> ObjectStorage

    Puma --> Rails
    Rails --> MainDB
    Rails --> CIDB
    Rails --> Cache
    Rails --> Sessions
    Rails --> Queues
    Rails --> Elasticsearch
    Rails --> ClickHouse

    Sidekiq --> Queues
    Sidekiq --> MainDB
    Sidekiq --> CIDB

    Shell --> Gitaly
    Gitaly --> ObjectStorage

    Rails --> LDAP
    Rails --> SAML
    Rails --> OAuth
    Rails --> Slack
    Rails --> Jira
    Rails --> K8s

    Pages --> ObjectStorage
    Registry --> ObjectStorage
```

## レイヤー構成図

```mermaid
flowchart TB
    subgraph Presentation["Presentation Layer"]
        Controllers["Controllers<br/>app/controllers/"]
        GraphQL["GraphQL API<br/>app/graphql/"]
        GrapeAPI["REST API (Grape)<br/>lib/api/"]
        Views["Views<br/>app/views/"]
        Channels["ActionCable<br/>app/channels/"]
    end

    subgraph Application["Application Layer"]
        Services["Services<br/>app/services/"]
        Workers["Workers (Sidekiq)<br/>app/workers/"]
        Finders["Finders<br/>app/finders/"]
        Presenters["Presenters<br/>app/presenters/"]
        Serializers["Serializers<br/>app/serializers/"]
    end

    subgraph Domain["Domain Layer"]
        Models["Models<br/>app/models/"]
        Policies["Policies<br/>app/policies/"]
        Validators["Validators<br/>app/validators/"]
        Events["Domain Events<br/>app/events/"]
    end

    subgraph Infrastructure["Infrastructure Layer"]
        Uploaders["Uploaders<br/>app/uploaders/"]
        Mailers["Mailers<br/>app/mailers/"]
        LibGitlab["Gitlab Core<br/>lib/gitlab/"]
        Integrations["Integrations<br/>lib/integrations/"]
    end

    subgraph External["External Systems"]
        PostgreSQL["PostgreSQL"]
        Redis["Redis"]
        Gitaly["Gitaly"]
        ObjectStorage["Object Storage"]
    end

    Controllers --> Services
    Controllers --> Finders
    Controllers --> Presenters
    GraphQL --> Services
    GraphQL --> Finders
    GrapeAPI --> Services
    GrapeAPI --> Finders
    Views --> Presenters
    Channels --> Services

    Services --> Models
    Services --> Workers
    Services --> Mailers
    Workers --> Models
    Workers --> Services
    Finders --> Models
    Presenters --> Models
    Serializers --> Models

    Models --> Policies
    Models --> Validators
    Models --> Events

    Uploaders --> ObjectStorage
    Mailers --> External
    LibGitlab --> PostgreSQL
    LibGitlab --> Redis
    LibGitlab --> Gitaly
    Models --> PostgreSQL
```

## ドメイン境界図

```mermaid
flowchart LR
    subgraph Core["Core Domains"]
        Projects["Projects"]
        Groups["Groups"]
        Users["Users"]
        Organizations["Organizations"]
    end

    subgraph DevOps["DevOps Domains"]
        CI["CI/CD<br/>(Ci)"]
        Environments["Environments"]
        Clusters["Clusters"]
        Packages["Packages"]
        Registry["Container<br/>Registry"]
    end

    subgraph Collaboration["Collaboration Domains"]
        Issues["Issues"]
        MergeRequests["Merge<br/>Requests"]
        Boards["Boards"]
        Milestones["Milestones"]
    end

    subgraph Security["Security Domains"]
        Authn["Authentication<br/>(Authn)"]
        Authz["Authorization<br/>(Authz)"]
        AntiAbuse["Anti-Abuse"]
        AuditEvents["Audit Events"]
        Compliance["Compliance<br/>Management"]
    end

    subgraph Intelligence["Intelligence Domains"]
        Ai["AI / Duo"]
        Analytics["Analytics"]
        Search["Search"]
    end

    subgraph Platform["Platform Domains"]
        Geo["Geo"]
        Cells["Cells"]
        Backup["Backup"]
    end

    Projects --> CI
    Projects --> Issues
    Projects --> MergeRequests
    Projects --> Environments
    Projects --> Packages

    Groups --> Projects
    Groups --> Boards
    Groups --> Milestones

    Users --> Authn
    Users --> Authz

    Organizations --> Groups
    Organizations --> Projects

    CI --> Clusters
    CI --> Registry
    CI --> Environments

    MergeRequests --> CI
    MergeRequests --> Issues

    Ai --> MergeRequests
    Ai --> Issues
    Ai --> CI

    Analytics --> CI
    Analytics --> MergeRequests

    AuditEvents --> Core
    AuditEvents --> DevOps
    AuditEvents --> Collaboration

    Geo --> Core
    Geo --> DevOps
```

## リクエスト処理フロー図

```mermaid
sequenceDiagram
    participant C as Client
    participant N as Nginx/LB
    participant W as Workhorse
    participant P as Puma
    participant R as Rails
    participant S as Service
    participant M as Model
    participant DB as PostgreSQL
    participant RD as Redis
    participant SK as Sidekiq

    C->>N: HTTPS Request
    N->>W: Forward Request

    alt Static File
        W->>C: Serve File
    else Dynamic Request
        W->>P: Forward to Puma
        P->>R: Process Request

        R->>R: Middleware Stack
        R->>R: Route Matching
        R->>R: Controller Action

        R->>S: Call Service
        S->>M: Business Logic
        M->>DB: Query/Update
        DB->>M: Result

        alt Cache Hit
            M->>RD: Check Cache
            RD->>M: Cached Data
        end

        M->>S: Return Result
        S->>R: Service Response

        alt Async Job Needed
            S->>RD: Enqueue Job
            SK->>RD: Fetch Job
            SK->>S: Execute Worker
        end

        R->>P: Response
        P->>W: HTTP Response
        W->>N: Forward Response
        N->>C: HTTPS Response
    end
```

## データベース構成図

```mermaid
erDiagram
    MAIN_DB {
        users PK
        projects PK
        groups PK
        namespaces PK
        issues PK
        merge_requests PK
        notes PK
        labels PK
        milestones PK
    }

    CI_DB {
        ci_pipelines PK
        ci_builds PK
        ci_stages PK
        ci_job_artifacts PK
        ci_runners PK
        ci_variables PK
    }

    GEO_DB {
        geo_nodes PK
        geo_event_log PK
        geo_repositories PK
    }

    REDIS_CACHE {
        sessions KEY
        cache KEY
        queues KEY
        feature_flags KEY
        rate_limiting KEY
    }

    CLICKHOUSE {
        ci_finished_builds TABLE
        analytics_events TABLE
    }

    ELASTICSEARCH {
        projects INDEX
        issues INDEX
        merge_requests INDEX
        notes INDEX
        commits INDEX
    }

    MAIN_DB ||--o{ CI_DB : "references"
    MAIN_DB ||--o{ GEO_DB : "replicates"
    MAIN_DB ||--o{ REDIS_CACHE : "caches"
    MAIN_DB ||--o{ ELASTICSEARCH : "indexes"
    CI_DB ||--o{ CLICKHOUSE : "analytics"
```

## Sidekiq ワーカー構成図

```mermaid
flowchart TB
    subgraph HighPriority["High Priority (weight: 5)"]
        Mailers["Mailers"]
        Webhooks["Webhooks"]
        PipelineProcess["Pipeline<br/>Processing"]
    end

    subgraph MediumPriority["Medium Priority (weight: 3)"]
        PostReceive["Post Receive"]
        MergeWorker["Merge Worker"]
        BuildProcess["Build<br/>Processing"]
    end

    subgraph LowPriority["Low Priority (weight: 1)"]
        Cleanup["Cleanup<br/>Workers"]
        Analytics["Analytics<br/>Workers"]
        BackfillMigration["Background<br/>Migrations"]
        Cronjobs["Cron Jobs"]
    end

    subgraph Redis["Redis Queues"]
        DefaultQueue["default"]
        MailerQueue["mailers"]
        CIQueue["ci_*"]
        AnalyticsQueue["analytics_*"]
        CronQueue["cronjob:*"]
    end

    Mailers --> MailerQueue
    Webhooks --> DefaultQueue
    PipelineProcess --> CIQueue
    PostReceive --> DefaultQueue
    MergeWorker --> DefaultQueue
    BuildProcess --> CIQueue
    Cleanup --> DefaultQueue
    Analytics --> AnalyticsQueue
    BackfillMigration --> DefaultQueue
    Cronjobs --> CronQueue
```

## 認証・認可フロー図

```mermaid
flowchart TB
    subgraph AuthMethods["認証方式"]
        Session["Session<br/>(Devise)"]
        PAT["Personal<br/>Access Token"]
        OAuth["OAuth 2.0<br/>(Doorkeeper)"]
        SAML["SAML SSO"]
        LDAP["LDAP"]
        TwoFactor["2FA<br/>(TOTP/WebAuthn)"]
    end

    subgraph AuthFlow["認証フロー"]
        Request["Request"]
        Authenticate["Authenticate"]
        LoadUser["Load User"]
        CheckPolicy["Check Policy"]
        Authorize["Authorize"]
    end

    subgraph Policies["認可ポリシー"]
        BasePolicy["BasePolicy"]
        ProjectPolicy["ProjectPolicy"]
        GroupPolicy["GroupPolicy"]
        IssuePolicy["IssuePolicy"]
        MRPolicy["MergeRequestPolicy"]
    end

    Session --> Authenticate
    PAT --> Authenticate
    OAuth --> Authenticate
    SAML --> Authenticate
    LDAP --> Authenticate

    Authenticate --> TwoFactor
    TwoFactor --> LoadUser
    LoadUser --> CheckPolicy

    CheckPolicy --> BasePolicy
    BasePolicy --> ProjectPolicy
    BasePolicy --> GroupPolicy
    BasePolicy --> IssuePolicy
    BasePolicy --> MRPolicy

    CheckPolicy --> Authorize
    Authorize -->|Allowed| Action["Execute Action"]
    Authorize -->|Denied| Forbidden["403 Forbidden"]
```
