---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 42
  claims_with_evidence: 38
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：38 / 42、根拠なし：4
- 優先レビュー（高）
  1. **推奨スペック値**：公式ドキュメントまたは外部情報源が必要
  2. **可用性構成の詳細**：本番環境のOmnibus/Helm設定は未解析
  3. **具体的なスケーリング閾値**：負荷テスト結果などの外部情報が必要
  4. **推奨構成（ユーザー数別）**：公式ドキュメントに基づく情報

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docker-compose.yml` - DockerイメージとしてGitLab CEを使用
- E-02: `Dockerfile.assets` - アセット用コンテナ定義
- E-03: `qa/Dockerfile` - QAテスト用Dockerfile（Ruby 3.3.7、Git 2.51等のバージョン情報）
- E-04: `qa/gdk/Dockerfile.gdk` - GDK開発環境Dockerfile（マルチステージビルド構成）
- E-05: `config/database.yml.postgresql` - PostgreSQLデータベース設定（main, ci, geo）
- E-06: `config/redis.yml.example` - Redis設定（クラスタ/スタンドアロン構成）
- E-07: `config/puma.rb.example` - Pumaアプリケーションサーバー設定
- E-08: `config/gitlab.yml.example` - GitLab全体設定ファイル
- E-09: `config/sidekiq_queues.yml` - Sidekiqキュー定義（1300+キュー）
- E-10: `lib/support/systemd/gitlab-puma.service` - Puma systemdサービス定義
- E-11: `lib/support/systemd/gitlab-sidekiq.service` - Sidekiq systemdサービス定義
- E-12: `lib/support/systemd/gitlab-gitaly.service` - Gitaly systemdサービス定義
- E-13: `lib/support/systemd/gitlab-workhorse.service` - Workhorse systemdサービス定義
- E-14: `config/environments/production.rb` - Rails本番環境設定
- E-15: `qa/gdk/gdk.yml` - GDK設定ファイル
- E-16: `storybook/.env.template` - 環境変数テンプレート

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GitLabはRails Applicationで構成される | E-07, E-08, E-14 | ○ |
| C-02 | PumaがRailsアプリケーションサーバーとして使用される | E-07, E-10 | ○ |
| C-03 | Pumaのワーカー数はデフォルト3 | E-07 (`workers 3`) | ○ |
| C-04 | Pumaのスレッド数は1-16 | E-07 (`threads 1, 16`) | ○ |
| C-05 | Sidekiqがバックグラウンドジョブ処理に使用される | E-09, E-11 | ○ |
| C-06 | Gitalyがgitリポジトリアクセスサービス | E-12 | ○ |
| C-07 | GitLab WorkhorseがリバースプロキシとしてPumaの前段に配置 | E-13 | ○ |
| C-08 | PostgreSQLがメインデータベースとして使用される | E-05 | ○ |
| C-09 | PostgreSQLはmain, ci, geoの3データベースに分離 | E-05 | ○ |
| C-10 | Redisがキャッシュ・セッション・キュー管理に使用される | E-06 | ○ |
| C-11 | Redis Clusterモードがサポートされる | E-06 (cluster設定) | ○ |
| C-12 | Ruby 3.3.7が使用される | E-03 (`RUBY_VERSION=3.3.7`) | ○ |
| C-13 | Git 2.51+が使用される | E-03 (`GIT_VERSION=2.51`) | ○ |
| C-14 | systemdサービスとしてデプロイ可能 | E-10, E-11, E-12, E-13 | ○ |
| C-15 | Pumaサービスはnotifyタイプ | E-10 (`Type=notify`) | ○ |
| C-16 | Sidekiqサービスはnotifyタイプ | E-11 (`Type=notify`) | ○ |
| C-17 | サービスは自動再起動設定 | E-10 (`Restart=on-failure`) | ○ |
| C-18 | ワーカータイムアウトは60秒 | E-07 (`worker_timeout 60`) | ○ |
| C-19 | Pumaはpreload_app!で事前読み込み | E-07 | ○ |
| C-20 | Sidekiqは1300以上のキューを持つ | E-09 (1310行のキュー定義) | ○ |
| C-21 | merge, pipeline_processingが優先度5 | E-09 | ○ |
| C-22 | S3/GCSオブジェクトストレージがサポートされる | E-08 (object_store設定) | ○ |
| C-23 | LDAP認証がサポートされる | E-08 (ldap設定) | ○ |
| C-24 | Elasticsearchがサポートされる | E-08 (elasticsearch設定) | ○ |
| C-25 | Prometheusメトリクスがサポートされる | E-08 (monitoring設定) | ○ |
| C-26 | Sidekiq Exporterはポート8082 | E-08 | ○ |
| C-27 | Web Exporterはポート8083 | E-08 | ○ |
| C-28 | バックアップ先はtmp/backupsがデフォルト | E-08 | ○ |
| C-29 | Docker ComposeでGitLab CE/EEをデプロイ可能 | E-01 | ○ |
| C-30 | GDKはマルチステージビルドを採用 | E-04 | ○ |
| C-31 | Consulがサポートされる | E-08 (consul設定) | ○ |
| C-32 | load_balancing設定でレプリカ分散可能 | E-05 (コメント部分) | ○ |
| C-33 | ログフォーマットはJSON | E-07, E-08 | ○ |
| C-34 | RAILS_ENV=productionで本番動作 | E-10, E-14 | ○ |
| C-35 | PostgreSQL max_connections: 200 | E-15 | ○ |
| C-36 | Content Security Policyが設定可能 | E-08 | ○ |
| C-37 | Rack Attackによるブルートフォース対策 | E-08 | ○ |
| C-38 | Sentryによるエラートラッキング | E-08 (sentry設定) | ○ |
| C-39 | 推奨サーバースペック (4vCPU, 8GB RAM等) | **根拠なし** | △ |
| C-40 | 推奨構成 (ユーザー数別の構成) | **根拠なし** | △ |
| C-41 | 具体的なスケーリング閾値 | **根拠なし** | △ |
| C-42 | Praefectによるクラスタ構成 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **推奨スペック値 (C-39)**: コードベースに具体的なハードウェア要件の記載なし
  - 候補：公式ドキュメント / GitLab Performance Documentation / 負荷テスト結果
- **推奨構成 (C-40)**: ユーザー数に応じた構成ガイドラインはコードに含まれない
  - 候補：GitLab Reference Architectures / 公式ドキュメント
- **スケーリング閾値 (C-41)**: 自動スケーリングの具体的閾値は設定ファイルに含まれない
  - 候補：Kubernetes HPA設定 / 運用マニュアル
- **Praefect構成 (C-42)**: Praefect関連の設定ファイルは解析対象外
  - 候補：gitaly/praefect設定 / Omnibus/Helm chart

## 5) リスクフラグ（レビュー観点）
- **リスク1 (中)**: 推奨スペックは公式ドキュメントと照合が必要
- **リスク1 (中)**: 可用性構成の詳細はOmnibus/Helm chartの解析が必要
- **リスク0 (低)**: コア構成要素（Puma, Sidekiq, PostgreSQL, Redis）は設定ファイルで裏付け済み
- **リスク0 (低)**: systemdサービス定義は実ファイルで確認済み
- **リスク0 (低)**: Sidekiqキュー構成は自動生成ファイルで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 推奨スペック値がGitLab公式ドキュメントと一致しているか確認
- [ ] 本番環境でのPraefect構成が必要な場合、追加ドキュメントを作成
- [ ] Omnibus/Helm chartを使用する場合、それらの設定ファイルとの整合性を確認
- [ ] 監視設定（Prometheus, Sentry）が組織の監視ポリシーと一致するか確認
- [ ] バックアップ頻度・保持期間が組織のRPO/RTO要件を満たすか確認
- [ ] Redis構成（Standalone vs Cluster）が負荷要件に適合しているか確認
- [ ] PostgreSQLのHA構成が可用性要件を満たすか確認
