# インフラ構成図

本ドキュメントでは、GitLabのインフラストラクチャ構成をMermaid図で表現する。

## 全体システム構成図

```mermaid
graph TB
    subgraph External["外部クライアント"]
        Browser["Web Browser"]
        GitClient["Git Client (SSH/HTTPS)"]
        API["API Client"]
    end

    subgraph LB["Load Balancer Layer"]
        nginx["nginx / Load Balancer"]
    end

    subgraph Web["Web Tier"]
        Workhorse["GitLab Workhorse<br/>(リバースプロキシ)"]
        Puma["Puma<br/>(Rails Application Server)<br/>Workers: 3, Threads: 1-16"]
    end

    subgraph Background["Background Processing"]
        Sidekiq["Sidekiq Cluster<br/>(バックグラウンドジョブ)"]
    end

    subgraph Git["Git Services"]
        Shell["GitLab Shell<br/>(SSH操作)"]
        Gitaly["Gitaly<br/>(Git Repository Service)"]
    end

    subgraph Data["Data Layer"]
        PostgreSQL["PostgreSQL<br/>(main, ci, geo)"]
        Redis["Redis<br/>(Cluster / Standalone)"]
    end

    subgraph Storage["Storage"]
        LocalFS["Local Filesystem<br/>(repositories, uploads)"]
        ObjectStorage["Object Storage<br/>(S3 / GCS)"]
    end

    Browser --> nginx
    API --> nginx
    GitClient -->|SSH:22| Shell
    GitClient -->|HTTPS:443| nginx

    nginx -->|Unix Socket| Workhorse
    Workhorse -->|Unix Socket| Puma
    Workhorse --> LocalFS

    Puma --> PostgreSQL
    Puma --> Redis
    Puma -->|Unix Socket| Gitaly
    Puma --> ObjectStorage

    Sidekiq --> PostgreSQL
    Sidekiq --> Redis
    Sidekiq --> Gitaly
    Sidekiq --> ObjectStorage

    Shell --> Gitaly
    Gitaly --> LocalFS
```

## コンポーネント詳細図

### Web/Application Tier

```mermaid
graph LR
    subgraph WebTier["Web Tier"]
        direction TB
        nginx["nginx<br/>:443/:80"]
        Workhorse["GitLab Workhorse<br/>(Unix Socket)"]
        Puma["Puma<br/>(Unix Socket)"]
        Assets["Static Assets<br/>/public/assets"]
    end

    Client["Client"] --> nginx
    nginx --> Workhorse
    Workhorse --> Puma
    Workhorse --> Assets

    Puma --> Rails["Rails Application<br/>production.rb"]
```

### データベース構成

```mermaid
graph TB
    subgraph Rails["Rails Application"]
        ActiveRecord["Active Record"]
    end

    subgraph PostgreSQL["PostgreSQL Databases"]
        Main["main<br/>gitlabhq_production<br/>(メインデータ)"]
        CI["ci<br/>gitlabhq_production<br/>(CI/CDデータ)"]
        Geo["geo<br/>gitlabhq_geo_production<br/>(Geo同期)"]
    end

    subgraph Replication["HA構成 (オプション)"]
        Primary["Primary"]
        Replica1["Read Replica 1"]
        Replica2["Read Replica 2"]
    end

    ActiveRecord --> Main
    ActiveRecord --> CI
    ActiveRecord --> Geo

    Primary --> Replica1
    Primary --> Replica2
```

### Redis構成

```mermaid
graph TB
    subgraph Application["Application Layer"]
        Rails["Rails / Sidekiq"]
    end

    subgraph RedisInstances["Redis Instances"]
        Cache["cache<br/>:7001"]
        Sessions["sessions<br/>:7001"]
        SharedState["shared_state<br/>:7001"]
        QueuesMetadata["queues_metadata<br/>:7001"]
        FeatureFlag["feature_flag<br/>:7001"]
        RateLimiting["rate_limiting<br/>:7001"]
        Chat["chat<br/>:7001"]
        Workhorse["workhorse<br/>:6379"]
    end

    Rails --> Cache
    Rails --> Sessions
    Rails --> SharedState
    Rails --> QueuesMetadata
    Rails --> FeatureFlag
    Rails --> RateLimiting
    Rails --> Chat
    Rails --> Workhorse
```

### Sidekiqキュー構成

```mermaid
graph TB
    subgraph Priority5["優先度 5 (最高)"]
        Merge["merge"]
        PipelineProcessing["pipeline_processing"]
        PostReceive["post_receive"]
        ReposPostReceive["repositories_post_receive"]
    end

    subgraph Priority4["優先度 4"]
        PipelineCreation["pipeline_creation"]
    end

    subgraph Priority3["優先度 3"]
        AutoMerge["auto_merge"]
        Deployment["deployment"]
        PipelineDefault["pipeline_default"]
        ProcessCommit["process_commit"]
        UpdateMergeRequests["update_merge_requests"]
        UpdateExternalPullRequests["update_external_pull_requests"]
    end

    subgraph Priority2["優先度 2"]
        AuthorizedKeys["authorized_keys"]
        AuthorizedProjects["authorized_projects"]
        Mailers["mailers"]
        NewIssue["new_issue"]
        NewMergeRequest["new_merge_request"]
    end

    subgraph Priority1["優先度 1 (標準)"]
        Default["default"]
        Cronjob["cronjob"]
        Other["その他1300+キュー"]
    end

    SidekiqCluster["Sidekiq Cluster"] --> Priority5
    SidekiqCluster --> Priority4
    SidekiqCluster --> Priority3
    SidekiqCluster --> Priority2
    SidekiqCluster --> Priority1
```

## デプロイメント構成図

### Docker/コンテナ構成

```mermaid
graph TB
    subgraph DockerCompose["Docker Compose (開発/検証)"]
        GitLabCE["gitlab/gitlab-ce:latest"]
    end

    subgraph GDK["GDK (開発環境)"]
        subgraph BuildStages["Multi-stage Build"]
            Base["Base Image<br/>(mise-bootstrapped)"]
            ShellBuild["gitlab-shell Build"]
            WorkhorseBuild["workhorse Build"]
            GitalyBuild["gitaly Build"]
            GemsBuild["gitlab-gems Build"]
            NodeModules["gitlab-node-modules Build"]
            FrontendAssets["frontend-assets Build"]
            FinalImage["Final GDK Image"]
        end

        Base --> ShellBuild
        Base --> WorkhorseBuild
        Base --> GitalyBuild
        Base --> GemsBuild
        Base --> NodeModules
        GemsBuild --> FrontendAssets
        ShellBuild --> FinalImage
        WorkhorseBuild --> FinalImage
        GitalyBuild --> FinalImage
        FrontendAssets --> FinalImage
        NodeModules --> FinalImage
    end

    subgraph Production["本番環境"]
        K8s["Kubernetes / Omnibus"]
    end
```

### systemdサービス構成

```mermaid
graph TB
    subgraph SystemD["systemd Services"]
        Target["gitlab.target"]

        subgraph Services["Individual Services"]
            PumaService["gitlab-puma.service<br/>Type=notify"]
            SidekiqService["gitlab-sidekiq.service<br/>Type=notify"]
            GitalyService["gitlab-gitaly.service<br/>Type=simple"]
            WorkhorseService["gitlab-workhorse.service<br/>Type=simple"]
            MailroomService["gitlab-mailroom.service"]
            PagesService["gitlab-pages.service"]
        end
    end

    Target --> PumaService
    Target --> SidekiqService
    Target --> GitalyService
    Target --> WorkhorseService
    Target --> MailroomService
    Target --> PagesService

    WorkhorseService -->|Wants| PumaService
    SidekiqService -->|JoinsNamespaceOf| PumaService
```

## ネットワークフロー図

### HTTPリクエストフロー

```mermaid
sequenceDiagram
    participant Client as Client Browser
    participant LB as Load Balancer
    participant WH as Workhorse
    participant Puma as Puma (Rails)
    participant PG as PostgreSQL
    participant Redis as Redis
    participant Gitaly as Gitaly

    Client->>LB: HTTPS Request
    LB->>WH: Forward (Unix Socket)

    alt Static Asset
        WH-->>Client: Return from /public
    else API/Page Request
        WH->>Puma: Forward Request
        Puma->>Redis: Session Check
        Puma->>PG: Query Data

        opt Repository Access
            Puma->>Gitaly: Git Operations
        end

        Puma-->>WH: Response
        WH-->>LB: Response
        LB-->>Client: HTTPS Response
    end
```

### Git SSH操作フロー

```mermaid
sequenceDiagram
    participant Client as Git Client
    participant Shell as GitLab Shell
    participant Gitaly as Gitaly
    participant FS as Filesystem

    Client->>Shell: SSH Connection (Port 22)
    Shell->>Shell: Authenticate (authorized_keys)
    Shell->>Gitaly: Git Command (gRPC)
    Gitaly->>FS: Repository Operations
    FS-->>Gitaly: Response
    Gitaly-->>Shell: Command Result
    Shell-->>Client: SSH Response
```

## 監視・運用構成図

```mermaid
graph TB
    subgraph Monitoring["監視システム"]
        Prometheus["Prometheus<br/>:9090"]
        Grafana["Grafana<br/>(可視化)"]
        Sentry["Sentry<br/>(エラートラッキング)"]
    end

    subgraph Exporters["Metrics Exporters"]
        SidekiqExporter["Sidekiq Exporter<br/>:8082"]
        WebExporter["Web Exporter<br/>:8083"]
    end

    subgraph GitLab["GitLab Components"]
        Puma["Puma"]
        Sidekiq["Sidekiq"]
    end

    subgraph Logging["ログ管理"]
        Syslog["systemd journal"]
        LogFiles["Log Files<br/>/home/git/gitlab/log/"]
    end

    Puma --> WebExporter
    Sidekiq --> SidekiqExporter

    WebExporter --> Prometheus
    SidekiqExporter --> Prometheus
    Prometheus --> Grafana

    Puma --> Sentry
    Sidekiq --> Sentry

    Puma --> LogFiles
    Sidekiq --> Syslog
```

## 外部サービス連携図

```mermaid
graph TB
    subgraph GitLab["GitLab"]
        Rails["Rails Application"]
        Sidekiq["Sidekiq"]
    end

    subgraph ObjectStorage["Object Storage"]
        S3["AWS S3"]
        GCS["Google Cloud Storage"]
    end

    subgraph Auth["認証サービス"]
        LDAP["LDAP / AD"]
        SAML["SAML Provider"]
        OAuth["OAuth Providers<br/>(GitHub, Google, etc.)"]
    end

    subgraph Search["検索・分析"]
        Elasticsearch["Elasticsearch"]
        ClickHouse["ClickHouse"]
    end

    subgraph Notifications["通知"]
        SMTP["SMTP Server"]
        Webhook["Webhooks"]
    end

    Rails --> S3
    Rails --> GCS
    Sidekiq --> S3
    Sidekiq --> GCS

    Rails --> LDAP
    Rails --> SAML
    Rails --> OAuth

    Rails --> Elasticsearch
    Rails --> ClickHouse

    Rails --> SMTP
    Rails --> Webhook
    Sidekiq --> SMTP
    Sidekiq --> Webhook
```
