# インフラ設計書

## 概要

本ドキュメントは、GitLab CE/EE (Community Edition / Enterprise Edition) のインフラストラクチャ設計について記載する。GitLabは、Gitリポジトリ管理、CI/CD、イシュー管理などを提供する統合DevOpsプラットフォームであり、複数のコンポーネントで構成されるマイクロサービスアーキテクチャを採用している。

## システム構成

### 全体構成

GitLabは以下の主要コンポーネントで構成される:

1. **Rails Application (GitLab Rails)** - メインのWebアプリケーション
2. **Puma** - Railsアプリケーションサーバー
3. **Sidekiq** - 非同期ジョブ処理
4. **Gitaly** - Gitリポジトリアクセスサービス
5. **GitLab Workhorse** - リバースプロキシ・ファイルアップロード処理
6. **GitLab Shell** - Git SSH操作
7. **PostgreSQL** - メインデータベース
8. **Redis** - キャッシュ・セッション・キュー管理
9. **GitLab Pages** - 静的サイトホスティング (オプション)
10. **Container Registry** - Dockerイメージレジストリ (オプション)

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| Webサーバー | Puma + GitLab Workhorse | 推奨: 4vCPU, 8GB RAM以上 | 1台以上 (HA構成では複数) |
| APサーバー | Sidekiq (バックグラウンドジョブ処理) | 推奨: 4vCPU, 8GB RAM以上 | 1台以上 |
| DBサーバー (PostgreSQL) | main, ci, geoデータベース | 推奨: 4vCPU, 16GB RAM以上 | 1台以上 (HA構成では複数) |
| Gitalyサーバー | Gitリポジトリ管理 | 推奨: 4vCPU, 16GB RAM以上 | 1台以上 |
| Redisサーバー | キャッシュ/セッション/キュー管理 | 推奨: 2vCPU, 4GB RAM以上 | 1台以上 (クラスタ構成可) |

### ネットワーク構成

#### ネットワークフロー

```
[Client Browser]
      |
      v (HTTPS: 443)
[Load Balancer / Reverse Proxy (nginx)]
      |
      v (Unix Socket / HTTP)
[GitLab Workhorse]
      |
      +---> (Unix Socket) ---> [Puma (Rails Application)]
      |                              |
      |                              +---> PostgreSQL (TCP: 5432)
      |                              +---> Redis (TCP: 6379/7001)
      |                              +---> Gitaly (Unix Socket / gRPC)
      |
      +---> [Static Files] (public/assets)

[Git SSH Client]
      |
      v (SSH: 22)
[GitLab Shell]
      |
      v
[Gitaly]
```

#### ポート構成

| サービス | デフォルトポート | プロトコル |
| --- | --- | --- |
| HTTP/HTTPS | 80/443 | TCP |
| SSH (Git操作) | 22 | TCP |
| PostgreSQL | 5432 | TCP |
| Redis (Standalone) | 6379 | TCP |
| Redis (Cluster) | 7001 | TCP |
| Gitaly | Unix Socket / TCP | gRPC |
| Workhorse | Unix Socket | HTTP |
| Puma | Unix Socket | HTTP |
| Prometheus Metrics (Sidekiq) | 8082 | TCP |
| Prometheus Metrics (Web) | 8083 | TCP |

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Ruby | 3.3.7 | Rails実行環境 |
| PostgreSQL | 14+ 推奨 | メインデータベース |
| Redis | 6.x / 7.x | キャッシュ、セッション、Sidekiqキュー |
| Puma | 最新版 | Railsアプリケーションサーバー |
| Git | 2.51+ | バージョン管理 |
| Go | 1.20+ | Gitaly, Workhorse, GitLab Shell |
| nginx | 最新版 | リバースプロキシ |
| Node.js | 最新LTS | フロントエンドビルド |
| Yarn | 最新版 | パッケージ管理 |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| AWS S3 / GCS | オブジェクトストレージ (artifacts, LFS, uploads, packages) | HTTPS (API) |
| SMTP Server | メール送信 | SMTP/SMTPS |
| LDAP/Active Directory | ユーザー認証・同期 | LDAP/LDAPS |
| Elasticsearch | 高度検索機能 | HTTPS (REST API) |
| Prometheus | メトリクス収集・監視 | HTTP |
| Sentry | エラートラッキング | HTTPS |
| Consul | サービスディスカバリ | HTTP (8500) |
| ClickHouse | CI/CD分析データ | TCP/HTTP |

## スケーリング設計

### 水平スケーリング

1. **Puma (Webサーバー)**
   - ワーカー数: デフォルト3、スレッド数1-16
   - 複数インスタンスをロードバランサー背後に配置可能
   - `preload_app!`によるメモリ効率化

2. **Sidekiq (バックグラウンドジョブ)**
   - 複数のSidekiqプロセスをクラスタで運用
   - キュー優先度: merge(5), pipeline_processing(5), post_receive(5)
   - ルーティングルールによるキュー分散

3. **Gitaly**
   - Praefectによるクラスタ構成
   - リポジトリデータの分散配置

4. **Redis**
   - Redis Clusterモードサポート
   - 用途別分離: cache, sessions, shared_state, queues_metadata, rate_limiting, feature_flag

### 垂直スケーリング

- Pumaスレッド数の調整 (`threads 1, 16`)
- PostgreSQLコネクション数の調整 (`max_connections: 200`)
- Sidekiqワーカー数の調整

## 可用性設計

### 冗長構成

| コンポーネント | 冗長化方式 |
| --- | --- |
| Puma | 複数インスタンス + ロードバランサー |
| Sidekiq | 複数プロセス (クラスタ) |
| PostgreSQL | レプリケーション + pgbouncer |
| Redis | Sentinel / Cluster |
| Gitaly | Praefectクラスタ |

### フェイルオーバー

- **PostgreSQL**: load_balancing設定による読み取りレプリカ分散
  ```yaml
  load_balancing:
    hosts:
      - host1.example.com
      - host2.example.com
  ```
- **Redis**: Sentinel/Cluster構成による自動フェイルオーバー
- **Puma**: systemdによる自動再起動 (`Restart=on-failure`)
- **ワーカータイムアウト**: 60秒 (`worker_timeout 60`)

### ヘルスチェック

- Puma: systemdの`WatchdogSec=10`
- Docker環境: `HEALTHCHECK`によるHTTPエンドポイント監視
  - エンドポイント: `/users/sign_in`
  - 間隔: 10秒、タイムアウト: 1秒、リトライ: 17回

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| PostgreSQLデータベース | pg_dump / gitlab-backup | 日次推奨 | 設定可能 (デフォルト: 無期限) |
| Gitリポジトリ | gitaly-backup | 日次推奨 | 設定可能 |
| アップロードファイル | ファイルシステムバックアップ / S3同期 | 日次推奨 | 設定可能 |
| 設定ファイル | ファイルシステムバックアップ | 変更時 | 世代管理 |

### バックアップ設定

```yaml
backup:
  path: "tmp/backups"
  # gitaly_backup_path: /home/git/gitaly/_build/bin/gitaly-backup
  # archive_permissions: 0640
  # keep_time: 604800  # 7日間 (秒)
  # upload:
  #   connection:
  #     provider: AWS
  #     region: eu-west-1
  #   remote_directory: 'my.s3.bucket'
```

## 監視設計

### Prometheus監視

- **Sidekiq Exporter**: ポート8082
- **Web Exporter**: ポート8083
- **対象メトリクス**:
  - HTTPリクエスト数/レイテンシ
  - Sidekiqジョブ数/処理時間
  - データベースクエリ
  - Gitalyオペレーション

### ログ管理

| ログ種別 | 出力先 | フォーマット |
| --- | --- | --- |
| Puma stdout | /home/git/gitlab/log/puma.stdout.log | JSON |
| Puma stderr | /home/git/gitlab/log/puma.stderr.log | JSON |
| Sidekiq | systemd journal | JSON (`log_format: json`) |
| Rails | /home/git/gitlab/log/ | JSON |

### アラート設定

- Prometheusアラートルールによる通知
- Sentryによるエラートラッキング
- IPホワイトリストによる監視エンドポイントアクセス制御
  ```yaml
  monitoring:
    ip_whitelist:
      - 127.0.0.0/8
  ```

## Docker/コンテナ構成

### 開発環境 (GDK)

| コンポーネント | イメージ/ビルド |
| --- | --- |
| GDK Base | registry.gitlab.com/gitlab-org/gitlab-development-kit/mise-bootstrapped-verify/main |
| GitLab Shell | マルチステージビルド |
| GitLab Workhorse | マルチステージビルド |
| Gitaly | マルチステージビルド |
| フロントエンドアセット | Node.js + Yarnビルド |

### 本番環境

| イメージ | 用途 |
| --- | --- |
| gitlab/gitlab-ce:latest | GitLab Community Edition |
| gitlab/gitlab-ee:latest | GitLab Enterprise Edition |

### コンテナ設定

```yaml
# docker-compose.yml
app:
  image: gitlab/gitlab-ce:latest
```

- 公開ポート: 3000 (開発環境)
- ヘルスチェック: HTTP GET /users/sign_in
- エントリポイント: /home/gdk/entrypoint

## データベース構成

### データベース分離

| データベース | 用途 | 環境別名 |
| --- | --- | --- |
| main | メインデータ (ユーザー、プロジェクト等) | gitlabhq_production |
| ci | CI/CDデータ | gitlabhq_production (database_tasks: false) |
| geo | Geo同期データ (EE) | gitlabhq_geo_production |
| embedding | AI埋め込みデータ (テスト環境のみ) | gitlabhq_embedding_test |

### 接続設定

```yaml
production:
  main:
    adapter: postgresql
    encoding: unicode
    database: gitlabhq_production
    username: git
    host: localhost
    variables:
      statement_timeout: 15s
```

## 備考

### セキュリティ考慮事項

1. **TLS/SSL**: 本番環境ではHTTPS必須
2. **Content Security Policy**: 有効化推奨
3. **Rack Attack**: Git Basic Auth のブルートフォース対策
4. **シークレット管理**:
   - `.gitlab_shell_secret`
   - `.gitlab_workhorse_secret`
   - `.gitlab_kas_secret`
   - `.gitlab_mailroom_secret`

### 推奨構成

- **小規模** (最大500ユーザー): 単一サーバー構成
- **中規模** (500-2000ユーザー): 2-4サーバー構成
- **大規模** (2000ユーザー以上): フルHA構成 + 専用Gitalyクラスタ

### 環境変数

| 変数名 | 用途 | デフォルト |
| --- | --- | --- |
| RAILS_ENV | Rails実行環境 | production |
| GITLAB_LOG_LEVEL | ログレベル | info |
| PUMA_WAIT_FOR_LESS_BUSY_WORKER | ワーカー待機時間 | 0.001 |
| SIDEKIQ_QUEUES | Sidekiqキュー指定 | * |
