---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **HSTS設定の詳細**：具体的な設定ファイルの確認が必要
  2. **監査ログ保持期間**：設定依存のため具体値未確認
  3. **TLSバージョン要件**：OpenSSL設定に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `config/initializers/8_devise.rb`（認証設定）
- E-02: `config/initializers/session_store.rb`（セッション設定）
- E-03: `app/controllers/concerns/authenticates_with_two_factor.rb`（2FA実装）
- E-04: `app/controllers/application_controller.rb`（CSRF保護）
- E-05: `config/initializers/content_security_policy.rb`（CSP設定）
- E-06: `lib/gitlab/content_security_policy/config_loader.rb`（CSPローダー）
- E-07: `app/policies/base_policy.rb`（基本ポリシー）
- E-08: `app/policies/project_policy.rb`（プロジェクトポリシー）
- E-09: `app/models/audit_event.rb`（監査イベントモデル）
- E-10: `app/services/audit_event_service.rb`（監査イベントサービス）
- E-11: `app/models/concerns/encrypted_user_password.rb`（パスワード暗号化）
- E-12: `app/models/application_setting.rb`（アプリケーション設定・暗号化フィールド）
- E-13: `app/uploaders/terraform/state_uploader.rb`（Terraform暗号化）
- E-14: `app/uploaders/ci/secure_file_uploader.rb`（CIセキュアファイル暗号化）
- E-15: `app/controllers/omniauth_callbacks_controller.rb`（OmniAuth認証）
- E-16: `app/models/deploy_token.rb`（デプロイトークン）
- E-17: `app/models/remote_mirror.rb`（リモートミラー暗号化）
- E-18: `config/environments/production.rb`（本番環境設定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Deviseフレームワークを基盤とした認証 | E-01 | ○ |
| C-02 | パスワード最小文字数8文字 | E-01 (137行目: `config.password_length = 8..128`) | ○ |
| C-03 | BCrypt stretches: 13（本番） | E-01 (85行目: `config.stretches = Rails.env.test? ? 5 : 13`) | ○ |
| C-04 | PBKDF2-SHA512サポート | E-11 (10行目: `PBKDF2_SHA512_PREFIX`) | ○ |
| C-05 | セッション有効期限10080分 | E-02 (10行目: `session_expire_delay || 10080`) | ○ |
| C-06 | サインアウト方式POST | E-01 (229行目: `config.sign_out_via = :post`) | ○ |
| C-07 | 最大ログイン失敗回数10回 | E-01 (169行目: `max_login_attempts || 10`) | ○ |
| C-08 | アンロック方式email+time | E-01 (163行目: `config.unlock_strategy = :both`) | ○ |
| C-09 | 二要素認証（TOTP/WebAuthn） | E-03 | ○ |
| C-10 | パスキーによるパスワードレス認証 | E-03 (147行目: `Authn::Passkey::AuthenticateService`) | ○ |
| C-11 | CSRF保護 protect_from_forgery | E-04 (73行目) | ○ |
| C-12 | Guest/Reporter/Developer/Maintainer/Ownerロール | E-08 | ○ |
| C-13 | DeclarativePolicyフレームワーク使用 | E-07 (3行目: `class BasePolicy < DeclarativePolicy::Base`) | ○ |
| C-14 | 管理者権限チェック（admin condition） | E-07 (27-36行目) | ○ |
| C-15 | CSP default_src: 'self' | E-06 (38行目) | ○ |
| C-16 | CSP object_src: 'none' | E-06 (51行目) | ○ |
| C-17 | CSP frame_ancestors: 'self' | E-06 (43行目) | ○ |
| C-18 | CSP nonce対応 | E-05 (17-18行目) | ○ |
| C-19 | 監査イベントの月次パーティション | E-09 (20行目: `partitioned_by :created_at, strategy: :monthly`) | ○ |
| C-20 | 監査メッセージのサニタイズ | E-09 (39行目, 109-114行目) | ○ |
| C-21 | AES-256-GCM暗号化（attr_encrypted） | E-12 (961-969行目) | ○ |
| C-22 | Terraformステートの暗号化 | E-13 (12行目: `encrypt(key: :key)`) | ○ |
| C-23 | CIセキュアファイルの暗号化 | E-14 (10行目: `encrypt(key: :key)`) | ○ |
| C-24 | LDAP認証サポート | E-01 (244-249行目) | ○ |
| C-25 | OmniAuth認証サポート | E-01 (251-253行目), E-15 | ○ |
| C-26 | デプロイトークンの暗号化保存 | E-16 (21行目: `encrypted: :required`) | ○ |
| C-27 | リモートミラー認証情報の暗号化 | E-17 (14行目: `attr_encrypted :credentials`) | ○ |
| C-28 | IPアドレスブロック機能 | E-04 (105-114行目: `rescue_from Gitlab::Auth::IpBlocked`) | ○ |
| C-29 | レート制限機能 | E-04 (121-125行目: `rescue_from RateLimitedService::RateLimitedError`) | ○ |
| C-30 | パスワード変更後の自動サインイン無効 | E-01 (127行目: `config.sign_in_after_change_password = false`) | ○ |
| C-31 | パスワード変更通知メール | E-01 (130行目: `config.send_password_change_notification = true`) | ○ |
| C-32 | メールアドレス変更通知 | E-01 (133行目: `config.send_email_changed_notification = true`) | ○ |
| C-33 | パスワードリセット有効期間2日 | E-01 (191行目: `config.reset_password_within = 2.days`) | ○ |
| C-34 | 未確認アクセス許可期間3日 | E-01 (97行目: `config.allow_unconfirmed_access_for = 3.days`) | ○ |
| C-35 | 確認トークン有効期間1日 | E-01 (105行目: `config.confirm_within = 1.day`) | ○ |
| C-36 | paranoidモード有効 | E-01 (74行目: `config.paranoid = true`) | ○ |
| C-37 | 認証イベントの記録 | E-10 (150-156行目: `log_authentication_event_to_database`) | ○ |
| C-38 | 2FA失敗時のメール通知 | E-03 (256-258行目: `send_two_factor_otp_attempt_failed_email`) | ○ |
| C-39 | セッションCookieのRedis管理 | E-02 (45-47行目) | ○ |
| C-40 | Cookie暗号化ソルト設定 | E-02 (52-54行目) | ○ |
| C-41 | admin_mode機能 | E-07 (31-32行目) | ○ |
| C-42 | 外部認可サービス連携 | E-07 (108-110行目) | ○ |
| C-43 | HTTPS設定（force_ssl） | E-18 (37行目: コメントアウト状態) | △ |
| C-44 | HSTS設定の詳細 | **根拠なし** | △ |
| C-45 | 監査ログ保持期間の具体値 | **根拠なし**（設定依存） | △ |

## 4) 不足情報（Unknown / Missing）
- **HSTS設定**：Let's Encrypt連携のコード参照はあるが、HSTS具体設定の直接的な根拠が不足
  - 候補：`config/gitlab.yml` / Nginx/Puma設定 / ロードバランサー設定
- **監査ログ保持期間**：パーティション戦略は確認できるが、具体的な保持期間設定は運用設定に依存
  - 候補：管理者設定画面 / 運用ドキュメント / バックアップポリシー
- **TLSバージョン要件**：アプリケーションレベルでの設定ではなく、インフラ設定に依存
  - 候補：Nginx設定 / OpenSSL設定 / ロードバランサー設定

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**：認証・認可設計（コードベースで十分な根拠あり）
- **0 (低リスク)**：CSRF/XSS対策（明確なコード実装を確認）
- **0 (低リスク)**：暗号化設計（attr_encrypted、Lockbox使用を確認）
- **1 (中リスク)**：通信セキュリティ（HTTPS/HSTS）- インフラ設定依存のため要確認
- **1 (中リスク)**：監査ログ保持期間 - 運用ポリシー依存のため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] HTTPS/HSTS設定がインフラレベルで適切に構成されているか確認
- [ ] 監査ログの保持期間がコンプライアンス要件を満たしているか確認
- [ ] TLSバージョン設定がセキュリティ要件を満たしているか確認
- [ ] Enterprise Edition固有のセキュリティ機能（監査ストリーミング等）の追加要否を検討
- [ ] 実運用環境でのセキュリティ設定値（max_login_attempts等）がポリシーに適合しているか確認
