---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **アクセスレベルの値定義**：コード内での定義確認が必要
  2. **可視性レベルの値定義**：コード内での定義確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `db/structure.sql` - PostgreSQLスキーマ定義ファイル（約987テーブル）
- E-02: `db/structure.sql:394-444` - namespacesテーブル定義
- E-03: `db/structure.sql:454-540` - projectsテーブル定義
- E-04: `db/structure.sql:550-634` - usersテーブル定義
- E-05: `db/structure.sql:21502-1527` - membersテーブル定義
- E-06: `db/structure.sql:20906-20958` - issuesテーブル定義
- E-07: `db/structure.sql:21931-21979` - merge_requestsテーブル定義
- E-08: `db/structure.sql:21219-21235` - labelsテーブル定義
- E-09: `db/structure.sql:22175-22192` - milestonesテーブル定義
- E-10: `db/structure.sql:5888-5924` - p_ci_pipelinesテーブル定義
- E-11: `db/structure.sql:5702-5756` - p_ci_buildsテーブル定義
- E-12: `db/structure.sql:22903-22936` - notesテーブル定義
- E-13: `db/structure.sql:18962-18977` - eventsテーブル定義
- E-14: `db/structure.sql:18117-18134` - deploymentsテーブル定義
- E-15: `db/structure.sql:27118-27133` - releasesテーブル定義
- E-16: `db/structure.sql:1-8` - パーティションスキーマ定義
- E-17: `db/structure.sql:719-741` - loose_foreign_keys関連トリガー定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GitLabは約987テーブルから構成される | E-01（grep結果で987テーブルを確認） | ○ |
| C-02 | namespacesテーブルはユーザー/グループを統一管理する | E-02 | ○ |
| C-03 | namespacesにtype列が存在しUser/Group/Projectを区別 | E-02（type列のDEFAULT 'User'を確認） | ○ |
| C-04 | projectsテーブルにnamespace_id NOT NULL制約がある | E-03（namespace_id bigint NOT NULL確認） | ○ |
| C-05 | projectsテーブルにorganization_id NOT NULL制約がある | E-03（check_1a6f946a8a制約確認） | ○ |
| C-06 | usersテーブルにencrypted_password列がある | E-04 | ○ |
| C-07 | usersテーブルにotp_required_for_login（2FA）フラグがある | E-04 | ○ |
| C-08 | membersテーブルでaccess_levelでアクセス権を管理 | E-05 | ○ |
| C-09 | access_levelの値は10:Guest〜50:Owner | **根拠なし** | △ |
| C-10 | issuesテーブルにstate_id列がある（1:open, 2:closed） | E-06（state_id smallint DEFAULT 1確認） | ○ |
| C-11 | issuesテーブルにnamespace_id NOT NULL制約がある | E-06（check_c33362cd43制約確認） | ○ |
| C-12 | merge_requestsテーブルにtarget_branch NOT NULL制約がある | E-07 | ○ |
| C-13 | merge_requestsテーブルにhead_pipeline_id列がある | E-07 | ○ |
| C-14 | labelsテーブルはproject_idまたはgroup_idで所属を管理 | E-08 | ○ |
| C-15 | milestonesテーブルにnum_nonnulls(group_id, project_id) = 1制約がある | E-09（check_08e9c27987確認） | ○ |
| C-16 | p_ci_pipelinesはpartition_idでリストパーティション化されている | E-10（PARTITION BY LIST (partition_id)確認） | ○ |
| C-17 | p_ci_pipelinesにproject_id NOT NULL制約がある | E-10（check_2ba2a044b9制約確認） | ○ |
| C-18 | notesテーブルにnoteable_type列がある | E-12（noteable_type NOT NULL確認） | ○ |
| C-19 | eventsテーブルにaction列がある | E-13 | ○ |
| C-20 | deploymentsテーブルにstatus列がある | E-14 | ○ |
| C-21 | releasesテーブルにproject_id NOT NULL制約がある | E-15（check_6bb9ce4925確認） | ○ |
| C-22 | gitlab_partitions_dynamicスキーマが存在する | E-16 | ○ |
| C-23 | gitlab_partitions_staticスキーマが存在する | E-16 | ○ |
| C-24 | loose_foreign_keys機能が実装されている | E-17 | ○ |
| C-25 | visibility_levelは0:private, 10:internal, 20:public | **根拠なし**（コード内定数を要確認） | △ |

## 4) 不足情報（Unknown / Missing）
- C-09（access_levelの値定義）について
  - structure.sqlにはaccess_level列の定義はあるが、具体的な値（10, 20, 30, 40, 50）の意味はRubyコード内の定数で定義されている
  - 候補：`app/models/concerns/access_level.rb` / `lib/gitlab/access.rb` / ドキュメント

- C-25（visibility_levelの値定義）について
  - structure.sqlにはvisibility_level列の定義はあるが、具体的な値（0, 10, 20）の意味はRubyコード内で定義されている
  - 候補：`app/models/concerns/visibility_level.rb` / `lib/gitlab/visibility_level.rb` / ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: テーブル構造・カラム定義はstructure.sqlから直接抽出しており信頼性が高い
- **1（中リスク）**: アクセスレベル・可視性レベルの具体的な値についてはRubyコードでの追加確認を推奨
- **0（低リスク）**: パーティション化の記述はstructure.sqlのPARTITION BY句から確認済み
- **0（低リスク）**: 外部キー制約・CHECK制約はstructure.sqlから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] namespacesテーブルのtype列の値（User/Group/Project以外があるか確認）
- [ ] access_levelの具体的な値定義をRubyコードで確認（10:Guest, 20:Reporter, 30:Developer, 40:Maintainer, 50:Owner）
- [ ] visibility_levelの具体的な値定義をRubyコードで確認（0:private, 10:internal, 20:public）
- [ ] 約987テーブルという数値の最新性を確認（structure.sqlの更新日時を確認）
- [ ] パーティションテーブルの運用ルール（partition_idの払い出し方法等）を確認
- [ ] loose_foreign_keysの対象テーブル一覧が必要な場合は追加調査
