# データベース設計書

## 概要

本ドキュメントは、GitLab プロジェクトのデータベース設計を記載したものです。GitLabはDevOpsプラットフォームとして、ソースコード管理、CI/CD、イシュートラッキング、コードレビューなど多くの機能を提供しており、約987テーブルから構成される大規模なPostgreSQLデータベースを使用しています。

本書では、GitLabのコア機能を構成する主要テーブルを中心に、その構造とリレーションシップを説明します。

## テーブル一覧

### コアエンティティ

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| namespaces | ネームスペース | ユーザー/グループを統一的に管理するエンティティ |
| projects | プロジェクト | Gitリポジトリとその関連設定を管理 |
| users | ユーザー | システムユーザー情報を管理 |
| members | メンバー | ユーザーとプロジェクト/グループの関連を管理 |

### イシュー・マージリクエスト

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| issues | イシュー | バグ報告や機能要望などのイシューを管理 |
| merge_requests | マージリクエスト | コードレビュー・マージのリクエストを管理 |
| labels | ラベル | イシューやMRの分類用ラベル |
| milestones | マイルストーン | プロジェクトの期間目標を管理 |

### CI/CD

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| p_ci_pipelines | パイプライン | CI/CDパイプラインを管理（パーティション化） |
| p_ci_builds | ビルド | パイプライン内のジョブ/ビルドを管理（パーティション化） |
| p_ci_stages | ステージ | パイプラインのステージを管理（パーティション化） |
| p_ci_job_artifacts | ジョブ成果物 | ビルド成果物を管理（パーティション化） |

### その他の重要テーブル

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| notes | ノート/コメント | イシューやMRへのコメントを管理 |
| events | イベント | ユーザーアクティビティを記録 |
| deployments | デプロイメント | 環境へのデプロイ情報を管理 |
| releases | リリース | プロジェクトリリースを管理 |

## 各テーブル定義

### 1. namespaces

ユーザー個人の名前空間またはグループを表現するテーブルです。GitLabでは階層的なグループ構造をサポートしており、`parent_id`と`traversal_ids`で親子関係を管理しています。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint | NOT NULL | 主キー |
| name | character varying | NOT NULL | 表示名 |
| path | character varying | NOT NULL | URL用パス |
| owner_id | bigint | NULL | 所有者ユーザーID |
| created_at | timestamp | NULL | 作成日時 |
| updated_at | timestamp | NULL | 更新日時 |
| type | character varying | NOT NULL | タイプ（User/Group/Project） |
| description | character varying | NOT NULL | 説明文 |
| visibility_level | integer | NOT NULL | 可視性レベル（0:private, 10:internal, 20:public） |
| parent_id | bigint | NULL | 親ネームスペースID |
| organization_id | bigint | NOT NULL | 所属組織ID |
| traversal_ids | bigint[] | NOT NULL | 階層パス配列 |
| state | smallint | NULL | 状態 |

### 2. projects

Gitリポジトリとその関連設定を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint | NOT NULL | 主キー |
| name | character varying | NULL | プロジェクト名 |
| path | character varying | NULL | URL用パス |
| description | text | NULL | 説明文 |
| created_at | timestamp | NULL | 作成日時 |
| updated_at | timestamp | NULL | 更新日時 |
| creator_id | bigint | NULL | 作成者ユーザーID |
| namespace_id | bigint | NOT NULL | 所属ネームスペースID |
| last_activity_at | timestamp | NULL | 最終アクティビティ日時 |
| visibility_level | integer | NOT NULL | 可視性レベル |
| archived | boolean | NOT NULL | アーカイブ済みフラグ |
| star_count | integer | NOT NULL | スター数 |
| repository_storage | character varying | NOT NULL | リポジトリストレージ名 |
| project_namespace_id | bigint | NOT NULL | プロジェクト用ネームスペースID |
| organization_id | bigint | NOT NULL | 所属組織ID |

### 3. users

システムユーザーを管理するテーブルです。認証情報や個人設定を含みます。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint | NOT NULL | 主キー |
| email | character varying | NOT NULL | メールアドレス |
| encrypted_password | character varying | NOT NULL | 暗号化されたパスワード |
| reset_password_token | character varying | NULL | パスワードリセットトークン |
| sign_in_count | integer | NULL | サインイン回数 |
| current_sign_in_at | timestamp | NULL | 現在のサインイン日時 |
| created_at | timestamp | NULL | 作成日時 |
| updated_at | timestamp | NULL | 更新日時 |
| name | character varying | NULL | 表示名 |
| admin | boolean | NOT NULL | 管理者フラグ |
| projects_limit | integer | NOT NULL | プロジェクト作成上限 |
| username | character varying | NULL | ユーザー名 |
| state | character varying | NULL | 状態（active/blocked等） |
| otp_required_for_login | boolean | NOT NULL | 2FA必須フラグ |
| user_type | smallint | NOT NULL | ユーザータイプ |
| organization_id | bigint | NOT NULL | 所属組織ID |

### 4. members

ユーザーとプロジェクト/グループの関連（メンバーシップ）を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint | NOT NULL | 主キー |
| access_level | integer | NOT NULL | アクセスレベル（10:Guest〜50:Owner） |
| source_id | bigint | NOT NULL | ソースID（プロジェクト/グループID） |
| source_type | character varying | NOT NULL | ソースタイプ |
| user_id | bigint | NULL | ユーザーID |
| notification_level | integer | NOT NULL | 通知レベル |
| type | character varying | NULL | メンバータイプ |
| created_at | timestamp | NULL | 作成日時 |
| updated_at | timestamp | NULL | 更新日時 |
| invite_email | character varying | NULL | 招待メールアドレス |
| expires_at | date | NULL | 有効期限 |
| member_namespace_id | bigint | NOT NULL | メンバーネームスペースID |

### 5. issues

バグ報告、機能要望、タスクなどのイシューを管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint | NOT NULL | 主キー |
| title | character varying | NULL | タイトル |
| author_id | bigint | NULL | 作成者ユーザーID |
| project_id | bigint | NULL | プロジェクトID |
| created_at | timestamp | NULL | 作成日時 |
| updated_at | timestamp | NULL | 更新日時 |
| description | text | NULL | 説明文 |
| milestone_id | bigint | NULL | マイルストーンID |
| iid | integer | NULL | プロジェクト内連番 |
| state_id | smallint | NOT NULL | 状態（1:open, 2:closed） |
| confidential | boolean | NOT NULL | 機密フラグ |
| due_date | date | NULL | 期日 |
| weight | integer | NULL | 重み |
| work_item_type_id | bigint | NOT NULL | ワークアイテムタイプID |
| namespace_id | bigint | NOT NULL | ネームスペースID |

### 6. merge_requests

コードレビューとマージのリクエストを管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint | NOT NULL | 主キー |
| target_branch | character varying | NOT NULL | ターゲットブランチ名 |
| source_branch | character varying | NOT NULL | ソースブランチ名 |
| source_project_id | bigint | NULL | ソースプロジェクトID |
| author_id | bigint | NULL | 作成者ユーザーID |
| title | character varying | NULL | タイトル |
| created_at | timestamp | NULL | 作成日時 |
| updated_at | timestamp | NULL | 更新日時 |
| milestone_id | bigint | NULL | マイルストーンID |
| merge_status | character varying | NOT NULL | マージ状態 |
| target_project_id | bigint | NOT NULL | ターゲットプロジェクトID |
| iid | integer | NULL | プロジェクト内連番 |
| description | text | NULL | 説明文 |
| state_id | smallint | NOT NULL | 状態 |
| merge_user_id | bigint | NULL | マージ実行者ID |
| merge_commit_sha | character varying | NULL | マージコミットSHA |
| head_pipeline_id | bigint | NULL | HEADパイプラインID |
| draft | boolean | NOT NULL | ドラフトフラグ |

### 7. labels

イシューやマージリクエストの分類に使用するラベルを管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint | NOT NULL | 主キー |
| title | character varying | NULL | ラベル名 |
| color | character varying | NULL | 表示色 |
| project_id | bigint | NULL | プロジェクトID |
| created_at | timestamp | NULL | 作成日時 |
| updated_at | timestamp | NULL | 更新日時 |
| description | character varying | NULL | 説明文 |
| type | character varying | NULL | タイプ（ProjectLabel/GroupLabel） |
| group_id | bigint | NULL | グループID |
| organization_id | bigint | NULL | 組織ID |

### 8. milestones

プロジェクトやグループの期間目標を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint | NOT NULL | 主キー |
| title | character varying | NOT NULL | タイトル |
| project_id | bigint | NULL | プロジェクトID |
| description | text | NULL | 説明文 |
| due_date | date | NULL | 終了日 |
| created_at | timestamp | NULL | 作成日時 |
| updated_at | timestamp | NULL | 更新日時 |
| state | character varying | NULL | 状態（active/closed） |
| iid | integer | NULL | プロジェクト/グループ内連番 |
| start_date | date | NULL | 開始日 |
| group_id | bigint | NULL | グループID |

### 9. p_ci_pipelines

CI/CDパイプラインを管理するパーティションテーブルです。`partition_id`でパーティション化されています。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint | NOT NULL | 主キー |
| ref | character varying | NULL | 参照ブランチ/タグ |
| sha | character varying | NULL | コミットSHA |
| created_at | timestamp | NULL | 作成日時 |
| updated_at | timestamp | NULL | 更新日時 |
| tag | boolean | NULL | タグパイプラインフラグ |
| project_id | bigint | NOT NULL | プロジェクトID |
| status | character varying | NULL | 状態 |
| started_at | timestamp | NULL | 開始日時 |
| finished_at | timestamp | NULL | 終了日時 |
| duration | integer | NULL | 実行時間（秒） |
| user_id | bigint | NULL | トリガーユーザーID |
| source | integer | NULL | トリガー元 |
| failure_reason | integer | NULL | 失敗理由 |
| iid | integer | NULL | プロジェクト内連番 |
| partition_id | bigint | NOT NULL | パーティションキー |
| merge_request_id | bigint | NULL | 関連マージリクエストID |

### 10. p_ci_builds

CI/CDパイプライン内のジョブ（ビルド）を管理するパーティションテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint | NOT NULL | 主キー |
| status | character varying | NULL | 状態 |
| finished_at | timestamp | NULL | 終了日時 |
| created_at | timestamp | NULL | 作成日時 |
| updated_at | timestamp | NULL | 更新日時 |
| started_at | timestamp | NULL | 開始日時 |
| coverage | double precision | NULL | カバレッジ |
| commit_id | bigint | NULL | コミットID |
| name | character varying | NULL | ジョブ名 |
| stage | character varying | NULL | ステージ名 |
| type | character varying | NULL | タイプ |
| ref | character varying | NULL | 参照ブランチ/タグ |
| user_id | bigint | NULL | トリガーユーザーID |
| project_id | bigint | NOT NULL | プロジェクトID |
| partition_id | bigint | NOT NULL | パーティションキー |
| pipeline_id | bigint | NOT NULL | パイプラインID |

### 11. notes

イシュー、マージリクエスト、コミットなどへのコメントを管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint | NOT NULL | 主キー |
| note | text | NULL | コメント本文 |
| noteable_type | character varying | NOT NULL | コメント対象タイプ |
| author_id | bigint | NULL | 作成者ユーザーID |
| created_at | timestamp | NULL | 作成日時 |
| updated_at | timestamp | NULL | 更新日時 |
| project_id | bigint | NULL | プロジェクトID |
| noteable_id | bigint | NULL | コメント対象ID |
| system | boolean | NOT NULL | システムノートフラグ |
| discussion_id | character varying | NULL | ディスカッションID |
| confidential | boolean | NULL | 機密フラグ |
| namespace_id | bigint | NULL | ネームスペースID |
| organization_id | bigint | NULL | 組織ID |

### 12. events

ユーザーのアクティビティ（プッシュ、イシュー作成など）を記録するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint | NOT NULL | 主キー |
| project_id | bigint | NULL | プロジェクトID |
| author_id | bigint | NOT NULL | 実行者ユーザーID |
| created_at | timestamp with time zone | NOT NULL | 作成日時 |
| updated_at | timestamp with time zone | NOT NULL | 更新日時 |
| action | smallint | NOT NULL | アクションタイプ |
| target_type | character varying | NULL | 対象タイプ |
| target_id | bigint | NULL | 対象ID |
| group_id | bigint | NULL | グループID |

### 13. deployments

環境へのデプロイ情報を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint | NOT NULL | 主キー |
| iid | integer | NOT NULL | プロジェクト内連番 |
| project_id | bigint | NOT NULL | プロジェクトID |
| environment_id | bigint | NOT NULL | 環境ID |
| ref | character varying | NOT NULL | 参照ブランチ/タグ |
| tag | boolean | NOT NULL | タグデプロイフラグ |
| sha | character varying | NOT NULL | コミットSHA |
| user_id | bigint | NULL | デプロイ実行者ID |
| status | smallint | NOT NULL | 状態 |
| finished_at | timestamp with time zone | NULL | 終了日時 |
| deployable_id | bigint | NULL | デプロイ実行ジョブID |

### 14. releases

プロジェクトのリリース情報を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | bigint | NOT NULL | 主キー |
| tag | character varying | NULL | タグ名 |
| description | text | NULL | 説明文 |
| project_id | bigint | NOT NULL | プロジェクトID |
| created_at | timestamp | NOT NULL | 作成日時 |
| updated_at | timestamp | NOT NULL | 更新日時 |
| author_id | bigint | NULL | 作成者ユーザーID |
| name | character varying | NULL | リリース名 |
| sha | character varying | NULL | コミットSHA |
| released_at | timestamp with time zone | NOT NULL | リリース日時 |

## 備考

### パーティション化について

GitLabでは大量データを効率的に管理するため、以下のようなパーティション戦略を採用しています：

1. **動的パーティション** (`gitlab_partitions_dynamic`スキーマ): 時間ベースでのパーティショニング
2. **静的パーティション** (`gitlab_partitions_static`スキーマ): ハッシュベースでのパーティショニング
3. **リストパーティション**: CI関連テーブルで`partition_id`をキーとしたリストパーティショニング

### 外部キー制約

GitLabでは`loose_foreign_keys`という仕組みを採用しており、一部の外部キーは厳密な制約ではなく、非同期で整合性を保つアプローチを取っています。これにより、大量データの削除時のパフォーマンスを改善しています。

### 組織（Organization）対応

最近のGitLabでは`organization_id`カラムが多くのテーブルに追加されており、マルチテナント対応が進んでいます。主要テーブルには`organization_id IS NOT NULL`制約が設定されています。

### テーブル総数

本プロジェクトは約987テーブルを持つ大規模なデータベースです。本書では主要なコアテーブルのみを記載しています。
