---
generated_at: 2026-01-22 09:45:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **カバレッジ目標値**：具体的な数値目標がコードから特定できず
  2. **性能テスト詳細**：ベンチマークジョブの詳細設定が未確認
  3. **セキュリティテスト詳細**：DASTの詳細設定が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `spec/spec_helper.rb` - RSpec設定、テストヘルパー、フレームワーク構成
- E-02: `jest.config.js` - Jest設定、テストパス設定
- E-03: `jest.config.base.js` - Jest基本設定、カバレッジ設定、トランスフォーマー設定
- E-04: `.gitlab-ci.yml` - CI/CDパイプライン定義、ステージ構成、変数定義
- E-05: `.gitlab/ci/rails.gitlab-ci.yml` - RSpecジョブ定義、並列化設定
- E-06: `.gitlab/ci/frontend.gitlab-ci.yml` - フロントエンドテストジョブ定義
- E-07: `.gitlab/ci/qa.gitlab-ci.yml` - E2Eテストジョブ定義
- E-08: `spec/support/capybara.rb` - Capybara設定、ブラウザテスト設定
- E-09: `spec/simplecov_env.rb` - SimpleCovカバレッジ設定
- E-10: `spec/simplecov_env_core.rb` - カバレッジグループ定義、フォーマッター設定
- E-11: `spec/factories/` ディレクトリ - FactoryBot定義
- E-12: `spec/fixtures/` ディレクトリ - テストフィクスチャ
- E-13: `tooling/bin/parallel_rspec` - 並列RSpec実行スクリプト
- E-14: `gems/gitlab-rspec_flaky/` - フレーキーテスト検出gem

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RSpecをバックエンドテストフレームワークとして使用 | E-01 | ○ |
| C-02 | Jestをフロントエンドテストフレームワークとして使用 | E-02, E-03 | ○ |
| C-03 | テストレベルは単体、結合、システム、受入の4層構成 | E-01, E-05 | ○ |
| C-04 | CI/CDパイプラインは18ステージで構成 | E-04 | ○ |
| C-05 | PostgreSQL 16をテストデータベースとして使用 | E-04, E-05 | ○ |
| C-06 | CapybaraとSeleniumでブラウザテストを実行 | E-01, E-08 | ○ |
| C-07 | Chrome Headlessモードでブラウザテストを実行 | E-08 | ○ |
| C-08 | SimpleCovでコードカバレッジを計測 | E-09, E-10 | ○ |
| C-09 | SimpleCovで分岐カバレッジが有効化されている | E-10 | ○ |
| C-10 | FactoryBotでテストデータを生成 | E-01 | ○ |
| C-11 | TestProfのlet_it_beを使用 | E-01 | ○ |
| C-12 | Knapsackでテスト並列化を実施 | E-01, E-04 | ○ |
| C-13 | Crystalballで予測テストマッピングを実施 | E-01, E-04 | ○ |
| C-14 | rspec-retryでフレーキーテスト対策 | E-01 | ○ |
| C-15 | CI環境でテストリトライ回数は最大2回 | E-01 | ○ |
| C-16 | quarantineメタデータでフレーキーテストを隔離 | E-01 | ○ |
| C-17 | Vue 2/3両対応のフロントエンドテスト | E-03 | ○ |
| C-18 | VUE_VERSION環境変数でVueバージョン切替 | E-03 | ○ |
| C-19 | jest-junitでJUnitレポート出力 | E-03 | ○ |
| C-20 | テスト環境のタイムゾーンはGMT | E-03 | ○ |
| C-21 | CIでのJestタイムアウトは10秒 | E-03 | ○ |
| C-22 | ローカルでのJestタイムアウトは5秒 | E-03 | ○ |
| C-23 | トランザクションテストを使用 | E-01 | ○ |
| C-24 | マイグレーションテストでは削除戦略を使用 | E-01 | ○ |
| C-25 | E2EテストはOmnibus GitLab上で実行 | E-07 | ○ |
| C-26 | E2EテストはGDK上でも実行可能 | E-07 | ○ |
| C-27 | テスト失敗時にIssue自動作成 | E-04 | ○ |
| C-28 | フレーキーテスト検出時にIssue作成 | E-04, E-14 | ○ |
| C-29 | テスト結果をClickHouseにエクスポート | E-04 | ○ |
| C-30 | ジョブタイムアウトは90分 | E-04 | ○ |
| C-31 | フィーチャーフラグはデフォルトでスタブ | E-01 | ○ |
| C-32 | axe-rspecでアクセシビリティテスト | E-01 | ○ |
| C-33 | 具体的なカバレッジ目標値の設定 | **根拠なし** | △ |
| C-34 | 性能テストの詳細設定 | **根拠不足** | △ |
| C-35 | DASTセキュリティテストの詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **カバレッジ目標値（C-33）**: プロジェクト設定やドキュメントで具体的な数値目標が定義されていない可能性。SimpleCovは有効だが、目標値は組織のポリシーに依存
  - 候補：プロジェクト設定ファイル / 内部ドキュメント / チームポリシー
- **性能テスト詳細（C-34）**: benchmarkステージの存在は確認できるが、具体的な設定ファイルの詳細解析が未実施
  - 候補：`.gitlab/ci/benchmark.gitlab-ci.yml` / 性能テストスクリプト
- **セキュリティテスト詳細（C-35）**: DASTの存在は確認できるが（dast_variables.gitlab-ci.yml）、詳細設定の解析が未実施
  - 候補：`.gitlab/ci/dast_variables.gitlab-ci.yml` / セキュリティスキャン設定

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: テストフレームワーク構成、CI/CDパイプライン構成、テストツール一覧
- **0 (低リスク)**: テストレベル定義、テスト環境構成
- **1 (中リスク)**: カバレッジ目標値 - 具体的な数値目標がコードベースから特定できないため、組織のポリシーを確認する必要がある
- **1 (中リスク)**: 性能テスト・セキュリティテストの詳細 - 存在は確認できるが詳細設定の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストフレームワーク（RSpec, Jest）の記載が現状と一致しているか確認
- [ ] CI/CDパイプラインのステージ構成が最新の `.gitlab-ci.yml` と一致しているか確認
- [ ] テストツールのバージョン情報が最新であるか確認（Gemfile, package.jsonと照合）
- [ ] カバレッジ目標値について、組織のポリシーや内部ドキュメントを確認し、必要に応じて記載を追加
- [ ] 性能テスト・セキュリティテストの詳細について、追加調査の必要性を判断
- [ ] E2Eテスト（QA）の実行環境・手順が最新のQAドキュメントと一致しているか確認
- [ ] フレーキーテスト管理の方針が現在のチームプラクティスと一致しているか確認
