---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 109
  claims_with_evidence: 109
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：109 / 109、根拠なし：0
- 優先レビュー（高）
  1. なし：すべてのバッチ情報はソースコードから直接確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/concerns/cronjob_queue.rb` - CronjobQueue concernの定義
- E-02: `app/workers/pipeline_schedule_worker.rb` - PipelineScheduleWorkerの実装
- E-03: `app/workers/expire_build_artifacts_worker.rb` - ExpireBuildArtifactsWorkerの実装
- E-04: `app/workers/stuck_ci_jobs_worker.rb` - StuckCiJobsWorkerの実装
- E-05: `app/workers/repository_check/dispatch_worker.rb` - RepositoryCheck::DispatchWorkerの実装
- E-06: `app/workers/prune_old_events_worker.rb` - PruneOldEventsWorkerの実装
- E-07: `app/workers/personal_access_tokens/expiring_worker.rb` - PersonalAccessTokens::ExpiringWorkerの実装
- E-08: `app/workers/ci/archive_traces_cron_worker.rb` - Ci::ArchiveTracesCronWorkerの実装
- E-09: `app/workers/database/partition_management_worker.rb` - Database::PartitionManagementWorkerの実装
- E-10: `app/workers/users/deactivate_dormant_users_worker.rb` - Users::DeactivateDormantUsersWorkerの実装
- E-11: `app/workers/gitlab_service_ping_worker.rb` - GitlabServicePingWorkerの実装
- E-12: `app/workers/container_expiration_policy_worker.rb` - ContainerExpirationPolicyWorkerの実装
- E-13: `app/workers/remove_expired_members_worker.rb` - RemoveExpiredMembersWorkerの実装
- E-14: `app/workers/loose_foreign_keys/cleanup_worker.rb` - LooseForeignKeys::CleanupWorkerの実装
- E-15: `app/workers/trending_projects_worker.rb` - TrendingProjectsWorkerの実装
- E-16: `app/workers/bulk_imports/stale_import_worker.rb` - BulkImports::StaleImportWorkerの実装
- E-17: `app/workers/pages_domain_verification_cron_worker.rb` - PagesDomainVerificationCronWorkerの実装
- E-18: `app/workers/import_export_project_cleanup_worker.rb` - ImportExportProjectCleanupWorkerの実装
- E-19: `app/workers/environments/auto_stop_cron_worker.rb` - Environments::AutoStopCronWorkerの実装
- E-20: grep結果 - `include CronjobQueue`を含む109ファイルの一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PipelineScheduleWorkerはスケジュールされたパイプラインを実行する | E-02 | ○ |
| C-02 | StuckCiJobsWorkerは停滞したCIジョブを処理する | E-04 | ○ |
| C-03 | Ci::ArchiveTracesCronWorkerは古いCIトレースをアーカイブする | E-08 | ○ |
| C-04 | ExpireBuildArtifactsWorkerは期限切れアーティファクトを削除する | E-03 | ○ |
| C-05 | Database::PartitionManagementWorkerはパーティション管理を行う | E-09 | ○ |
| C-06 | PersonalAccessTokens::ExpiringWorkerは期限切れ間近のPATを通知する | E-07 | ○ |
| C-07 | RemoveExpiredMembersWorkerは期限切れメンバーを削除する | E-13 | ○ |
| C-08 | Users::DeactivateDormantUsersWorkerは休眠ユーザーを非アクティブ化する | E-10 | ○ |
| C-09 | ContainerExpirationPolicyWorkerはコンテナイメージの有効期限ポリシーを実行する | E-12 | ○ |
| C-10 | GitlabServicePingWorkerはサービスPingを送信する | E-11 | ○ |
| C-11 | RepositoryCheck::DispatchWorkerはリポジトリチェックをディスパッチする | E-05 | ○ |
| C-12 | PruneOldEventsWorkerは3年以上前の古いイベントを削除する | E-06 | ○ |
| C-13 | TrendingProjectsWorkerはトレンドプロジェクトを更新する | E-15 | ○ |
| C-14 | LooseForeignKeys::CleanupWorkerは疎外部キーのクリーンアップを行う | E-14 | ○ |
| C-15 | BulkImports::StaleImportWorkerは停滞したバルクインポートをクリーンアップする | E-16 | ○ |
| C-16 | PagesDomainVerificationCronWorkerはPagesドメイン検証を行う | E-17 | ○ |
| C-17 | ImportExportProjectCleanupWorkerはインポート/エクスポートのクリーンアップを行う | E-18 | ○ |
| C-18 | Environments::AutoStopCronWorkerは環境の自動停止を行う | E-19 | ○ |
| C-19 | CronjobQueueはqueue_namespace :cronjobを設定する | E-01 | ○ |
| C-20 | 全109件のバッチワーカーがCronjobQueueをincludeしている | E-20 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- スケジュール間隔（cron設定）は `config/initializers/1_settings.rb` または外部設定ファイルで定義される可能性があり、本調査では確認していません
  - 候補：`config/initializers/1_settings.rb` / `config/gitlab.yml` / Sidekiq Cron設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのバッチ情報はソースコードから直接抽出

## 6) レビュアーチェックリスト（最小）
- [ ] バッチの実行間隔（cron設定）が正しいか確認する（本ドキュメント外で管理）
- [ ] 説明文がバッチの実際の動作と一致しているか確認する
- [ ] カテゴリ分類が適切か確認する
- [ ] 新しく追加されたCronワーカーが漏れていないか確認する
