# バッチ設計書 1-PipelineScheduleWorker

## 概要

本ドキュメントは、スケジュールされたパイプラインを実行するジョブをキューに追加するバッチ処理「PipelineScheduleWorker」の設計仕様を記載する。

### 本バッチの処理概要

PipelineScheduleWorkerは、GitLabのCI/CDパイプラインスケジュール機能の中核を担うバッチ処理である。ユーザーが設定した定期実行スケジュールに従い、パイプラインを自動的に起動するためのジョブをSidekiqキューに投入する。

**業務上の目的・背景**：CI/CDの自動化において、ナイトリービルドや定期的なテスト実行、定時デプロイなど、時間ベースでパイプラインを実行するニーズは非常に高い。本バッチは、ユーザーが設定したスケジュール（cron形式）に基づき、実行可能な状態にあるパイプラインスケジュールを検出し、実際のパイプライン実行ワーカーへ処理を委譲する。これにより、手動介入なしに継続的なビルド・テスト・デプロイのサイクルを維持できる。

**バッチの実行タイミング**：10分間隔で実行（cron: `3-59/10 * * * *`）。毎時3分から10分おきに実行され、実行可能なスケジュールを検出してキューイングする。

**主要な処理内容**：
1. 排他ロック（ExclusiveLease）を取得し、同時実行を防止
2. `Ci::PipelineSchedule.runnable_schedules`で実行可能なスケジュールを取得
3. バッチサイズ500件ずつスケジュールを処理
4. 各スケジュールに対して`RunPipelineScheduleWorker`をバルクエンキュー
5. 負荷分散のため、バッチごとに7秒のディレイを設定

**前後の処理との関連**：本ワーカーは`RunPipelineScheduleWorker`にパイプライン実行を委譲する。`RunPipelineScheduleWorker`が実際のパイプライン作成処理を行い、その後は通常のCI/CDパイプライン処理フローに移行する。

**影響範囲**：全プロジェクトのパイプラインスケジュール設定に影響。スケジュールされたパイプラインの実行タイミングに直接関与するため、CI/CDワークフロー全体に影響を与える。

## バッチ種別

スケジュール処理 / ジョブキューイング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 10分間隔 |
| 実行時刻 | 毎時3分、13分、23分、33分、43分、53分 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron (`3-59/10 * * * *`) |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 排他ロック取得 | `pipeline_schedule_worker`のExclusiveLeaseを取得できること |
| 実行可能スケジュール存在 | `runnable_schedules`スコープに該当するレコードが存在すること |

### 実行可否判定

排他ロック（ExclusiveLease）を取得できた場合のみ処理を実行する。TTLは5分、リトライは3回まで。ロック取得に失敗した場合は処理をスキップする。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | cronジョブとして引数なしで実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ci_pipeline_schedules | DB | パイプラインスケジュール設定テーブル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Sidekiqキュー | ジョブ | RunPipelineScheduleWorkerへのバルクエンキュー |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. 排他ロック取得
   └─ ExclusiveLeaseHelpers.in_lockでロック取得（TTL: 5分、リトライ: 3回）
2. 実行可能スケジュール取得
   └─ Ci::PipelineSchedule.runnable_schedules.preloadedで対象レコード取得
3. バッチ処理ループ
   └─ find_in_batches(batch_size: 500)で500件ずつ処理
4. ワーカーエンキュー
   └─ RunPipelineScheduleWorker.bulk_perform_in_with_contextsでバルクエンキュー
5. 負荷分散ディレイ
   └─ バッチインデックス×7秒のディレイを設定
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{排他ロック取得}
    B -->|成功| C[実行可能スケジュール取得]
    B -->|失敗| G[バッチ終了]
    C --> D{スケジュール存在?}
    D -->|あり| E[バッチごとにRunPipelineScheduleWorkerをエンキュー]
    D -->|なし| G
    E --> F{次のバッチあり?}
    F -->|あり| E
    F -->|なし| G
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| スケジュール取得 | ci_pipeline_schedules | SELECT | 実行可能なスケジュールを取得 |

### テーブル別操作詳細

#### ci_pipeline_schedules

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, owner_id, project_id | runnable_schedulesスコープ条件 | 最小限のカラムのみ選択 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ExclusiveLease取得失敗 | 別プロセスがロック保持中 | リトライ後スキップ |
| - | DB接続エラー | データベース接続失敗 | Sidekiqによるリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 3回（ExclusiveLease取得） |
| リトライ間隔 | Sidekiqデフォルト |
| リトライ対象エラー | 全般的なエラー |

### 障害時対応

1. ロック取得失敗の場合：次回実行時に自動復旧
2. DB接続エラーの場合：Sidekiqが自動リトライ
3. 大量スケジュール処理遅延の場合：バッチサイズ調整を検討

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（SELECTのみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千〜数万スケジュール |
| 目標処理時間 | 5分以内（ロックTTL） |
| メモリ使用量上限 | バッチサイズ500件による制御 |

## 排他制御

- ExclusiveLease（TTL: 5分）による排他制御
- 同時に1プロセスのみ実行可能
- ロックキー: `pipeline_schedule_worker`

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| 進捗ログ | 処理中 | バッチ処理進捗 |
| 終了ログ | バッチ終了時 | Sidekiq標準ログ |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 5分超過 | 運用チーム |
| エラー件数 | 連続3回失敗 | 運用チーム |

## 備考

- `data_consistency :always`が設定されており、プライマリDBを使用
- `worker_resource_boundary :cpu`が設定されており、CPU負荷の高いワーカーとして分類
- スケジュール実行の実際の処理は`RunPipelineScheduleWorker`に委譲される
