# バッチ設計書 100-ObjectStorage::DeleteStaleDirectUploadsWorker

## 概要

本ドキュメントは、古くなった直接アップロードのペンディングエントリを削除するバッチ処理「ObjectStorage::DeleteStaleDirectUploadsWorker」の設計仕様を記載します。

### 本バッチの処理概要

**業務上の目的・背景**：GitLabでは、ジョブアーティファクトなどのファイルをオブジェクトストレージに直接アップロードする機能があります。このプロセスでは、アップロード開始時にペンディングエントリが作成され、アップロード完了時に解消されます。しかし、ネットワーク障害やクライアントの中断などにより、アップロードが完了せずにペンディングエントリが残る場合があります。このバッチは、古くなった（stale）ペンディングエントリを定期的に削除し、オブジェクトストレージとデータベースの整合性を維持します。

**バッチの実行タイミング**：6分ごとに実行されます（cron: `*/6 * * * *`）。頻繁な実行により、不要なペンディングエントリを迅速にクリーンアップします。

**主要な処理内容**：
1. `DeleteStaleDirectUploadsService`を呼び出して削除処理を開始
2. 全ての`PendingDirectUpload`エントリをイテレート
3. 各エントリが`stale?`（古い）かどうかを判定
4. staleなエントリを削除
5. 最大実行時間（250秒）を超えた場合はタイムアウトして終了

**前後の処理との関連**：このバッチは独立して動作します。直接アップロードはCI/CDジョブのアーティファクトアップロード時に使用され、正常に完了した場合はペンディングエントリが自動的に解消されます。このバッチは失敗した/中断されたアップロードの後始末を行います。

**影響範囲**：`object_storage_pending_direct_uploads`のペンディングエントリとオブジェクトストレージ上の対応ファイルが削除されます。完了していないアップロードのみが対象であり、正常なファイルには影響しません。

## バッチ種別

データクレンジング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 6分ごと |
| 実行時刻 | */6 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| オブジェクトストレージが有効 | `job_artifacts` feature categoryが有効であること |

### 実行可否判定

- `idempotent!`により冪等性が保証される
- `deduplicate :until_executed`により重複実行を防止
- ペンディングエントリが存在しない場合も正常終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| PendingDirectUpload | Redis/DB | 直接アップロードのペンディングエントリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| PendingDirectUpload | Redis/DB | staleなペンディングエントリを削除 |
| オブジェクトストレージ | ファイル | 対応する未完了ファイルを削除 |

### 出力ファイル仕様

ファイル出力なし（ログのみ）

## 処理フロー

### 処理シーケンス

```
1. ワーカー実行開始
   └─ DeleteStaleDirectUploadsService.new.execute を呼び出し
2. 初期化
   └─ 開始時刻を記録
   └─ ペンディングエントリの総数を取得
3. ペンディングエントリのイテレーション
   └─ 各エントリについてstale?を判定
   └─ staleならエントリを削除
   └─ 削除件数をカウント
4. タイムアウト判定
   └─ 経過時間がMAX_EXEC_DURATION（250秒）を超えたらループを中断
5. 結果を返却
   └─ total_pending_entries: ペンディングエントリ総数
   └─ total_deleted_stale_entries: 削除件数
   └─ execution_timeout: タイムアウトしたかどうか
6. ログ出力
   └─ 上記3項目をメタデータとして出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[DeleteStaleDirectUploadsService実行]
    B --> C[開始時刻記録]
    C --> D[ペンディングエントリ総数取得]
    D --> E[エントリをイテレート]
    E --> F{エントリあり?}
    F -->|あり| G{stale?}
    G -->|Yes| H[エントリ削除]
    H --> I[削除件数カウント]
    G -->|No| J{タイムアウト?}
    I --> J
    J -->|No| E
    J -->|Yes| K[タイムアウトフラグ設定]
    F -->|なし| L[結果集計]
    K --> L
    L --> M[ログ出力]
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| エントリカウント | PendingDirectUpload | SELECT | 総数を取得 |
| エントリ取得 | PendingDirectUpload | SELECT | 全エントリをイテレート |
| エントリ削除 | PendingDirectUpload | DELETE | staleなエントリを削除 |

### テーブル別操作詳細

#### PendingDirectUpload

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | count | 全エントリ | 総数取得 |
| SELECT | 全カラム | 全エントリ | eachでイテレート |
| DELETE | (全カラム) | stale?がtrueのエントリ | deleteメソッド呼び出し |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | オブジェクトストレージ接続エラー | ストレージ接続失敗 | Sidekiqによる自動リトライ |
| - | タイムアウト | 250秒超過 | 次回実行で継続処理 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

### 障害時対応

- `idempotent!`により再実行しても整合性が保たれる
- タイムアウト時は`execution_timeout: true`がログに記録
- 障害発生時は次回定期実行で自動復旧
- 手動実行する場合は`ObjectStorage::DeleteStaleDirectUploadsWorker.new.perform`を実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | エントリ単位 |
| コミットタイミング | 各delete完了時 |
| ロールバック条件 | 削除処理中のエラー |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ペンディングエントリ数に依存 |
| 目標処理時間 | 250秒以内（MAX_EXEC_DURATION） |
| メモリ使用量上限 | イテレータ使用で制御 |

## 排他制御

- `idempotent!`により同一処理の複数実行でも整合性を保持
- `deduplicate :until_executed`により重複実行を防止
- 個別エントリの削除は競合しにくい設計

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| メタデータログ | 処理完了時 | total_pending_entries, total_deleted_stale_entries, execution_timeout |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 250秒超過（タイムアウト） | 運用チーム |
| エラー件数 | 連続失敗 | 運用チーム |
| ペンディングエントリ蓄積 | 大量蓄積 | 運用チーム |

## 備考

- このワーカーは`job_artifacts` feature categoryに属する
- `data_consistency :sticky`によりプライマリDBを使用
- CronjobQueueをinclude
- `MAX_EXEC_DURATION`: 250秒（サービスで定義）
- `deduplicate :until_executed`により重複実行を防止
- `PendingDirectUpload`クラスはRedis/DBベースのペンディング管理を提供
- `stale?`メソッドで古いエントリを判定（作成から一定時間経過）
- 現在は主にジョブアーティファクトで使用（TODOコメントあり）
- `success`メソッドでServiceResponseを返却
