# バッチ設計書 101-ScheduleMigrateExternalDiffsWorker

## 概要

本ドキュメントは、マージリクエストの差分データをデータベースから外部ストレージへ移行するスケジューリングを行うバッチ処理「ScheduleMigrateExternalDiffsWorker」の設計内容を記載する。

### 本バッチの処理概要

**業務上の目的・背景**：マージリクエストの差分データ（diff）はデフォルトでデータベースに保存されるが、大量の差分データが蓄積されるとデータベースの容量を圧迫し、パフォーマンスに影響を与える可能性がある。本バッチは差分データを外部ストレージ（オブジェクトストレージ等）に移行することで、データベースの負荷を軽減し、ストレージコストを最適化することを目的としている。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。排他ロックにより2時間のTTLで同時実行を防止している。

**主要な処理内容**：
1. 排他ロック（ExclusiveLease）を取得し、同時実行を防止する
2. MergeRequests::MigrateExternalDiffsService.enqueue! を呼び出す
3. 外部ストレージへの移行対象となるMergeRequestDiffのIDを最大1000件取得
4. 取得したIDごとにMigrateExternalDiffsWorkerジョブを非同期でキューに追加
5. 各MigrateExternalDiffsWorkerが実際の移行処理を実行

**前後の処理との関連**：本バッチは親ワーカーとして機能し、実際の移行処理はMigrateExternalDiffsWorkerが担当する。外部差分の設定（external_diffs.enabled、external_diffs.when）に依存する。

**影響範囲**：merge_request_diffsテーブル、外部ストレージ（オブジェクトストレージ）、関連するマージリクエストの差分表示機能に影響する。

## バッチ種別

データ連携 / ストレージ最適化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cronjob） |
| 実行時刻 | システム設定による |
| 実行曜日 | 毎日 |
| 実行日 | 該当なし |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 外部差分の有効化 | Gitlab.config.external_diffs.enabled が true であること |
| 移行戦略の設定 | external_diffs.when が 'always' または 'outdated' であること |

### 実行可否判定

- 排他ロック（schedule_migrate_external_diffs_worker）が取得できない場合はスキップ
- 外部差分が無効化されている場合は移行対象IDが空となり処理終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本ワーカーはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| merge_request_diffs | DB | 移行対象の差分データを取得 |
| Gitlab.config.external_diffs | 設定 | 外部差分の有効化・戦略設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Sidekiqキュー | ジョブ | MigrateExternalDiffsWorkerジョブを最大1000件キューイング |

### 出力ファイル仕様

該当なし（本バッチはジョブのスケジューリングのみを行う）

## 処理フロー

### 処理シーケンス

```
1. 排他ロック取得
   └─ self.class.name.underscore をキーに2時間のTTLでロック取得
2. サービス呼び出し
   └─ MergeRequests::MigrateExternalDiffsService.enqueue! を実行
3. 移行対象ID取得
   └─ MergeRequestDiff.ids_for_external_storage_migration で最大1000件取得
4. ジョブキューイング
   └─ MigrateExternalDiffsWorker.bulk_perform_async でバルクキューイング
5. ロック解放
   └─ 処理完了後、自動的にロック解放
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{排他ロック取得}
    B -->|取得成功| C[MigrateExternalDiffsService.enqueue!呼び出し]
    B -->|取得失敗| H[処理スキップ]
    C --> D{外部差分有効?}
    D -->|無効| G[処理終了]
    D -->|有効| E[移行対象ID取得（最大1000件）]
    E --> F[MigrateExternalDiffsWorkerをバルクキューイング]
    F --> G
    H --> G
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 移行対象取得 | merge_request_diffs | SELECT | 外部ストレージ移行対象の差分IDを取得 |

### テーブル別操作詳細

#### merge_request_diffs

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | stored_externally = false の条件で取得 | 戦略により条件が変化 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | FailedToObtainLockError | 排他ロック取得失敗 | 例外をrescueして処理をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（Cronjobとして次回実行を待つ） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

排他ロック取得に失敗した場合は次回のCron実行まで待機。子ワーカー（MigrateExternalDiffsWorker）でエラーが発生した場合は、Sidekiqの標準リトライ機構（3回）により自動リトライされる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ジョブスケジューリングのみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 最大1000件/実行 |
| 目標処理時間 | 数秒以内（スケジューリングのみ） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

- ExclusiveLeaseを使用した排他制御
- キー: `schedule_migrate_external_diffs_worker`
- TTL: 2時間
- リトライ: 0回（即座にスキップ）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| 終了ログ | バッチ終了時 | Sidekiq標準ログ |
| エラーログ | ロック取得失敗時 | 例外情報（FailedToObtainLockError） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行状況 | Sidekiq標準監視 | 運用チーム |
| キューサイズ | 設定による | 運用チーム |

## 備考

- feature_category: code_review_workflow
- data_consistency: always
- Scalability/IdempotentWorker: 非冪等（rubocop disable）
- 移行戦略は `always`（常に外部ストレージへ移行）と `outdated`（古いMRのみ移行）の2種類
- outdated戦略では、7日以上前にマージ/クローズされたMR、または最新でない差分が対象
