# バッチ設計書 102-Releases::ManageEvidenceWorker

## 概要

本ドキュメントは、リリースのエビデンス（証跡）情報を自動的に生成・管理するバッチ処理「Releases::ManageEvidenceWorker」の設計内容を記載する。

### 本バッチの処理概要

**業務上の目的・背景**：GitLabのリリース機能において、リリース時点のプロジェクト状態（コミット情報、マイルストーン、パイプライン結果など）を証跡として記録する必要がある。本バッチは、リリース作成後2時間以内のリリースに対してエビデンスを自動生成することで、監査やコンプライアンス要件を満たすとともに、リリースの信頼性を担保することを目的としている。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。リリース時刻から前後1時間以内のリリースを対象とする。

**主要な処理内容**：
1. エビデンス未作成かつリリース時刻が現在時刻の前後1時間以内のリリースを検索
2. 各リリースに対してプロジェクトの存在確認を行う
3. リリースに関連するパイプライン情報を取得（EvidencePipelineFinder）
4. Releases::CreateEvidenceWorkerを非同期で実行し、エビデンスを生成

**前後の処理との関連**：本バッチは親ワーカーとして機能し、実際のエビデンス生成はReleases::CreateEvidenceWorkerが担当する。Releases::CreateEvidenceServiceがエビデンスデータの作成を実行する。

**影響範囲**：releasesテーブル、releases_evidencesテーブル、CI/CDパイプライン情報、リリース詳細画面のエビデンス表示機能に影響する。

## バッチ種別

データ生成 / 監査証跡管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cronjob） |
| 実行時刻 | システム設定による |
| 実行曜日 | 毎日 |
| 実行日 | 該当なし |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| リリースの存在 | エビデンス未作成のリリースが存在すること |
| リリース時刻 | released_at が現在時刻の前後1時間以内であること |

### 実行可否判定

- エビデンス未作成（without_evidence）かつリリース時刻が範囲内（released_within_2hrs）のリリースが対象
- プロジェクトが削除されている場合は該当リリースをスキップ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本ワーカーはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| releases | DB | エビデンス未作成のリリース情報 |
| releases_evidences | DB | エビデンスの有無を確認（LEFT JOIN） |
| ci_pipelines | DB | リリースタグに関連するパイプライン情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Sidekiqキュー | ジョブ | Releases::CreateEvidenceWorkerジョブをキューイング |

### 出力ファイル仕様

該当なし（本バッチはジョブのスケジューリングのみを行う）

## 処理フロー

### 処理シーケンス

```
1. 対象リリース検索
   └─ Release.without_evidence.released_within_2hrs でエビデンス未作成リリースを取得
2. 各リリースの処理
   └─ process_release メソッドで個別処理
3. プロジェクト存在確認
   └─ release.project が nil の場合はスキップ
4. パイプライン検索
   └─ EvidencePipelineFinder でリリースタグに関連するパイプラインを検索
5. エビデンス生成ジョブキューイング
   └─ CreateEvidenceWorker.perform_async(release.id, pipeline_id)
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[エビデンス未作成リリース取得]
    B --> C{リリースあり?}
    C -->|なし| H[バッチ終了]
    C -->|あり| D[各リリースを処理]
    D --> E{プロジェクト存在?}
    E -->|なし| F[スキップ]
    E -->|あり| G[パイプライン検索]
    G --> I[CreateEvidenceWorkerキューイング]
    I --> J{次のリリース?}
    F --> J
    J -->|あり| D
    J -->|なし| H
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リリース取得 | releases | SELECT | エビデンス未作成のリリースを取得 |
| エビデンス確認 | releases_evidences | SELECT（LEFT JOIN） | エビデンスの有無を確認 |
| パイプライン検索 | ci_pipelines | SELECT | リリースタグに関連するパイプラインを検索 |

### テーブル別操作詳細

#### releases

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, project_id, tag, released_at | released_at BETWEEN (now - 1h) AND (now + 1h) | エビデンス未作成が条件 |

#### releases_evidences

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT（LEFT JOIN） | id | id IS NULL でエビデンス未作成を判定 | |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ActiveRecord::StatementTimeout | SQLタイムアウト | エラートラッキングして次のリリースへ続行 |
| - | ActiveRecord::ConnectionTimeoutError | DB接続タイムアウト | エラートラッキングして次のリリースへ続行 |
| - | ActiveRecord::AdapterTimeout | アダプタタイムアウト | エラートラッキングして次のリリースへ続行 |
| - | ActiveRecord::LockWaitTimeout | ロック待ちタイムアウト | エラートラッキングして次のリリースへ続行 |
| - | ActiveRecord::QueryCanceled | クエリキャンセル | エラートラッキングして次のリリースへ続行 |
| - | StandardError | その他の標準エラー | エラートラッキングして次のリリースへ続行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（Cronjobとして次回実行を待つ） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

個別のリリース処理でエラーが発生した場合はGitlab::ErrorTrackingで記録し、次のリリースの処理を続行する。子ワーカー（CreateEvidenceWorker）でエラーが発生した場合は、Sidekiqの標準リトライ機構（3回）により自動リトライされる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ジョブスケジューリングのみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | リリース時刻付近の未処理リリース数に依存 |
| 目標処理時間 | 数秒〜数十秒（対象リリース数に依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

特に排他制御は実装されていない。同一リリースに対して複数のエビデンスが生成される可能性があるが、CreateEvidenceWorkerでの重複チェックで対処される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| 終了ログ | バッチ終了時 | Sidekiq標準ログ |
| エラーログ | エラー発生時 | release_id, project_id, 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| エラー発生件数 | Sentry/ErrorTracking | 運用チーム |
| 実行状況 | Sidekiq標準監視 | 運用チーム |

## 備考

- feature_category: release_evidence
- data_consistency: sticky
- Scalability/IdempotentWorker: 非冪等（rubocop disable）
- 対象時間範囲は「現在時刻の前後1時間」（released_within_2hrs スコープ）
- パイプラインが存在しない場合もエビデンスは生成される（pipeline_id = nil）
