# バッチ設計書 104-IssueDueSchedulerWorker

## 概要

本ドキュメントは、翌日が期限のIssueに対する通知メール送信をスケジュールするバッチ処理「IssueDueSchedulerWorker」の設計内容を記載する。

### 本バッチの処理概要

**業務上の目的・背景**：GitLabのIssue管理機能において、期限（due date）が設定されたIssueの担当者やウォッチャーに対して、期限前のリマインダー通知を送信することは重要な機能である。本バッチは、翌日が期限のIssueを検出し、関係者にメール通知を送信することで、タスクの期限管理を支援し、期限切れの防止を目的としている。

**バッチの実行タイミング**：Cronジョブとして毎日実行される。翌日（tomorrow）が期限のIssueを対象とする。

**主要な処理内容**：
1. 翌日が期限（due_tomorrow）かつオープン状態のIssueを検索
2. issue_typeが「issue」のものに限定
3. 対象Issueをプロジェクト単位でグループ化
4. 各プロジェクトIDに対してMailScheduler::IssueDueWorkerを非同期実行

**前後の処理との関連**：本バッチは親ワーカーとして機能し、実際のメール送信はMailScheduler::IssueDueWorkerが担当する。IssueDueWorkerはNotificationServiceを呼び出して、期限通知メールを送信する。

**影響範囲**：issuesテーブル（参照のみ）、メール送信機能、通知サービスに影響する。

## バッチ種別

通知スケジューリング / メール配信

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | システム設定による（通常は業務開始前） |
| 実行曜日 | 毎日 |
| 実行日 | 該当なし |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Issueの存在 | 翌日が期限のオープンIssueが存在すること |
| Issueタイプ | issue_type が :issue であること |

### 実行可否判定

- 翌日が期限（due_tomorrow）のIssueが存在しない場合は、ジョブをキューイングせずに終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本ワーカーはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| issues | DB | 翌日が期限のオープンIssue情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Sidekiqキュー | ジョブ | MailScheduler::IssueDueWorkerジョブをプロジェクト単位でキューイング |

### 出力ファイル仕様

該当なし（本バッチはジョブのスケジューリングのみを行う）

## 処理フロー

### 処理シーケンス

```
1. 対象Issue検索
   └─ Issue.with_issue_type(:issue).opened.due_tomorrow で検索
2. プロジェクトIDでグループ化
   └─ group(:project_id).pluck(:project_id) でユニークなプロジェクトIDを取得
3. パラメータ形式変換
   └─ map { |id| [id] } で配列形式に変換
4. バルクキューイング
   └─ MailScheduler::IssueDueWorker.bulk_perform_async でジョブを一括キューイング
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[翌日期限のIssue検索]
    B --> C[プロジェクトIDでグループ化]
    C --> D{プロジェクトあり?}
    D -->|なし| G[バッチ終了]
    D -->|あり| E[プロジェクトIDを配列形式に変換]
    E --> F[IssueDueWorkerをバルクキューイング]
    F --> G
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Issue検索 | issues | SELECT | 翌日期限のオープンIssueを検索 |

### テーブル別操作詳細

#### issues

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | project_id | issue_type = 'issue' AND state_id = opened AND due_date = tomorrow | GROUP BY project_id |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ActiveRecord::QueryError | クエリ実行エラー | Sidekiq標準リトライで対処 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiq標準（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | すべての例外 |

### 障害時対応

本バッチはスケジューリングのみを行うため、エラー発生時はSidekiqの標準リトライ機構に依存する。子ワーカー（IssueDueWorker）でエラーが発生した場合も、Sidekiqの標準リトライ機構（3回）により自動リトライされる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（参照のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 翌日期限のIssueが存在するプロジェクト数に依存 |
| 目標処理時間 | 数秒以内（スケジューリングのみ） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

特に排他制御は実装されていない。日次実行のCronジョブのため、同時実行の可能性は低い。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| 終了ログ | バッチ終了時 | Sidekiq標準ログ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行状況 | Sidekiq標準監視 | 運用チーム |
| メール送信エラー | エラー発生時 | 運用チーム |

## 備考

- feature_category: team_planning
- data_consistency: always
- Scalability/IdempotentWorker: 非冪等（rubocop disable）
- Scalability/BulkPerformWithContext: コンテキストなし（rubocop disable）
- 子ワーカー（MailScheduler::IssueDueWorker）はretry: 3で設定
- 通知はNotificationServiceを経由して送信される
- due_tomorrowスコープの実装はIssueモデルに依存
