# バッチ設計書 106-ConcurrencyLimit::ResumeWorker

## 概要

本ドキュメントは、同時実行制限により遅延されたジョブを再開するバッチ処理「ConcurrencyLimit::ResumeWorker」の設計内容を記載する。

### 本バッチの処理概要

**業務上の目的・背景**：GitLabでは、システムリソースの保護やサービス品質の維持のために、特定のワーカーに対して同時実行数の制限（Concurrency Limit）を設けている。制限に達した場合、新しいジョブは一時的にキューに保留される。本バッチは、保留されたジョブを監視し、同時実行数が制限内に収まった際に自動的にジョブを再開することで、システムのスループットを最大化しつつ安定性を維持することを目的としている。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。また、処理すべきジョブが残っている場合は1秒後に自己再スケジュールする。

**主要な処理内容**：
1. worker_name引数がない場合：全ワーカーをスキャンし、キューにジョブがあるワーカーを特定
2. 各ワーカーに対して、そのワーカーのキューにResumeWorkerをスケジュール
3. worker_name引数がある場合：指定ワーカーの同時実行制限と現在の実行数を確認
4. 制限内であればジョブを再開（resume_processing!）
5. 古いトラッカーをクリーンアップ（cleanup_stale_trackers）
6. キューにまだジョブがあれば1秒後に再スケジュール

**前後の処理との関連**：Sidekiqミドルウェア（ConcurrencyLimitMiddleware）がジョブ実行前に同時実行数をチェックし、制限超過時にジョブを保留キューに移動する。本バッチはその保留キューを監視し、ジョブを再開する。

**影響範囲**：Sidekiqの各ワーカーキュー、Redis（同時実行カウンター、保留キュー）、ConcurrencyLimitServiceに影響する。

## バッチ種別

ジョブスケジューリング / キュー管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cronjob）+ 動的再スケジュール |
| 実行時刻 | システム設定による |
| 実行曜日 | 毎日 |
| 実行日 | 該当なし |
| トリガー | cron + 自己再スケジュール（1秒後） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 保留ジョブの存在 | 同時実行制限により保留されたジョブがキューに存在すること |
| 制限内の同時実行数 | 現在の同時実行数が制限値未満であること |

### 実行可否判定

- キューサイズが0の場合はスキップ
- 同時実行制限が-1（サーキットブレーカー発動）の場合はスキップ
- 制限値が0でない場合、再開可能数（limit - current）が0以下ならスキップ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| worker_name | String | No | nil | 処理対象のワーカークラス名。nilの場合は全ワーカーをスキャン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Redis | KVS | 同時実行カウンター、保留キュー |
| Sidekiq設定 | Config | ワーカー一覧、キュー設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Sidekiqキュー | ジョブ | 再開されたジョブ、自己再スケジュールジョブ |
| メタデータ | ログ | 再開したジョブ数（resumed_jobs） |

### 出力ファイル仕様

該当なし

## 処理フロー

### 処理シーケンス

```
1. パラメータ確認
   └─ worker_name の有無で処理を分岐
2. 【worker_name なし】全ワーカースキャン
   └─ schedule_workers: 全ワーカーをチェック
      └─ 各ワーカーのキューサイズを確認
      └─ キューにジョブがあり、制限が-1でない場合、そのワーカーのキューにResumeWorkerをスケジュール
3. 【worker_name あり】指定ワーカー処理
   └─ process_worker: 指定ワーカーを処理
      └─ 同時実行制限（limit）を取得
      └─ キューサイズを取得
      └─ 現在の同時実行数（current）を取得
      └─ 再開可能数（to_resume = limit - current）を計算
      └─ ログ出力（worker_stats_log）
      └─ resume_processing! でジョブを再開
      └─ cleanup_stale_trackers で古いトラッカーをクリーンアップ
      └─ キューにまだジョブがあれば1秒後に再スケジュール
4. メタデータ出力
   └─ log_extra_metadata_on_done で再開ジョブ数を記録
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{worker_name引数あり?}
    B -->|なし| C[全ワーカースキャン]
    C --> D[キューにジョブがあるワーカーを特定]
    D --> E[各ワーカーのキューにResumeWorkerをスケジュール]
    E --> Z[バッチ終了]
    B -->|あり| F[指定ワーカー処理]
    F --> G{キューサイズ > 0?}
    G -->|No| Z
    G -->|Yes| H{制限 >= 0?}
    H -->|No| Z
    H -->|Yes| I{再開可能?}
    I -->|No| Z
    I -->|Yes| J[ジョブ再開]
    J --> K[古いトラッカークリーンアップ]
    K --> L{キューにまだジョブあり?}
    L -->|Yes| M[1秒後に再スケジュール]
    L -->|No| N[再開ジョブ数をログ出力]
    M --> N
    N --> Z
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| キューサイズ取得 | Redis | READ | 保留キューのサイズを取得 |
| 同時実行数取得 | Redis | READ | 現在の同時実行数を取得 |
| ジョブ再開 | Redis/Sidekiq | WRITE | 保留キューからジョブを取り出し、実行キューに移動 |
| トラッカークリーンアップ | Redis | DELETE | 古い同時実行トラッカーを削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | StandardError | Redis接続エラー | Sidekiq標準リトライで対処 |
| - | NameError | worker_nameが無効 | safe_constantizeでnil返却、処理スキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiq標準（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | すべての例外 |

### 障害時対応

冪等性（idempotent!）が宣言されているため、リトライしても問題ない。ジョブの重複実行は同時実行カウンターで防止される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（Redisベースの処理） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ワーカー数 × キューサイズに依存 |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

- 本ワーカー自体はconcurrency_limit -> { 0 }で同時実行制限から除外
- 対象ワーカーの同時実行はConcurrencyLimitServiceで管理
- SidekiqSharding::Routerでシャード間のルーティングを制御

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| ワーカー統計 | ジョブ再開前 | worker_name, limit, queue_size, current |
| 終了ログ | バッチ終了時 | Sidekiq標準ログ |
| メタデータ | 処理完了時 | resumed_jobs: 再開したジョブ数 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行状況 | Sidekiq標準監視 | 運用チーム |
| 保留キューサイズ | 設定による | 運用チーム |
| 再開ジョブ数 | 異常に少ない場合 | 運用チーム |

## 備考

- feature_category: scalability
- data_consistency: sticky
- idempotent!: 冪等ワーカー
- urgency: low
- loggable_arguments: 0
- concurrency_limit: -> { 0 }（本ワーカー自体は同時実行制限から除外）
- RESCHEDULE_DELAY: 1秒（自己再スケジュール間隔）
- SidekiqSharding::Routerで各ワーカーの所属シャードにルーティング
- サーキットブレーカー（limit < 0）発動時はジョブを再開しない
