# バッチ設計書 107-PauseControl::ResumeWorker

## 概要

本ドキュメントは、一時停止制御により保留されたジョブを再開するバッチ処理「PauseControl::ResumeWorker」の設計内容を記載する。

### 本バッチの処理概要

**業務上の目的・背景**：GitLabでは、Elasticsearchのインデックス作成やグローバル検索などの重い処理に対して、システム状態に応じた一時停止制御（Pause Control）を実装している。システムが過負荷状態やメンテナンス中の場合、特定のワーカーを一時停止し、状態が回復したら自動的に再開する。本バッチは、一時停止が解除された際に保留キューからジョブを再開することで、システムの自動回復を実現することを目的としている。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。また、処理すべきジョブが残っている場合は1秒後に自己再スケジュールする。

**主要な処理内容**：
1. 各一時停止戦略（Pause Strategy）とそれに対応するワーカーを取得
2. 各戦略の一時停止条件をチェック（should_pause?）
3. 一時停止が解除されている場合、キューにジョブがあるワーカーに対してresume_processing!を実行
4. 再開後もキューにジョブが残っている場合は1秒後に自己再スケジュール

**前後の処理との関連**：Sidekiqミドルウェア（PauseControlMiddleware）がジョブ実行前に一時停止状態をチェックし、一時停止中はジョブを保留キューに移動する。本バッチはその保留キューを監視し、一時停止解除時にジョブを再開する。

**影響範囲**：Sidekiqの各ワーカーキュー、Redis（保留キュー）、PauseControlService、Elasticsearch関連機能に影響する。

## バッチ種別

ジョブスケジューリング / キュー管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cronjob）+ 動的再スケジュール |
| 実行時刻 | システム設定による |
| 実行曜日 | 毎日 |
| 実行日 | 該当なし |
| トリガー | cron + 自己再スケジュール（1秒後） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 保留ジョブの存在 | 一時停止制御により保留されたジョブがキューに存在すること |
| 一時停止解除 | 対象ワーカーの一時停止戦略がshould_pause? = falseであること |

### 実行可否判定

- 一時停止戦略がshould_pause? = trueの場合はスキップ
- キューにジョブがない場合はスキップ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本ワーカーはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Redis | KVS | 保留キュー |
| Sidekiq設定 | Config | 一時停止戦略とワーカーのマッピング |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Sidekiqキュー | ジョブ | 再開されたジョブ、自己再スケジュールジョブ |

### 出力ファイル仕様

該当なし

## 処理フロー

### 処理シーケンス

```
1. 戦略・ワーカーマッピング取得
   └─ pause_strategies_workers でマッピングを取得
2. 各戦略の処理
   └─ 戦略クラスを取得（PauseControl.for(strategy)）
   └─ should_pause? で一時停止状態をチェック
3. 一時停止解除時の処理
   └─ 各ワーカーのキューをチェック（jobs_in_the_queue?）
   └─ resume_processing! でジョブを再開
   └─ キューサイズ > 0 なら reschedule_job = true
4. 再スケジュール判定
   └─ reschedule_job が true なら1秒後に自己再スケジュール
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[戦略・ワーカーマッピング取得]
    B --> C[各戦略を処理]
    C --> D{should_pause?}
    D -->|Yes| E[スキップ]
    D -->|No| F[各ワーカーを処理]
    F --> G{キューにジョブあり?}
    G -->|No| H[次のワーカー]
    G -->|Yes| I[resume_processing!]
    I --> J{キューサイズ > 0?}
    J -->|Yes| K[再スケジュールフラグON]
    J -->|No| H
    K --> H
    H --> L{次の戦略?}
    E --> L
    L -->|あり| C
    L -->|なし| M{再スケジュール必要?}
    M -->|Yes| N[1秒後に自己再スケジュール]
    M -->|No| O[バッチ終了]
    N --> O
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| キュー確認 | Redis | READ | 保留キューのジョブ有無を確認 |
| ジョブ再開 | Redis/Sidekiq | WRITE | 保留キューからジョブを取り出し、実行キューに移動 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | StandardError | Redis接続エラー | Sidekiq標準リトライで対処 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiq標準（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | すべての例外 |

### 障害時対応

冪等性（idempotent!）が宣言されているため、リトライしても問題ない。ジョブの重複実行はPauseControlServiceで防止される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（Redisベースの処理） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 戦略数 × ワーカー数 × キューサイズに依存 |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

特に排他制御は実装されていない。冪等性が保証されているため、同時実行されても問題ない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| 終了ログ | バッチ終了時 | Sidekiq標準ログ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行状況 | Sidekiq標準監視 | 運用チーム |
| 保留キューサイズ | 設定による | 運用チーム |

## 備考

- feature_category: global_search
- data_consistency: sticky
- idempotent!: 冪等ワーカー
- urgency: low
- RESCHEDULE_DELAY: 1秒（自己再スケジュール間隔）
- 一時停止戦略はWorkersMapで管理され、各ワーカーと紐付けられる
- should_pause?メソッドで一時停止条件をチェック（例：Elasticsearchの状態確認）
- PauseControlService.has_jobs_in_waiting_queue?でキューの状態を確認
- PauseControlService.resume_processing!でジョブを再開
