# バッチ設計書 108-AdminEmailWorker

## 概要

本ドキュメントは、リポジトリチェックの失敗を管理者に通知するバッチ処理「AdminEmailWorker」の設計内容を記載する。

### 本バッチの処理概要

**業務上の目的・背景**：GitLabでは、リポジトリの整合性を定期的にチェックし、破損や不整合を検出する機能（Repository Check）が提供されている。リポジトリチェックに失敗したプロジェクトが存在する場合、システム管理者に速やかに通知し、適切な対応を促す必要がある。本バッチは、リポジトリチェック失敗のプロジェクト数を集計し、管理者にメールで通知することで、システムの健全性維持を支援することを目的としている。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。リポジトリチェック機能が有効な場合にのみ実行される。

**主要な処理内容**：
1. リポジトリチェック機能の有効/無効を確認
2. リポジトリチェックに失敗したプロジェクトの件数を取得
3. 失敗件数が1件以上の場合、RepositoryCheckMailerで管理者に通知メールを送信

**前後の処理との関連**：本バッチの前段として、RepositoryCheck::DispatchWorkerがリポジトリチェックを実行し、結果をprojectsテーブルに記録する。本バッチはその結果を参照し、管理者への通知を行う。

**影響範囲**：projectsテーブル（参照のみ）、管理者メール送信機能、システム設定に影響する。

## バッチ種別

通知配信 / 監視アラート

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cronjob） |
| 実行時刻 | システム設定による |
| 実行曜日 | 毎日 |
| 実行日 | 該当なし |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| リポジトリチェック有効 | Gitlab::CurrentSettings.repository_checks_enabled が true であること |
| 失敗プロジェクトの存在 | リポジトリチェックに失敗したプロジェクトが1件以上存在すること |

### 実行可否判定

- リポジトリチェックが無効の場合は処理をスキップ
- 失敗プロジェクトが0件の場合はメール送信をスキップ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本ワーカーはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| projects | DB | リポジトリチェック結果（last_repository_check_failed） |
| Gitlab::CurrentSettings | 設定 | リポジトリチェックの有効/無効設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| メール | Email | 管理者へのリポジトリチェック失敗通知メール |

### 出力ファイル仕様

該当なし

## 処理フロー

### 処理シーケンス

```
1. 設定確認
   └─ Gitlab::CurrentSettings.repository_checks_enabled をチェック
2. 【無効の場合】処理終了
3. 【有効の場合】失敗件数取得
   └─ Project.last_repository_check_failed.count で件数を取得
4. 【0件の場合】処理終了
5. 【1件以上の場合】メール送信
   └─ RepositoryCheckMailer.notify(count).deliver_now でメール送信
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{リポジトリチェック有効?}
    B -->|No| G[バッチ終了]
    B -->|Yes| C[失敗プロジェクト件数取得]
    C --> D{失敗件数 > 0?}
    D -->|No| G
    D -->|Yes| E[RepositoryCheckMailerで通知メール送信]
    E --> F[deliver_nowで即座に送信]
    F --> G
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 失敗件数取得 | projects | SELECT (COUNT) | リポジトリチェック失敗プロジェクトの件数を取得 |

### テーブル別操作詳細

#### projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | COUNT(*) | last_repository_check_failed = true | スコープで定義 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Net::SMTPError | メール送信失敗 | Sidekiq標準リトライで対処 |
| - | ActiveRecord::QueryError | DB接続エラー | Sidekiq標準リトライで対処 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiq標準（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | すべての例外 |

### 障害時対応

メール送信に失敗した場合はSidekiqの標準リトライ機構で自動リトライされる。繰り返し失敗する場合はメールサーバーの設定を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（参照とメール送信のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件（件数集計のみ） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

特に排他制御は実装されていない。日次実行のCronジョブのため、同時実行の可能性は低い。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| 終了ログ | バッチ終了時 | Sidekiq標準ログ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行状況 | Sidekiq標準監視 | 運用チーム |
| メール送信エラー | エラー発生時 | 運用チーム |

## 備考

- feature_category: source_code_management
- data_consistency: sticky
- Scalability/IdempotentWorker: 非冪等（rubocop disable）
- Scalability/CronWorkerContext: コンテキストなし（rubocop disable）
- deliver_nowで同期的にメール送信（非同期のdeliver_laterではない）
- last_repository_check_failedスコープはProjectモデルに定義
- RepositoryCheckMailerは管理者全員にメールを送信
