# バッチ設計書 109-Cells::LostTransactionRecoveryWorker

## 概要

本ドキュメントは、Cellsアーキテクチャにおける失われたトランザクションを復旧するバッチ処理「Cells::LostTransactionRecoveryWorker」の設計内容を記載する。

### 本バッチの処理概要

**業務上の目的・背景**：GitLabのCellsアーキテクチャでは、複数のセル間でデータを分散管理し、トランザクションの一貫性を保つためにリース（Lease）機構を使用している。ネットワーク障害やシステム異常により、トランザクションが中途半端な状態で残ってしまう場合がある。本バッチは、そのような「失われた」トランザクションを検出し、適切にコミットまたはロールバックすることで、データの整合性を回復させることを目的としている。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。Cellsリース機能が有効な場合にのみ実行される。

**主要な処理内容**：
1. Cellsリース機能が有効かどうかを確認
2. Cells::Leases::ReconciliationServiceを実行し、リースの整合性チェックと復旧を実行
3. 処理結果（処理件数、コミット件数、ロールバック件数、保留件数、孤立件数）をログに記録

**前後の処理との関連**：本バッチはCellsアーキテクチャのリース管理システムと連携する。ReconciliationServiceがリースの状態を確認し、必要に応じてトランザクションをコミットまたはロールバックする。

**影響範囲**：Cellsリース関連テーブル、分散トランザクションの整合性、Cellsアーキテクチャ全体に影響する。

## バッチ種別

データ復旧 / 整合性維持

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cronjob） |
| 実行時刻 | システム設定による |
| 実行曜日 | 毎日 |
| 実行日 | 該当なし |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Cellsリース有効 | Current.cells_claims_leases? が true であること |
| データベースヘルス | gitlab_main データベースがヘルシーであること |

### 実行可否判定

- Current.cells_claims_leases? が false の場合は処理をスキップ
- データベースヘルスシグナルにより、1分間の遅延が発生する場合がある

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本ワーカーはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| cells_outstanding_leases | DB | 未解決のリース情報 |
| Current.cells_claims_leases? | 設定 | Cellsリース機能の有効/無効 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| cells関連テーブル | DB | リース状態の更新（コミット/ロールバック） |
| ログ | Hash | 処理結果のメタデータ |

### 出力ファイル仕様

該当なし

## 処理フロー

### 処理シーケンス

```
1. 機能有効チェック
   └─ Current.cells_claims_leases? で Cells リース機能の有効確認
2. 【無効の場合】処理終了（return）
3. 【有効の場合】ReconciliationService実行
   └─ Cells::Leases::ReconciliationService.new.execute を呼び出し
4. 結果ログ出力
   └─ log_hash_metadata_on_done で処理結果を記録
      - processed: 処理したリース数
      - committed: コミットしたリース数
      - rolled_back: ロールバックしたリース数
      - pending: 保留中のリース数
      - orphaned: 孤立したリース数
5. エラーハンドリング
   └─ StandardError発生時はErrorTrackingで記録後、再raise
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{Cellsリース有効?}
    B -->|No| G[バッチ終了]
    B -->|Yes| C[ReconciliationService実行]
    C --> D{エラー発生?}
    D -->|Yes| E[ErrorTracking記録]
    E --> F[例外再raise]
    D -->|No| H[処理結果ログ出力]
    H --> G
    F --> G
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リース検索 | cells_outstanding_leases | SELECT | 未解決リースを検索 |
| コミット処理 | cells関連 | UPDATE/INSERT | トランザクションのコミット |
| ロールバック処理 | cells関連 | UPDATE/DELETE | トランザクションのロールバック |

### テーブル別操作詳細

#### cells_outstanding_leases

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | all columns | 未解決状態のリース | ReconciliationServiceで処理 |
| UPDATE/DELETE | status等 | コミット/ロールバック結果 | ReconciliationServiceで処理 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | StandardError | ReconciliationService実行エラー | ErrorTrackingで記録後、再raise |
| - | ActiveRecord::QueryError | DB接続エラー | Sidekiq標準リトライで対処 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 3回（sidekiq_options retry: 3） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | すべての例外 |

### 障害時対応

冪等性（idempotent!）が宣言されているため、リトライしても問題ない。ReconciliationServiceは同じリースに対して複数回呼び出されても安全に処理される。ErrorTrackingで例外が記録されるため、繰り返し発生する場合は調査が可能。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ReconciliationService内で管理 |
| コミットタイミング | 各リースの処理完了時 |
| ロールバック条件 | 個別リース処理のエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 未解決リース数に依存 |
| 目標処理時間 | 数秒〜数十秒（リース数に依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

特に排他制御は実装されていない。冪等性が保証されているため、同時実行されても問題ない。ReconciliationService内で個別リースに対する排他制御が行われる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | Sidekiq標準ログ |
| 終了ログ | バッチ終了時 | Sidekiq標準ログ |
| メタデータ | 処理完了時 | message, feature_category, processed_leases, committed_leases, rolled_back_leases, pending_leases, orphaned_leases |
| エラーログ | エラー発生時 | 例外情報、feature_category: :cell |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行状況 | Sidekiq標準監視 | 運用チーム |
| エラー発生件数 | Sentry/ErrorTracking | 運用チーム |
| 孤立リース数 | 異常に多い場合 | 運用チーム |

## 備考

- feature_category: cell
- data_consistency: sticky
- idempotent!: 冪等ワーカー
- urgency: low
- queue_namespace: cronjob
- sidekiq_options retry: 3
- defer_on_database_health_signal: gitlab_main, [:cells_outstanding_leases], 1分（DBヘルス異常時は1分遅延）
- Current.cells_claims_leases? でCells機能の有効確認
- 処理結果は5つの指標（processed, committed, rolled_back, pending, orphaned）で記録
- ErrorTrackingでfeature_category: :cellを指定して例外を記録
