# バッチ設計書 12-Ci::ScheduleDeleteObjectsCronWorker

## 概要

本ドキュメントは、GitLabにおける削除対象オブジェクトのスケジュール処理を行うCronワーカー `Ci::ScheduleDeleteObjectsCronWorker` の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、CIパイプラインで生成されたオブジェクト（主にアーティファクトファイル）の削除処理をスケジュールし、実際の削除を行う子ワーカー `Ci::DeleteObjectsWorker` を並列実行する。論理削除されたオブジェクトをオブジェクトストレージから物理削除する役割を担う。

**業務上の目的・背景**：CIジョブの実行により生成されるアーティファクトは、論理削除（データベースからの削除）と物理削除（ストレージからのファイル削除）の2段階で処理される。論理削除済みのオブジェクトを `ci_deleted_objects` テーブルに記録し、本バッチがそれらをオブジェクトストレージから実際に削除することで、ストレージ容量を効率的に管理する。このアーキテクチャにより、トランザクション内でのネットワーク呼び出しを回避し、データ整合性を保ちながら非同期でストレージ削除を行える。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。削除対象オブジェクトが存在する限り、子ワーカーを継続的に起動する。

**主要な処理内容**：
1. `Ci::DeleteObjectsWorker.perform_with_capacity` を呼び出す
2. 子ワーカーが `ci_deleted_objects` テーブルから削除対象を取得
3. 子ワーカーがオブジェクトストレージからファイルを削除
4. 削除成功後、`ci_deleted_objects` レコードを削除

**前後の処理との関連**：アーティファクト削除サービス（`Ci::JobArtifacts::DestroyBatchService`等）が論理削除を行い、`ci_deleted_objects` にレコードを作成。本バッチがそのレコードを処理してストレージから物理削除を行う。

**影響範囲**：`ci_deleted_objects` テーブル、オブジェクトストレージに保存されたファイル。

## バッチ種別

データクレンジング / リソース管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cronジョブ） |
| 実行時刻 | 継続的 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 削除対象存在 | `ci_deleted_objects` テーブルに処理対象レコードが存在すること |
| ストレージ接続 | オブジェクトストレージへの接続が可能であること |

### 実行可否判定

子ワーカー `Ci::DeleteObjectsWorker` が `remaining_batches_count` を計算し、処理対象が存在する場合に継続実行する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| 任意の引数 | any | No | - | 子ワーカーにそのまま渡される |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ci_deleted_objects | DB | 削除対象オブジェクトのメタデータ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ci_deleted_objects | DB | 処理済みレコードの削除 |
| オブジェクトストレージ | File削除 | アーティファクトファイルの物理削除 |

### 出力ファイル仕様

ファイル出力なし（ファイル削除のみ）。

## 処理フロー

### 処理シーケンス

```
1. Cronワーカー起動
   └─ perform メソッド呼び出し
2. 子ワーカー実行
   └─ Ci::DeleteObjectsWorker.perform_with_capacity 呼び出し
3. 子ワーカー内処理（並列実行）
   └─ ci_deleted_objects からバッチ取得
   └─ ストレージからファイル削除
   └─ 処理済みレコード削除
4. 残処理確認
   └─ remaining_batches_count で継続判定
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[DeleteObjectsWorker.perform_with_capacity]
    B --> C[子ワーカー並列実行]
    C --> D[ci_deleted_objects取得]
    D --> E[ストレージファイル削除]
    E --> F{削除成功?}
    F -->|Yes| G[DBレコード削除]
    F -->|No| H[pick_up_at更新でリトライ]
    G --> I{残処理あり?}
    H --> I
    I -->|Yes| C
    I -->|No| J[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 削除対象取得 | ci_deleted_objects | SELECT/UPDATE | 処理対象の取得とロック |
| 処理完了 | ci_deleted_objects | DELETE | 削除成功レコードの削除 |

### テーブル別操作詳細

#### ci_deleted_objects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT/UPDATE | id, file_store, store_dir, file, pick_up_at | pick_up_at が現在時刻以前のレコード | FOR UPDATE SKIP LOCKED |
| UPDATE | pick_up_at | RETRY_IN（10分後） | 処理開始時に更新 |
| DELETE | - | 処理成功したレコード | id_in で一括削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TransactionInProgressError | 論理エラー | トランザクション内でストレージ削除を試行 | 処理中断、エラーログ出力 |
| - | ストレージ接続エラー | オブジェクトストレージへの接続失敗 | pick_up_at更新でリトライ |
| - | ファイル削除エラー | ファイルが存在しない等 | エラーメトリクス記録、スキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 3回（Sidekiq設定） |
| リトライ間隔 | RETRY_IN = 10分 |
| リトライ対象エラー | ストレージ接続エラー |

### 障害時対応

削除失敗したオブジェクトは `pick_up_at` が10分後に更新され、次回実行時に再処理される。ACCEPTABLE_DELAY（12時間）を超えた場合、Apdex SLIに影響が記録される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ci_deleted_objects取得時のみ |
| コミットタイミング | バッチ取得完了時 |
| ロールバック条件 | SELECT FOR UPDATE失敗時 |

ストレージ削除はトランザクション外で実行される（TransactionInProgressErrorで強制）。

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | BATCH_SIZE = 100件/バッチ |
| 目標処理時間 | バッチ単位で数秒 |
| メモリ使用量上限 | 100レコード分のメタデータ |
| 並列ワーカー数 | max_running_jobs = 50 |

## 排他制御

- 親ワーカーはidempotent（冪等）として設計
- 子ワーカーは `LimitedCapacity::Worker` による並列数制御
- `ci_deleted_objects` へのアクセスは `FOR UPDATE SKIP LOCKED` で排他制御

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | Sidekiqワーカー開始時 | ジョブID、ワーカー名 |
| エラーログ | ストレージ削除失敗時 | 対象オブジェクト情報、エラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理遅延（Apdex） | ACCEPTABLE_DELAY = 12時間 | Prometheus/Grafana |
| エラー率 | CiDeletedObjectProcessingSlis | 運用チーム |

## 備考

- data_consistency は `:always` に設定されており、常にプライマリデータベースを使用
- 子ワーカーの最大並列数は50に設定されている
- ストレージ削除処理はネットワークI/O待ちが発生するため、並列実行により効率化
