# バッチ設計書 13-Ci::UpdateLockedUnknownArtifactsWorker

## 概要

本ドキュメントは、GitLabにおけるロック状態不明のアーティファクトを更新するCronワーカー `Ci::UpdateLockedUnknownArtifactsWorker` の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、CIジョブアーティファクトのロック状態が「不明（unknown）」となっているレコードを検出し、パイプラインのロック状態に基づいて適切なロック状態に更新、またはロック解除されたアーティファクトを削除する。データ整合性を保つためのメンテナンス処理を担当する。

**業務上の目的・背景**：CIジョブアーティファクトには「locked（ロック済み）」「unlocked（ロック解除）」「unknown（不明）」の3つのロック状態がある。ロック状態が不明のまま放置されると、アーティファクトの有効期限管理が正しく機能せず、ストレージが無駄に消費される可能性がある。本バッチは、パイプラインのアーティファクトロック設定を参照し、アーティファクトのロック状態を正しく更新することで、有効期限切れアーティファクトの適切な削除を可能にする。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。urgency は throttled に設定されており、低優先度で実行される。

**主要な処理内容**：
1. 排他ロックを取得（6分間有効）
2. ロック状態が不明かつ有効期限切れのアーティファクトを検索
3. 対応するビルドのパイプラインがロックされているか確認
4. ロックされているパイプラインのアーティファクトは `artifacts_locked` に更新
5. ロックされていないパイプラインのアーティファクトは削除

**前後の処理との関連**：`ExpireBuildArtifactsWorker` 等のアーティファクト削除処理と連携し、ロック状態が正しく設定されたアーティファクトのみが削除対象となるよう整合性を保つ。

**影響範囲**：`ci_job_artifacts` テーブル、関連するオブジェクトストレージファイル。

## バッチ種別

データクレンジング / データ整合性維持

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cronジョブ） |
| 実行時刻 | 継続的 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 排他ロック取得 | EXCLUSIVE_LOCK_KEY のリースを取得できること |
| 処理対象存在 | ロック状態がunknownかつ期限切れのアーティファクトが存在すること |

### 実行可否判定

排他ロックを取得できない場合はスキップ（retries: 1で再試行後）。処理対象がなくなるか、タイムアウト（5分）に達するまで継続。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本ワーカーはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ci_job_artifacts | DB | ロック状態がunknownのアーティファクト |
| ci_builds | DB | アーティファクトに対応するビルド情報 |
| ci_pipelines | DB | ビルドが属するパイプライン（ロック状態確認） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ci_job_artifacts | DB | lockedカラムの更新またはレコード削除 |
| オブジェクトストレージ | File削除 | unlockアーティファクトのファイル削除 |
| ログ | メタデータ | removed_count, locked_count |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. 排他ロック取得
   └─ EXCLUSIVE_LOCK_KEY で6分間のリース取得
2. ループ処理開始（最大5分または100回）
   └─ ロック状態unknownのアーティファクトを100件取得
3. ビルドID抽出
   └─ 対象アーティファクトのjob_idを取得
4. パイプラインロック状態確認
   └─ ロックされたパイプラインのビルドIDを特定
5. ロック状態更新
   └─ ロックパイプラインのアーティファクトをartifacts_lockedに更新
6. アンロックアーティファクト削除
   └─ ロック解除されたアーティファクトを削除
7. メタデータ出力
   └─ removed_count, locked_countをログに出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{排他ロック取得?}
    B -->|No| C[スキップ]
    B -->|Yes| D[unknownアーティファクト取得]
    D --> E{対象あり?}
    E -->|No| F[ループ終了]
    E -->|Yes| G[ビルドID抽出]
    G --> H[パイプラインロック確認]
    H --> I[ロック済みアーティファクト更新]
    I --> J[アンロックアーティファクト削除]
    J --> K{タイムアウト or 上限?}
    K -->|No| D
    K -->|Yes| F
    F --> L[メタデータログ出力]
    L --> M[バッチ終了]
    C --> M
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| アーティファクト検索 | ci_job_artifacts | SELECT | unknownロック状態の検索 |
| ビルド検索 | ci_builds | SELECT | パイプラインロック状態の確認 |
| ロック状態更新 | ci_job_artifacts | UPDATE | lockedカラムの更新 |
| アーティファクト削除 | ci_job_artifacts | DELETE | unlockアーティファクトの削除 |

### テーブル別操作詳細

#### ci_job_artifacts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, job_id | expire_at < 現在時刻 AND locked = unknown | ORDER BY expire_at ASC LIMIT 100 |
| UPDATE | locked | artifacts_locked | パイプラインがロック済みの場合 |
| DELETE | - | パイプラインがアンロックの場合 | DestroyBatchServiceで削除 |

#### ci_builds

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | with_pipeline_locked_artifacts スコープ | パイプラインロック確認 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 排他ロック取得失敗 | 他プロセスがロック保持 | 1回リトライ後スキップ |
| - | タイムアウト | 処理が5分を超過 | ループ終了、次回実行で継続 |
| - | DB接続エラー | データベース接続失敗 | Sidekiqリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | DB接続エラー等 |

### 障害時対応

処理途中で失敗した場合、排他ロックは最大6分後に自動解放される。次回実行時に未処理のアーティファクトから再開される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ単位（100件） |
| コミットタイミング | 各バッチ処理完了時 |
| ロールバック条件 | UPDATE/DELETE失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | BATCH_SIZE = 100件/ループ |
| 目標処理時間 | LOOP_TIMEOUT = 5分 |
| 最大ループ回数 | LOOP_LIMIT = 100回 |
| メモリ使用量上限 | 100レコード分 |

## 排他制御

- `Gitlab::ExclusiveLeaseHelpers` による排他ロック
- ロックキー：`unknown_status_job_artifacts:update:lock`
- ロックタイムアウト：6分
- リトライ回数：1回

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | Sidekiqワーカー開始時 | ジョブID、ワーカー名 |
| 終了ログ | バッチ終了時 | removed_count, locked_count |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 5分超過 | 運用チーム |
| removed_count | 大量削除発生時 | 運用チーム |

## 備考

- urgency は `:throttled` に設定されており、低優先度キューで実行される
- data_consistency は `:sticky` に設定されており、必要に応じてレプリカを使用
- idempotent ではない（同時実行時に排他ロックで制御）
