# バッチ設計書 14-ContainerExpirationPolicyWorker

## 概要

本ドキュメントは、GitLabにおけるコンテナイメージの有効期限ポリシーを実行するCronワーカー `ContainerExpirationPolicyWorker` の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、プロジェクトに設定されたコンテナレジストリの有効期限ポリシーに基づき、古いコンテナイメージを自動的に削除するための処理をオーケストレーションする。コンテナリポジトリのクリーンアップ処理を管理し、不要なイメージによるストレージ消費を抑制する。

**業務上の目的・背景**：コンテナレジストリは、CIパイプラインで生成されるDockerイメージを保存するが、古いイメージが蓄積するとストレージコストが増大する。コンテナ有効期限ポリシー（Container Expiration Policy）を使用することで、各プロジェクトが独自のルールに基づいて古いイメージを自動削除できる。本バッチはそのポリシー実行を統括し、効率的なクリーンアップを実現する。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。ExclusiveLeaseGuard による排他制御で、5時間のリースを取得して処理を行う。

**主要な処理内容**：
1. 停滞したクリーンアップ処理のリセット
2. コンテナリポジトリを持たないポリシーの無効化
3. 排他リースを取得してクリーンアップワーカーを実行
4. クリーンアップ必要なリポジトリ数をログ出力

**前後の処理との関連**：本バッチは `ContainerExpirationPolicies::CleanupContainerRepositoryWorker` の親ワーカーとして機能する。子ワーカーが実際のコンテナイメージ削除を担当する。

**影響範囲**：`container_expiration_policies` テーブル、`container_repositories` テーブル、コンテナレジストリに保存されたイメージ。

## バッチ種別

データクレンジング / リソース管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cronジョブ） |
| 実行時刻 | 継続的 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 排他リース取得 | 5時間のリースを取得できること |
| アクティブポリシー | 有効なコンテナ有効期限ポリシーが存在すること |

### 実行可否判定

ExclusiveLeaseGuardにより排他リースを取得できない場合はスキップ。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本ワーカーはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| container_expiration_policies | DB | コンテナ有効期限ポリシー設定 |
| container_repositories | DB | コンテナリポジトリ情報 |
| application_settings | DB | delete_tags_service_timeout 設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| container_expiration_policies | DB | ポリシーの有効/無効更新 |
| container_repositories | DB | クリーンアップステータス更新 |
| ログ | メタデータ | cleanup_required_count, cleanup_unfinished_count, cleanup_total_count |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. 停滞クリーンアップ処理のリセット
   └─ delete_tags_service_timeout + 30分以上経過した処理をunfinishedに更新
2. コンテナなしポリシーの無効化
   └─ container_repositoryを持たないポリシーを無効化
3. 排他リース取得
   └─ 5時間のリースを取得
4. クリーンアップワーカー実行
   └─ CleanupContainerRepositoryWorker.perform_with_capacity
5. カウントログ出力
   └─ レプリカを使用して各種カウントを取得・出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[停滞クリーンアップリセット]
    B --> C[コンテナなしポリシー無効化]
    C --> D{排他リース取得?}
    D -->|No| E[スキップ]
    D -->|Yes| F[CleanupContainerRepositoryWorker実行]
    F --> G[カウントログ出力]
    G --> H[バッチ終了]
    E --> H
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 停滞処理リセット | container_repositories | UPDATE | ステータスをunfinishedに更新 |
| ポリシー無効化 | container_expiration_policies | UPDATE | enabledをfalseに更新 |
| カウント取得 | container_repositories | SELECT | クリーンアップ必要数の取得 |

### テーブル別操作詳細

#### container_repositories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | expiration_policy_cleanup_status | cleanup_unfinished | 停滞した ongoing 処理 |
| SELECT | id | requiring_cleanup スコープ | クリーンアップ必要なリポジトリ |
| SELECT | id | with_unfinished_cleanup スコープ | 未完了クリーンアップ |

#### container_expiration_policies

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | active スコープ | アクティブなポリシー |
| UPDATE | enabled | false | container_repositoryなしのポリシー |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidPolicyError | カスタムエラー | 無効なポリシー設定 | ログ出力、次ポリシーへ |
| - | 排他リース取得失敗 | 他プロセスが処理中 | スキップ |
| - | DB接続エラー | データベース接続失敗 | Sidekiqリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | DB接続エラー等 |

### 障害時対応

排他リースは最大5時間後に自動解放される。停滞した処理は次回実行時に自動リセットされる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ単位（BATCH_SIZE = 1000） |
| コミットタイミング | 各バッチ処理完了時 |
| ロールバック条件 | UPDATE失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | BATCH_SIZE = 1000件/バッチ |
| 目標処理時間 | リースタイムアウト5時間以内 |
| メモリ使用量上限 | バッチ処理により制限 |

## 排他制御

- `ExclusiveLeaseGuard` による排他ロック
- リースタイムアウト：5時間
- 同時実行は1プロセスのみ許可

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | Sidekiqワーカー開始時 | ジョブID、ワーカー名 |
| 終了ログ | バッチ終了時 | cleanup_required_count, cleanup_unfinished_count, cleanup_total_count |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 5時間超過 | 運用チーム |
| cleanup_total_count | 異常増加時 | 運用チーム |

## 備考

- data_consistency は `:always` に設定されており、常にプライマリを使用（カウント取得時はレプリカ使用）
- BATCH_SIZE = 1000 でポリシーを一括処理
- delete_tags_service_timeout は ApplicationSettings から取得（デフォルト0）
- 停滞判定の閾値は delete_tags_service_timeout + 30分
