# バッチ設計書 15-ContainerRegistry::CleanupWorker

## 概要

本ドキュメントは、GitLabにおけるコンテナレジストリのクリーンアップ処理を行うCronワーカー `ContainerRegistry::CleanupWorker` の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、コンテナレジストリに関連する複数のクリーンアップ処理を統括する。削除スケジュールされたコンテナリポジトリの削除、停滞した削除処理のリセット、データ修復詳細のクリーンアップ、およびデータ修復ワーカーの起動を行う。

**業務上の目的・背景**：コンテナレジストリはプロジェクトのライフサイクルに伴い、削除対象となるリポジトリや修復が必要なデータが発生する。これらを適切にクリーンアップしないと、ストレージの無駄遣いやデータ不整合が発生する可能性がある。本バッチは定期的にこれらの処理を実行し、コンテナレジストリの健全性を維持する。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。

**主要な処理内容**：
1. 停滞した削除処理のリセット（30分以上経過したongoing→scheduled）
2. 停滞したデータ修復詳細の削除（2時間以上経過）
3. 削除スケジュールされたリポジトリの削除ワーカー起動
4. データ修復詳細記録ワーカーの起動（GitLab.com限定）

**前後の処理との関連**：`ContainerRegistry::DeleteContainerRepositoryWorker` と `ContainerRegistry::RecordDataRepairDetailWorker` の親ワーカーとして機能する。

**影響範囲**：`container_repositories` テーブル、`container_registry_data_repair_details` テーブル、コンテナレジストリのリポジトリ。

## バッチ種別

データクレンジング / メンテナンス

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cronジョブ） |
| 実行時刻 | 継続的 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 処理対象存在 | 削除スケジュールされたリポジトリまたは修復対象プロジェクトが存在すること |

### 実行可否判定

データ修復ワーカーの起動条件：
- GitLab.com（Jihuを除く）であること
- Feature flag `registry_data_repair_worker` が有効であること
- GitLab API がサポートされていること
- 修復待ちプロジェクトが存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本ワーカーはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| container_repositories | DB | コンテナリポジトリ情報 |
| container_registry_data_repair_details | DB | データ修復詳細情報 |
| projects | DB | 修復待ちプロジェクト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| container_repositories | DB | ステータス更新（ongoing→scheduled） |
| container_registry_data_repair_details | DB | 停滞レコードの削除 |
| Sidekiqジョブキュー | Job | 子ワーカーのエンキュー |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. 停滞削除処理のリセット
   └─ 30分以上 delete_ongoing のリポジトリを delete_scheduled に更新
2. 停滞データ修復詳細の削除
   └─ 2時間以上 ongoing のデータ修復詳細を削除
3. 削除ワーカー起動
   └─ delete_scheduled なリポジトリが存在すれば DeleteContainerRepositoryWorker を起動
4. データ修復ワーカー起動
   └─ 条件を満たせば RecordDataRepairDetailWorker を起動
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[停滞削除処理リセット]
    B --> C[停滞データ修復詳細削除]
    C --> D{delete_scheduled存在?}
    D -->|Yes| E[DeleteContainerRepositoryWorker起動]
    D -->|No| F{修復ワーカー起動条件?}
    E --> F
    F -->|Yes| G[RecordDataRepairDetailWorker起動]
    F -->|No| H[バッチ終了]
    G --> H
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 停滞リセット | container_repositories | UPDATE | ステータス更新 |
| 修復詳細削除 | container_registry_data_repair_details | DELETE | 停滞レコード削除 |
| 存在確認 | container_repositories | SELECT | 削除対象の存在確認 |
| 存在確認 | projects | SELECT | 修復待ちプロジェクトの確認 |

### テーブル別操作詳細

#### container_repositories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | status, delete_started_at | delete_scheduled, nil | delete_ongoing かつ 30分以上経過 |
| SELECT | - | delete_scheduled.exists? | 削除対象存在確認 |

#### container_registry_data_repair_details

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | ongoing_since(2時間前) | 停滞レコードの一括削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DB接続エラー | データベース接続失敗 | Sidekiqリトライ |
| - | レジストリAPI接続エラー | GitLab API接続失敗 | 次回実行で再試行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | DB接続エラー等 |

### 障害時対応

処理途中で失敗した場合、次回実行時に未処理のリポジトリから再開される。停滞したongoing処理は30分後に自動リセットされる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ単位（BATCH_SIZE = 200） |
| コミットタイミング | 各バッチ処理完了時 |
| ロールバック条件 | UPDATE/DELETE失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | BATCH_SIZE = 200件/バッチ |
| 目標処理時間 | 数分以内 |
| メモリ使用量上限 | バッチ処理により制限 |

## 排他制御

- 本ワーカーはidempotent（冪等）として設計
- 同時実行されても安全に動作

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | Sidekiqワーカー開始時 | ジョブID、ワーカー名 |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 設定による | 運用チーム |
| delete_scheduled数 | 異常増加時 | 運用チーム |

## 備考

- data_consistency は `:always` に設定されており、常にプライマリを使用
- STALE_DELETE_THRESHOLD = 30分（停滞削除処理の閾値）
- STALE_REPAIR_DETAIL_THRESHOLD = 2時間（停滞修復詳細の閾値）
- BATCH_SIZE = 200
- データ修復ワーカーは GitLab.com（Jihuを除く）でのみ起動
