# バッチ設計書 16-UpdateContainerRegistryInfoWorker

## 概要

本ドキュメントは、GitLabにおけるコンテナレジストリ情報を更新するCronワーカー `UpdateContainerRegistryInfoWorker` の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、接続されているコンテナレジストリのメタ情報（ベンダー、バージョン、機能フラグ、データベース有効状態）を取得し、GitLabのアプリケーション設定に反映する。これによりGitLabはレジストリの機能を適切に活用できる。

**業務上の目的・背景**：GitLabは異なるコンテナレジストリ実装（Docker Registry、GitLab Container Registry等）と連携できる。レジストリのバージョンや対応機能によって、利用できるAPIやオペレーションが異なる。本バッチは定期的にレジストリ情報を取得・更新することで、GitLabが最新のレジストリ機能を正しく認識し、ユーザーに適切な機能を提供できるようにする。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。urgency は low に設定されており、低優先度で実行される。

**主要な処理内容**：
1. コンテナレジストリからメタ情報を取得
2. GitLab API（v1）がサポートされている場合は統計情報も取得
3. アプリケーション設定を更新（vendor, version, features, db_enabled）

**前後の処理との関連**：本バッチは独立して動作し、取得した情報は他のコンテナレジストリ関連機能から参照される。

**影響範囲**：`application_settings` テーブルのコンテナレジストリ関連カラム。

## バッチ種別

設定同期 / メタデータ更新

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cronジョブ） |
| 実行時刻 | 継続的 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| レジストリ有効 | コンテナレジストリが有効化されていること |
| API URL設定 | レジストリのAPI URLが設定されていること |

### 実行可否判定

レジストリからメタ情報を取得できない場合（無効または未設定の場合）は早期リターン。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本ワーカーはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| コンテナレジストリAPI | HTTP | /v2/ または GitLab API |
| gitlab.yml | 設定ファイル | registry設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| application_settings | DB | レジストリ情報の更新 |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. レジストリ情報取得
   └─ GitLab API サポート確認
2. API種別による分岐
   ├─ GitLab API対応: GitlabApiClient.statistics で統計取得
   └─ V2 API のみ: /v2 エンドポイントから基本情報取得
3. アプリケーション設定更新
   └─ vendor, version, features, db_enabled を更新
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[レジストリ情報取得]
    B --> C{情報取得成功?}
    C -->|No| D[リターン]
    C -->|Yes| E{GitLab API対応?}
    E -->|Yes| F[GitlabApiClient.statistics]
    E -->|No| G[V2 API から取得]
    F --> H[GITLAB_V1_API_FEATURE追加]
    H --> I[application_settings更新]
    G --> I
    I --> J[バッチ終了]
    D --> J
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定更新 | application_settings | UPDATE | レジストリ情報の更新 |

### テーブル別操作詳細

#### application_settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | container_registry_vendor | レジストリベンダー名 | 'gitlab' または空文字 |
| UPDATE | container_registry_version | レジストリバージョン | バージョン文字列または空文字 |
| UPDATE | container_registry_features | 機能フラグ配列 | features配列 |
| UPDATE | container_registry_db_enabled | DB有効フラグ | true/false |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | レジストリ接続エラー | レジストリAPI接続失敗 | nilを返し、更新をスキップ |
| - | 認証エラー | トークン生成失敗 | エラーログ出力、次回実行で再試行 |
| - | DB接続エラー | データベース接続失敗 | Sidekiqリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | DB接続エラー等 |

### 障害時対応

レジストリ情報取得に失敗した場合、既存の設定は変更されない。次回実行時に再取得を試みる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | update! 単体 |
| コミットタイミング | 更新完了時 |
| ロールバック条件 | UPDATE失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件（application_settings） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小限 |

## 排他制御

- 本ワーカーはidempotent（冪等）として設計
- 同時実行されても最後の更新が反映される

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | Sidekiqワーカー開始時 | ジョブID、ワーカー名 |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 60秒超過 | 運用チーム |
| 連続失敗 | 3回以上 | 運用チーム |

## 備考

- data_consistency は `:always` に設定されており、常にプライマリを使用
- urgency は `:low` に設定されており、低優先度キューで実行
- レジストリが無効な場合は情報取得をスキップ
- V2 API使用時は、アクセス権限なしのJWTトークンを生成して認証
- GitLab API対応時は `REGISTRY_GITLAB_V1_API_FEATURE` を features に追加
