# バッチ設計書 17-Database::PartitionManagementWorker

## 概要

本ドキュメントは、GitLabにおけるデータベースパーティションの同期・管理を行うCronワーカー `Database::PartitionManagementWorker` の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、PostgreSQLのパーティションテーブルを自動的に管理する。登録されたパーティションモデルに対して、必要なパーティションの作成と不要なパーティションの整理を行う。これにより、時系列データやID範囲ベースのデータを効率的に格納・管理できる。

**業務上の目的・背景**：GitLabは大規模データを効率的に管理するためにPostgreSQLのパーティショニング機能を活用している。時系列データ（audit_events等）やID範囲ベースのデータは、パーティションに分割することでクエリパフォーマンスが向上し、古いデータの削除も容易になる。本バッチは、これらのパーティションを自動的に作成・管理することで、手動運用の負担を軽減し、データベースの健全性を維持する。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。

**主要な処理内容**：
1. 登録されたパーティションモデルに対してパーティション同期
2. 必要に応じて新しいパーティションを作成
3. パーティションメトリクスをレポート
4. 処理完了後、ensure句でメトリクスレポートを保証

**前後の処理との関連**：`Database::DropDetachedPartitionsWorker` と連携し、パーティションのライフサイクル全体を管理する。

**影響範囲**：PostgreSQLパーティションテーブル、パーティション管理メタデータ。

## バッチ種別

データベース管理 / メンテナンス

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cronジョブ） |
| 実行時刻 | 継続的 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Feature flag有効 | `partition_manager_sync_partitions` が有効であること |
| DDL許可 | `disallow_database_ddl_feature_flags` が無効であること |

### 実行可否判定

Feature flag `disallow_database_ddl_feature_flags` が有効な場合、処理をスキップ。
Feature flag `partition_manager_sync_partitions` が無効な場合、処理をスキップ。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本ワーカーはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 登録済みパーティションモデル | Ruby Class | Gitlab::Database::Partitioning.registered_models |
| 登録済みパーティションテーブル | Hash | Gitlab::Database::Partitioning.registered_tables |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| PostgreSQLパーティション | DDL | 新規パーティション作成 |
| Prometheusメトリクス | Gauge | パーティション数等のメトリクス |
| ログ | AppLogger | 処理状況ログ |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. Feature flag確認
   └─ disallow_database_ddl_feature_flags が有効ならスキップ
   └─ partition_manager_sync_partitions が無効ならスキップ
2. パーティション同期開始ログ出力
3. 各モデル/テーブルに対してパーティション同期
   └─ 各データベース接続で PartitionManager.sync_partitions 実行
   └─ 必要に応じて ANALYZE 実行
4. 本番環境以外では他DBへも同期
5. 同期完了ログ出力
6. メトリクスレポート（ensure句で保証）
   └─ PartitionMonitoring.report_metrics_for_model
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{DDL許可?}
    B -->|No| C[スキップ]
    B -->|Yes| D{partition_manager有効?}
    D -->|No| C
    D -->|Yes| E[同期開始ログ]
    E --> F[各モデルでパーティション同期]
    F --> G[必要なパーティション作成]
    G --> H[ANALYZE実行]
    H --> I[同期完了ログ]
    I --> J[メトリクスレポート]
    J --> K[バッチ終了]
    C --> J
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パーティション作成 | 各パーティションテーブル | DDL | CREATE TABLE PARTITION |
| 統計更新 | 新規パーティション | ANALYZE | テーブル統計情報更新 |

### テーブル別操作詳細

パーティション対象テーブルはモデル登録により動的に決定される。代表的なテーブル例：

| 操作 | 対象テーブル例 | 操作種別 | 備考 |
|-----|---------------|---------|------|
| CREATE PARTITION | audit_events, web_hook_logs等 | DDL | 時系列パーティション |
| ANALYZE | 新規作成パーティション | DML | 統計情報収集 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | パーティション作成失敗 | DDL実行エラー | ログ出力、次回実行で再試行 |
| - | DB接続エラー | データベース接続失敗 | Sidekiqリトライ |
| - | Feature flag評価エラー | Feature flag評価失敗 | エラーログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | DB接続エラー等 |

### 障害時対応

パーティション作成に失敗した場合、次回実行時に再試行される。メトリクスレポートはensure句で保証されるため、処理失敗時もメトリクスは出力される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | DDL操作は自動コミット |
| コミットタイミング | 各DDL実行後 |
| ロールバック条件 | DDL失敗時（自動） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 登録モデル数分 |
| 目標処理時間 | 数分以内 |
| メモリ使用量上限 | 最小限 |

## 排他制御

- 本ワーカーはidempotent（冪等）として設計
- DDL操作はPostgreSQLの内部ロックで排他制御

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 同期開始時 | 'Syncing dynamic postgres partitions' |
| 終了ログ | 同期完了時 | 'Finished sync of dynamic postgres partitions' |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| パーティション数 | Prometheusメトリクス | Grafana |
| 処理時間 | 設定による | 運用チーム |

## 備考

- data_consistency は `:always` に設定されており、常にプライマリを使用
- 本番環境（Rails.env.production?）では owner_db_only = true で所有者DBのみ同期
- 非本番環境ではすべてのデータベースに同期（テスト用途）
- SharedModel を継承したモデルはすべてのDBに同期される
