# バッチ設計書 18-Database::DropDetachedPartitionsWorker

## 概要

本ドキュメントは、GitLabにおける切り離されたパーティションを削除するCronワーカー `Database::DropDetachedPartitionsWorker` の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、パーティションテーブルから切り離された（detached）パーティションを実際に削除する。パーティション管理のライフサイクルにおいて、不要になったパーティションをクリーンアップし、データベースストレージを回収する役割を担う。

**業務上の目的・背景**：パーティションテーブルの運用では、古いパーティションは最初に「切り離し（detach）」状態にされ、一定期間後に実際に削除される。この2段階アプローチにより、切り離し直後のクエリエラーを防ぎつつ、最終的にはストレージを回収できる。本バッチは切り離されたパーティションを検出し、安全に削除することで、データベースリソースを効率的に管理する。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。

**主要な処理内容**：
1. Feature flagの確認
2. 各データベース接続で DetachedPartitionDropper を実行
3. 切り離されたパーティションを削除
4. パーティションメトリクスをレポート（ensure句で保証）

**前後の処理との関連**：`Database::PartitionManagementWorker` と連携し、パーティションのライフサイクル全体を管理する。PartitionManagementWorkerがパーティションを作成・切り離し、本バッチが切り離されたパーティションを削除する。

**影響範囲**：切り離されたPostgreSQLパーティション、`detached_partitions` 管理テーブル。

## バッチ種別

データベース管理 / クリーンアップ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cronジョブ） |
| 実行時刻 | 継続的 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Feature flag有効 | `partition_manager_sync_partitions` が有効であること |
| DDL許可 | `disallow_database_ddl_feature_flags` が無効であること |

### 実行可否判定

Feature flag `disallow_database_ddl_feature_flags` が有効な場合、処理をスキップ。
Feature flag `partition_manager_sync_partitions` が無効な場合、処理をスキップ。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本ワーカーはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| detached_partitions | DB | 切り離されたパーティション情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| PostgreSQLパーティション | DDL | パーティションテーブル削除 |
| detached_partitions | DB | 管理レコード削除 |
| Prometheusメトリクス | Gauge | パーティション数等のメトリクス |
| ログ | AppLogger | 処理状況ログ |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. Feature flag確認
   └─ disallow_database_ddl_feature_flags が有効ならスキップ
   └─ partition_manager_sync_partitions が無効ならスキップ
2. 削除開始ログ出力
3. 各データベース接続で DetachedPartitionDropper 実行
   └─ 切り離されたパーティションを検出
   └─ DROP TABLE 実行
   └─ 管理レコード削除
4. 削除完了ログ出力
5. メトリクスレポート（ensure句で保証）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{DDL許可?}
    B -->|No| C[スキップ]
    B -->|Yes| D{partition_manager有効?}
    D -->|No| C
    D -->|Yes| E[削除開始ログ]
    E --> F[各DB接続でDropper実行]
    F --> G[切り離しパーティション検出]
    G --> H[DROP TABLE実行]
    H --> I[管理レコード削除]
    I --> J[削除完了ログ]
    J --> K[メトリクスレポート]
    K --> L[バッチ終了]
    C --> K
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パーティション検索 | detached_partitions | SELECT | 削除対象の検索 |
| パーティション削除 | 切り離されたパーティション | DDL | DROP TABLE |
| 管理レコード削除 | detached_partitions | DELETE | 管理情報の削除 |

### テーブル別操作詳細

#### detached_partitions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | table_name, drop_after | drop_after < 現在時刻 | 削除可能なパーティション |
| DELETE | - | 削除完了したレコード | DROP TABLE成功後 |

#### 切り離されたパーティション

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DROP TABLE | - | detached_partitions から取得 | DDL実行 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DROP TABLE失敗 | DDL実行エラー | ログ出力、次回実行で再試行 |
| - | DB接続エラー | データベース接続失敗 | Sidekiqリトライ |
| - | Feature flag評価エラー | Feature flag評価失敗 | エラーログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | DB接続エラー等 |

### 障害時対応

パーティション削除に失敗した場合、次回実行時に再試行される。メトリクスレポートはensure句で保証されるため、処理失敗時もメトリクスは出力される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | DDL操作は自動コミット |
| コミットタイミング | 各DDL実行後 |
| ロールバック条件 | DDL失敗時（自動） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 切り離されたパーティション数分 |
| 目標処理時間 | パーティションサイズに依存 |
| メモリ使用量上限 | 最小限 |

## 排他制御

- 本ワーカーはidempotent（冪等）として設計
- DDL操作はPostgreSQLの内部ロックで排他制御

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 削除開始時 | 'Dropping detached postgres partitions' |
| 終了ログ | 削除完了時 | 'Finished dropping detached postgres partitions' |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| パーティション数 | Prometheusメトリクス | Grafana |
| 処理時間 | 設定による | 運用チーム |
| detached_partitions増加 | 異常蓄積時 | 運用チーム |

## 備考

- data_consistency は `:always` に設定されており、常にプライマリを使用
- `Database::PartitionManagementWorker` と同じ Feature flag で制御
- 切り離しから削除までの待機期間は `drop_after` カラムで管理
- 大きなパーティションの削除はI/O負荷が高いため、処理時間に注意
