# バッチ設計書 19-Database::MonitorLockedTablesWorker

## 概要

本ドキュメントは、GitLabにおけるロックされたテーブルを監視するCronワーカー `Database::MonitorLockedTablesWorker` の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、マルチデータベース環境においてテーブルの書き込みロック状態を監視し、必要に応じてロック/アンロック処理をトリガーする。Cell アーキテクチャにおけるデータベース分離の整合性を維持する役割を担う。

**業務上の目的・背景**：GitLabのCell アーキテクチャでは、メインデータベースとCIデータベースを分離して運用する。各データベースには特定のスキーマに属するテーブルのみが書き込み可能であるべきで、他のデータベースへの誤った書き込みを防ぐためにテーブルロック機構が使用される。本バッチは、テーブルのロック状態を監視し、ロックが必要なテーブル、アンロックが必要なテーブルを検出してレポートする。また、自動的にロック処理を行う機能も持つ。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。マルチデータベースモードでのみ動作。

**主要な処理内容**：
1. マルチデータベースモードの確認
2. Feature flagの確認
3. TablesLocker でドライランによるロック状態チェック
4. ロック/アンロックが必要なテーブルを集計
5. 必要に応じて LockTablesWorker を起動
6. 結果をメタデータとしてログ出力

**前後の処理との関連**：`Database::LockTablesWorker` を起動して実際のロック処理を委譲する。

**影響範囲**：PostgreSQLテーブルのロック状態、`lock_writes` トリガー。

## バッチ種別

データベース管理 / 監視

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cronジョブ） |
| 実行時刻 | 継続的 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| マルチDB | `Gitlab::Database.database_mode == MODE_MULTIPLE_DATABASES` |
| Feature flag | `monitor_database_locked_tables` が有効であること |

### 実行可否判定

- マルチデータベースモードでない場合は早期リターン
- Feature flag `monitor_database_locked_tables` が無効な場合は早期リターン

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本ワーカーはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitlabSchema.tables_to_schema | Hash | テーブルとスキーマのマッピング |
| database_base_models_with_gitlab_shared | Hash | データベース接続情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ログ | メタデータ | tables_need_lock, tables_need_unlock 等 |
| Sidekiqジョブキュー | Job | LockTablesWorker のエンキュー |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. マルチデータベースモード確認
   └─ 単一DBモードならリターン
2. Feature flag確認
   └─ monitor_database_locked_tables が無効ならリターン
3. TablesLocker でドライラン実行
   └─ dry_run: true, include_partitions: false
4. 結果を集計
   └─ needs_lock, needs_unlock を各DB別にカウント
5. ロック処理判定
   └─ lock_tables_in_monitoring 有効
   └─ disallow_database_ddl_feature_flags 無効
   └─ 条件を満たせば LockTablesWorker を起動
6. メタデータログ出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{マルチDBモード?}
    B -->|No| C[リターン]
    B -->|Yes| D{Feature flag有効?}
    D -->|No| C
    D -->|Yes| E[TablesLocker ドライラン]
    E --> F[結果集計]
    F --> G{ロック必要テーブルあり?}
    G -->|No| H[メタデータログ]
    G -->|Yes| I{lock_tables_in_monitoring有効?}
    I -->|No| H
    I -->|Yes| J{DDL許可?}
    J -->|No| H
    J -->|Yes| K[LockTablesWorker起動]
    K --> H
    H --> L[バッチ終了]
    C --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ロック状態確認 | 各テーブル | SELECT | トリガー存在確認 |

### テーブル別操作詳細

本ワーカー自体はドライランのみを行い、実際のロック処理は LockTablesWorker に委譲する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DB接続エラー | データベース接続失敗 | リトライなし（retry: false） |
| - | Feature flag評価エラー | Feature flag評価失敗 | エラーログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（retry: false） |
| リトライ間隔 | N/A |
| リトライ対象エラー | なし |

### 障害時対応

本ワーカーは監視目的のため、失敗しても次回実行を待つ。リトライは無効化されている。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ドライランのみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 全テーブル数分 |
| 目標処理時間 | 数分以内 |
| メモリ使用量上限 | テーブルリスト分 |

## 排他制御

- 本ワーカーはidempotent（冪等）として設計
- 監視のみのため、排他制御は不要

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | Sidekiqワーカー開始時 | ジョブID、ワーカー名 |
| 終了ログ | バッチ終了時 | DB別のロック/アンロック必要テーブル一覧 |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| tables_need_lock_count | 0より大きい場合 | 運用チーム |
| tables_need_unlock_count | 0より大きい場合 | 運用チーム |

## 備考

- data_consistency は `:sticky` に設定
- feature_category は `:cell` に設定
- version 1 として管理
- sidekiq_options retry: false（リトライ無効）
- GITLAB_SCHEMAS_TO_IGNORE: gitlab_embedding, gitlab_geo, gitlab_jh は無視
- パーティションはチェック対象外（include_partitions: false）
- 自動ロック機能は `lock_tables_in_monitoring` Feature flag で制御
