# バッチ設計書 21-Database::CiProjectMirrorsConsistencyCheckWorker

## 概要

本ドキュメントは、CIプロジェクトミラーの整合性チェックを行うバッチ処理「Database::CiProjectMirrorsConsistencyCheckWorker」の設計仕様を記載する。

### 本バッチの処理概要

本バッチは、GitLabのプロジェクトテーブル（projects）とCIプロジェクトミラーテーブル（ci_project_mirrors）間のデータ整合性を検証し、不整合が検出された場合に自動修復を行う処理である。

**業務上の目的・背景**：GitLabでは、パフォーマンス最適化のためにプロジェクトのCI関連情報をミラーテーブルに複製している。Cell構成やマイクロサービス化により、元テーブルとミラーテーブル間でデータの不整合が発生する可能性があるため、定期的な整合性チェックと自動修復が必要である。これにより、CIパイプラインの正常な動作とデータの信頼性を確保する。

**バッチの実行タイミング**：Cronジョブとして定期実行される。システム負荷の低い時間帯に継続的に実行され、データ整合性を維持する。

**主要な処理内容**：
1. ConsistencyCheckServiceを使用して、projectsテーブルとci_project_mirrorsテーブルのid/namespace_idカラムを比較
2. 不整合レコードの詳細情報（mismatches_details）を取得
3. 不整合が検出された場合、ConsistencyFixServiceを使用してProjects::SyncEventを通じて修復を実行
4. 処理結果のメタデータをログに記録

**前後の処理との関連**：Database::CiNamespaceMirrorsConsistencyCheckWorkerと同様のアーキテクチャで動作し、名前空間レベルとプロジェクトレベルでそれぞれ整合性を担保する。

**影響範囲**：ci_project_mirrorsテーブルのデータが更新される可能性があり、CIパイプラインの名前空間参照に影響を与える。

## バッチ種別

データ整合性チェック / データクレンジング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cron） |
| 実行時刻 | システム設定による |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | projectsテーブルとci_project_mirrorsテーブルへのアクセスが可能であること |
| Redis接続 | カーソル位置の保存・取得のためRedis SharedStateへのアクセスが可能であること |

### 実行可否判定

特別な実行可否判定ロジックはなく、Cronスケジュールに従って実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| projects | DB | プロジェクトのマスターテーブル |
| ci_project_mirrors | DB | CIプロジェクトのミラーテーブル |
| Redis SharedState | Redis | 整合性チェックカーソル位置 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ci_project_mirrors | DB | 不整合レコードの修復結果 |
| Redis SharedState | Redis | 次回実行用カーソル位置 |
| Sidekiqログ | ログ | 処理結果メタデータ |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. ConsistencyCheckService初期化
   └─ source_model: Project, target_model: Ci::ProjectMirror
   └─ source_columns: [id, namespace_id], target_columns: [project_id, namespace_id]
2. 整合性チェック実行
   └─ Redisからカーソル位置取得（初回はランダム位置）
   └─ 最大25バッチ（1000レコード/バッチ）または30秒間チェック
3. 不整合レコード検出
   └─ mismatches_detailsに不整合ID一覧を格納
4. 不整合修復（不整合がある場合のみ）
   └─ ConsistencyFixServiceでProjects::SyncEventを発行
5. カーソル位置保存
   └─ 次回開始位置をRedisに保存（TTL: 7日）
6. 結果ログ出力
   └─ matches, mismatches, batchesなどの統計情報を記録
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ConsistencyCheckService初期化]
    B --> C[Redisからカーソル取得]
    C --> D{カーソルあり?}
    D -->|なし| E[ランダム開始位置決定]
    D -->|あり| F[整合性チェック実行]
    E --> F
    F --> G{不整合あり?}
    G -->|あり| H[ConsistencyFixServiceで修復]
    G -->|なし| I[カーソル位置保存]
    H --> I
    I --> J[結果ログ出力]
    J --> K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 整合性チェック | projects | SELECT | プロジェクトIDと名前空間IDを取得 |
| 整合性チェック | ci_project_mirrors | SELECT | ミラーのプロジェクトIDと名前空間IDを取得 |
| 修復処理 | ci_project_mirrors | UPDATE/INSERT | 不整合レコードの修復 |

### テーブル別操作詳細

#### projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, namespace_id | バッチサイズ1000件ずつ取得 | 整合性チェック用 |

#### ci_project_mirrors

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | project_id, namespace_id | projectsと同一範囲で取得 | 整合性チェック用 |
| UPDATE/INSERT | project_id, namespace_id | projectsテーブルの値に同期 | 修復処理 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | データベース接続エラー | DBへの接続失敗 | Sidekiqによるリトライなし（retry: false） |
| - | Redis接続エラー | Redisへの接続失敗 | 次回実行時にランダム位置から再開 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（retry: false） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

バッチ失敗時は次回のCron実行まで待機。カーソル位置がRedisに保存されていれば続きから、なければランダム位置から再開。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 修復対象レコード単位 |
| コミットタイミング | SyncEvent発行時 |
| ロールバック条件 | 個別レコード修復失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 最大25,000件/実行（25バッチ x 1000件） |
| 目標処理時間 | 最大30秒 |
| メモリ使用量上限 | バッチ処理のため低メモリ使用 |

## 排他制御

idempotent!が設定されており、同一処理の重複実行は安全に処理される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果ログ | バッチ終了時 | results（matches, mismatches, batches, mismatches_details） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 不整合件数 | 継続的な大量不整合 | システム管理者 |
| 処理時間 | 30秒超過 | Sidekiqモニタリング |

## 備考

- feature_category: cell
- data_consistency: sticky
- idempotent: true
- version: 1
