# バッチ設計書 22-Database::BatchedBackgroundMigration::SingleDatabaseWorker

## 概要

本ドキュメントは、バッチバックグラウンドマイグレーションを実行するバッチ処理「Database::BatchedBackgroundMigration::SingleDatabaseWorker」の設計仕様を記載する。

### 本バッチの処理概要

本バッチは、GitLabのデータベースマイグレーションをバックグラウンドで段階的に実行するためのスケジューラワーカーである。大規模なデータ移行を本番環境のパフォーマンスに影響を与えることなく実行する。

**業務上の目的・背景**：GitLabのようなエンタープライズアプリケーションでは、数百万～数十億レコードのデータを扱うテーブルが存在する。通常のマイグレーションでは長時間ロックが発生し、サービス停止を招く可能性がある。本バッチは、マイグレーションを小さなバッチに分割して非同期実行することで、サービスを継続しながら大規模なスキーマ変更やデータ変換を実現する。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。Feature Flag `execute_batched_migrations_on_schedule` が有効な場合のみ動作する。

**主要な処理内容**：
1. Feature Flagによる実行可否チェック
2. バリデーション（データベース接続確認など）の実行
3. アクティブなバッチマイグレーション一覧の取得（テーブルごとに1つ、最大数まで）
4. 各マイグレーションに対してExecution Workerをキューイング
5. キャパシティに基づいた並列実行制御

**前後の処理との関連**：本ワーカーはスケジューラとして機能し、実際のマイグレーション実行はExecutionWorker（MainExecutionWorker, CiExecutionWorker等）が担当する。

**影響範囲**：マイグレーション対象のテーブル全体に影響。データベース負荷に応じて処理速度が自動調整される。

## バッチ種別

データ移行 / バックグラウンド処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cron） |
| 実行時刻 | システム設定による |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Feature Flag | execute_batched_migrations_on_schedule が有効であること |
| データベース接続 | 対象データベースへの接続が可能であること |
| バリデーション | validate!メソッドがtrueを返すこと |

### 実行可否判定

```ruby
# Feature Flagチェック
Feature.enabled?(:execute_batched_migrations_on_schedule, type: :ops)

# self.class.enabled? でも追加チェック
```

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| batched_background_migrations | DB | アクティブなマイグレーション定義テーブル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Sidekiqキュー | ジョブ | ExecutionWorkerへのジョブ投入 |
| マイグレーション対象テーブル | DB | 各ExecutionWorkerによる更新 |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. バリデーション実行
   └─ validate!メソッドで接続確認等
2. Feature Flagチェック
   └─ self.class.enabled?でスケジューラ有効確認
3. データベース接続設定
   └─ SharedModel.using_connection(base_model.connection)
4. アクティブマイグレーション取得
   └─ BatchedMigration.active_migrations_distinct_on_table
   └─ テーブルごとに1つ、最大max_running_migrations件
5. マイグレーション実行キューイング
   └─ execution_worker_class.perform_with_capacityで並列実行
   └─ 引数: [tracking_database, migration.id]
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{validate!}
    B -->|false| Z[バッチ終了]
    B -->|true| C[SharedModel接続設定]
    C --> D{self.class.enabled?}
    D -->|false| Z
    D -->|true| E[アクティブマイグレーション取得]
    E --> F{マイグレーションあり?}
    F -->|なし| Z
    F -->|あり| G[ジョブ引数作成]
    G --> H[ExecutionWorker.perform_with_capacity]
    H --> Z
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| マイグレーション取得 | batched_background_migrations | SELECT | アクティブなマイグレーション一覧取得 |
| マイグレーション実行 | 各対象テーブル | UPDATE/INSERT/DELETE | ExecutionWorkerが実行 |

### テーブル別操作詳細

#### batched_background_migrations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, table_name等 | status=active、テーブルごとにdistinct | 最大max_running_migrations件 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | バリデーションエラー | validate!がfalse | 処理をスキップして終了 |
| - | データベース接続エラー | DB接続失敗 | Sidekiqリトライに委ねる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | Sidekiqデフォルト |
| リトライ対象エラー | 一般的な例外 |

### 障害時対応

本ワーカーはidempotentであり、再実行しても安全。次回Cron実行時に自動的に再試行される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | マイグレーション取得のみ |
| コミットタイミング | 読み取り専用のため該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | max_running_migrations件のジョブ投入 |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 低メモリ使用（ジョブ投入のみ） |

## 排他制御

- idempotent!が設定されており、重複実行は安全
- perform_with_capacityによるキャパシティベースの並列制御

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 処理ログ | ジョブ投入時 | マイグレーションID、対象データベース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| マイグレーション遅延 | 長期間未完了 | システム管理者 |
| 実行エラー | エラー発生時 | Sidekiqモニタリング |

## 備考

- feature_category: database
- data_consistency: always
- idempotent: true
- BackgroundWorkSchedulableモジュールをinclude
- 具体的な実装はCiDatabaseWorker、MainDatabaseWorker等のサブクラスで行われる
