# バッチ設計書 23-Database::BackgroundOperation::BaseSchedulerWorker

## 概要

本ドキュメントは、バックグラウンド操作のスケジューラ基底クラス「Database::BackgroundOperation::BaseSchedulerWorker」の設計仕様を記載する。

### 本バッチの処理概要

本バッチは、GitLabのデータベースバックグラウンド操作をスケジュールするための基底ワーカークラスである。大規模なデータ操作を非同期で実行するためのオーケストレーションを担当する。

**業務上の目的・背景**：GitLabでは、データベースのメンテナンス操作（インデックス作成、データクリーンアップ、テーブル最適化など）をサービス稼働中に行う必要がある。本クラスは、これらの操作を本番環境に影響を与えずに段階的に実行するためのスケジューラ機能を提供する。Feature Flag `schedule_background_operations` で制御され、安全に有効化・無効化できる。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。Feature Flagが有効な場合のみ動作する。

**主要な処理内容**：
1. Feature Flagによる実行可否チェック（schedule_background_operations）
2. バリデーション実行（データベース接続確認など）
3. スケジュール可能なワーカー一覧の取得
4. 各ワーカーに対してOrchestratorクラスを通じてジョブ投入
5. キャパシティベースの並列実行制御

**前後の処理との関連**：本ワーカーは基底クラスとして機能し、MainSchedulerWorker、CiSchedulerWorker等の具体的なサブクラスが実際のスケジューリングを行う。実行はOrchestratorWorkerに委譲される。

**影響範囲**：スケジュールされた操作の対象テーブル全体。並列実行制御により負荷は制限される。

## バッチ種別

スケジューラ / バックグラウンド処理制御

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cron） |
| 実行時刻 | システム設定による |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Feature Flag | schedule_background_operations が有効であること |
| データベース接続 | 対象データベースへの接続が可能であること |
| バリデーション | validate!メソッドがtrueを返すこと |

### 実行可否判定

```ruby
# Feature Flagチェック
Feature.enabled?(:schedule_background_operations, type: :ops)

# self.class.enabled? でも追加チェック
```

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| バックグラウンド操作定義 | DB/設定 | スケジュール可能なワーカー情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Sidekiqキュー | ジョブ | OrchestratorWorkerへのジョブ投入 |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. バリデーション実行
   └─ validate!メソッドで接続確認等
2. Feature Flagチェック
   └─ self.class.enabled?でスケジューラ有効確認
3. データベース接続設定
   └─ SharedModel.using_connection(base_model.connection)
4. スケジュール可能ワーカー取得
   └─ worker_class.schedulable_workers(connection, max_running_jobs)
5. ワーカー実行キューイング
   └─ orchestrator_class.perform_with_capacity
   └─ 引数: [worker_class_name, partition, id, tracking_database]
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{validate!}
    B -->|false| Z[バッチ終了]
    B -->|true| C[SharedModel接続設定]
    C --> D{self.class.enabled?}
    D -->|false| Z
    D -->|true| E[schedulable_workers取得]
    E --> F{ワーカーあり?}
    F -->|なし| Z
    F -->|あり| G[ジョブ引数作成]
    G --> H[orchestrator_class.perform_with_capacity]
    H --> Z
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ワーカー取得 | バックグラウンド操作テーブル | SELECT | スケジュール可能なワーカー一覧取得 |

### テーブル別操作詳細

#### バックグラウンド操作定義テーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | class_name, partition, id | 実行可能な状態のもの | 最大max_running_jobs件 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | バリデーションエラー | validate!がfalse | 処理をスキップして終了 |
| - | データベース接続エラー | DB接続失敗 | Sidekiqリトライに委ねる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | Sidekiqデフォルト |
| リトライ対象エラー | 一般的な例外 |

### 障害時対応

本ワーカーはidempotentであり、再実行しても安全。次回Cron実行時に自動的に再試行される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ワーカー取得のみ |
| コミットタイミング | 読み取り専用のため該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | max_running_jobs件のジョブ投入 |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 低メモリ使用（ジョブ投入のみ） |

## 排他制御

- idempotent!が設定されており、重複実行は安全
- perform_with_capacityによるキャパシティベースの並列制御
- max_running_jobsによる同時実行数制限

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 処理ログ | ジョブ投入時 | ワーカークラス名、パーティション、ID |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 操作遅延 | 長期間未完了 | システム管理者 |
| 実行エラー | エラー発生時 | Sidekiqモニタリング |

## 備考

- feature_category: database
- data_consistency: sticky
- idempotent: true
- BackgroundWorkSchedulableモジュールをinclude
- 基底クラスのため、実際の動作はサブクラス（MainSchedulerWorker等）で行われる
