# バッチ設計書 24-Database::BackgroundOperation::CronEnqueueWorker

## 概要

本ドキュメントは、バックグラウンド操作のCronエンキューを行うバッチ処理「Database::BackgroundOperation::CronEnqueueWorker」の設計仕様を記載する。

### 本バッチの処理概要

本バッチは、GitLabのデータベースバックグラウンド操作をCronジョブからエンキューするためのワーカーである。外部からの引数を受け取り、WorkerCellLocalクラスを通じてバックグラウンド操作をスケジュールする。

**業務上の目的・背景**：GitLabでは、データベースの大規模な操作（データマイグレーション、インデックス作成、テーブルメンテナンス等）をCronジョブとしてスケジュール実行する必要がある。本ワーカーは、Cronスケジューラからの呼び出しを受け付け、適切なバックグラウンド操作ワーカーにジョブを委譲する役割を担う。Cell構成にも対応したCellLocal版を使用している。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。引数として実行するジョブの詳細情報を受け取る。

**主要な処理内容**：
1. 引数からジョブクラス名、テーブル名、カラム名、ジョブ引数、オプションを抽出
2. オプションのキーをシンボルに変換
3. Gitlab::Database::BackgroundOperation::WorkerCellLocal.enqueueを呼び出し
4. 指定されたバックグラウンド操作をエンキュー

**前後の処理との関連**：本ワーカーはCronからの入力を受け取るエントリポイントとして機能し、実際の操作実行はWorkerCellLocalクラスが管理する。

**影響範囲**：引数で指定されたテーブルとカラムに対する操作がスケジュールされる。

## バッチ種別

ジョブエンキュー / スケジューラ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cron） |
| 実行時刻 | システム設定による |
| 実行曜日 | 設定による |
| 実行日 | 設定による |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 引数の存在 | job_class_name, table_name, column_name等が指定されていること |
| データベース接続 | 対象データベースへの接続が可能であること |

### 実行可否判定

特別な実行可否判定ロジックはなく、引数が渡されれば実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| job_class_name | String | Yes | - | 実行するジョブクラス名 |
| table_name | String | Yes | - | 対象テーブル名 |
| column_name | String | Yes | - | 対象カラム名 |
| job_arguments | Array | No | nil | ジョブに渡す追加引数 |
| options | Hash | No | {} | オプション設定 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Cronジョブ引数 | Hash | スケジューラから渡される設定情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| バックグラウンド操作キュー | ジョブ | WorkerCellLocal経由でエンキュー |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ args['options']をシンボルキーに変換
2. WorkerCellLocal.enqueue呼び出し
   └─ job_class_name: ジョブクラス名
   └─ table_name: テーブル名
   └─ column_name: カラム名
   └─ job_arguments: 追加引数
   └─ **options: オプション
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数からオプション抽出]
    B --> C[オプションキーをシンボル化]
    C --> D[WorkerCellLocal.enqueue呼び出し]
    D --> E[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| エンキュー | バックグラウンド操作テーブル | INSERT | 新規操作の登録 |

### テーブル別操作詳細

#### バックグラウンド操作テーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | job_class_name, table_name, column_name等 | 引数から渡された値 | WorkerCellLocal経由 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | 必須引数が欠損 | 例外発生、Sidekiqリトライ |
| - | エンキューエラー | DB接続失敗等 | Sidekiqリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | Sidekiqデフォルト |
| リトライ対象エラー | 一般的な例外 |

### 障害時対応

本ワーカーはidempotentであり、再実行しても安全。同一ジョブが重複エンキューされる可能性があるが、WorkerCellLocal側で重複制御される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | エンキュー操作 |
| コミットタイミング | エンキュー完了時 |
| ロールバック条件 | エンキュー失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ジョブ/実行 |
| 目標処理時間 | 数ミリ秒 |
| メモリ使用量上限 | 低メモリ使用 |

## 排他制御

idempotent!が設定されており、重複実行は安全に処理される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 処理ログ | エンキュー時 | ジョブクラス名、テーブル名、カラム名 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| エンキュー失敗 | 発生時 | Sidekiqモニタリング |
| 処理遅延 | 長期間未処理 | システム管理者 |

## 備考

- feature_category: database
- data_consistency: sticky
- urgency: low
- idempotent: true
- Sidekiq::EnforceDatabaseHealthSignalDeferralを無効化している
