# バッチ設計書 25-LooseForeignKeys::CleanupWorker

## 概要

本ドキュメントは、疎外部キーのクリーンアップ処理を行うバッチ処理「LooseForeignKeys::CleanupWorker」の設計仕様を記載する。

### 本バッチの処理概要

本バッチは、GitLabのデータベースにおける疎外部キー（Loose Foreign Keys）で関連付けられた削除済みレコードの参照をクリーンアップする処理を行う。従来の外部キー制約の代わりに非同期で参照整合性を維持するための重要なバッチ処理である。

**業務上の目的・背景**：GitLabのような大規模データベースでは、従来の外部キー制約がパフォーマンスのボトルネックになる場合がある。特に、親レコード削除時のカスケード削除は長時間のロックを引き起こす可能性がある。疎外部キーの仕組みでは、親レコードの削除を即座に行い、子レコードの削除は本バッチで非同期に行うことで、削除操作のパフォーマンスを向上させている。

**バッチの実行タイミング**：Cronジョブとして1分ごとに実行される。複数データベース構成の場合、分単位で異なるデータベースを処理する。

**主要な処理内容**：
1. 現在の分（エポックからの分数）に基づいてデータベースを選択
2. Turboモードの有効/無効を確認してModificationTrackerを初期化
3. 排他ロックを取得してProcessDeletedRecordsServiceを実行
4. 削除済みレコードを追跡テーブルから読み取り、関連する子レコードを削除
5. 処理統計をログに記録

**前後の処理との関連**：loose_foreign_keysテーブル定義に基づいて動作し、削除対象のテーブルはloose_foreign_keys.rbで設定される。

**影響範囲**：疎外部キーで関連付けられたすべてのテーブルに影響。実行ごとにBATCH_SIZE（500件）単位で処理される。

## バッチ種別

データクレンジング / 参照整合性維持

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 毎分（Cron） |
| 実行時刻 | 毎分0秒 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 排他ロック取得 | 同一ワーカーが同時実行されていないこと |
| データベース接続 | 対象データベース（main/ci/sec）への接続が可能であること |

### 実行可否判定

排他ロック（ExclusiveLease）が取得できない場合はスキップ。ロックTTLはmax_runtime + 10秒。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| loose_foreign_keys_deleted_records | DB | 削除済みレコードの追跡テーブル |
| loose_foreign_keys定義 | 設定 | 疎外部キーの関連定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 関連子テーブル | DB | 削除またはNULL設定 |
| Sidekiqログ | ログ | 処理統計（stats） |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. データベース選択
   └─ Time.current.to_i / 60 でエポックからの分数算出
   └─ データベース数で剰余を取り、対象DBを決定
2. ModificationTracker初期化
   └─ Feature Flag turbo_mode_{connection_name} を確認
   └─ 有効ならTurboModificationTracker、無効ならModificationTracker
3. 排他ロック取得
   └─ in_lock(self.class.name.underscore, ttl: lock_ttl)
   └─ ロック取得失敗時はスキップ（retries: 0）
4. ProcessDeletedRecordsService実行
   └─ 削除済みレコードをテーブルごとに処理
   └─ BatchCleanerServiceで子レコードを削除
5. 統計情報ログ出力
   └─ connection, turbo_mode, 処理統計をメタデータとして記録
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[データベース選択]
    B --> C[Turboモード判定]
    C --> D[ModificationTracker初期化]
    D --> E{排他ロック取得}
    E -->|失敗| Z[バッチ終了]
    E -->|成功| F[ProcessDeletedRecordsService実行]
    F --> G[削除済みレコード取得]
    G --> H{レコードあり?}
    H -->|なし| I[次テーブルへ]
    H -->|あり| J[BatchCleanerService実行]
    J --> K{制限超過?}
    K -->|はい| L[統計ログ出力]
    K -->|いいえ| I
    I --> H
    L --> Z
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 削除レコード取得 | loose_foreign_keys_deleted_records | SELECT | 削除対象の親レコードID取得 |
| 子レコード削除 | 関連子テーブル | DELETE/UPDATE | 参照削除またはNULL設定 |
| 削除レコード更新 | loose_foreign_keys_deleted_records | DELETE | 処理済みレコード削除 |

### テーブル別操作詳細

#### loose_foreign_keys_deleted_records

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, fully_qualified_table_name, primary_key_value | BATCH_SIZE（500件）ずつ取得 | テーブルごとにシャッフル |
| DELETE | id | 処理完了後 | 処理済みレコードを削除 |

#### 関連子テーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE/UPDATE | 外部キーカラム | 削除またはNULL | 定義に応じて動作 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ロック取得失敗 | 他インスタンスが実行中 | スキップして次回実行を待機 |
| - | データベースエラー | DB接続失敗 | 例外を再throw、SLIにエラー記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（retry: false） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

バッチ失敗時は次回のCron実行（1分後）まで待機。未処理のレコードはloose_foreign_keys_deleted_recordsに残り、次回実行時に処理される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ単位 |
| コミットタイミング | バッチ処理完了時 |
| ロールバック条件 | 例外発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | BATCH_SIZE（500件）× 複数テーブル |
| 目標処理時間 | max_runtime（ModificationTrackerで制御） |
| メモリ使用量上限 | バッチ処理のため低メモリ使用 |

## 排他制御

- ExclusiveLeaseHelperによる排他ロック
- ロック名: loose_foreign_keys/cleanup_worker
- TTL: max_runtime + 10秒
- リトライ: 0回（取得失敗時はスキップ）
- idempotent!が設定されており、重複実行は安全

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 統計ログ | バッチ終了時 | stats（処理件数、削除件数等）、connection、turbo_mode |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理遅延 | modification_tracker.over_limit? | Apdex SLI |
| エラー発生 | 例外発生時 | Error Rate SLI |

## 備考

- feature_category: database
- data_consistency: sticky
- idempotent: true
- retry: false
- Turboモード: loose_foreign_keys_turbo_mode_{main/ci/sec} Feature Flagで制御
- 複数DB構成: 分単位でデータベースをローテーション
