# バッチ設計書 26-LooseForeignKeys::MergeRequestDiffCommitCleanupWorker

## 概要

本ドキュメントは、マージリクエストのディフコミットに関する疎外部キークリーンアップ処理を行うバッチ処理「LooseForeignKeys::MergeRequestDiffCommitCleanupWorker」の設計仕様を記載する。

### 本バッチの処理概要

本バッチは、merge_request_diff_commitsテーブルに特化した疎外部キークリーンアップ処理を行う。通常のLooseForeignKeys::CleanupWorkerとは別に、このテーブル専用のワーカーとして動作する。

**業務上の目的・背景**：merge_request_diff_commitsテーブルは、GitLabのマージリクエストに関連するコミット差分を保存する大規模テーブルである。このテーブルはVACUUM処理など他のメンテナンス操作と競合する可能性があるため、専用のクリーンアップワーカーを設けている。VACUUM実行中はクリーンアップをスキップすることで、データベースへの過負荷を防止する。

**バッチの実行タイミング**：Cronジョブとして定期的に実行される。ただし、merge_request_diff_commitsテーブルでVACUUMが実行中の場合はスキップされる。

**主要な処理内容**：
1. merge_request_diff_commitsテーブルのVACUUM実行状態を確認
2. VACUUM実行中の場合は処理をスキップしてログを記録
3. ModificationTrackerを初期化
4. 排他ロックを取得してProcessDeletedRecordsServiceを実行
5. 削除済みレコードを処理して関連する参照をクリーンアップ

**前後の処理との関連**：通常のCleanupWorkerとは独立して動作し、merge_request_diff_commitsテーブル専用のloose_foreign_keys定義に基づいて処理を行う。

**影響範囲**：merge_request_diff_commitsテーブルと、それを参照する関連テーブルに影響。

## バッチ種別

データクレンジング / 参照整合性維持

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（Cron） |
| 実行時刻 | システム設定による |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| VACUUM非実行 | merge_request_diff_commitsテーブルでVACUUMが実行中でないこと |
| 排他ロック取得 | 同一ワーカーが同時実行されていないこと |
| データベース接続 | ApplicationRecord接続が可能であること |

### 実行可否判定

```ruby
# VACUUM実行チェック
Gitlab::Database::PostgresAutovacuumActivity.for_tables(['merge_request_diff_commits']).present?
```

VACUUM実行中の場合はログを記録して早期リターン。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本バッチはパラメータを受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| loose_foreign_keys_deleted_records | DB | 削除済みレコードの追跡テーブル |
| pg_stat_user_tables | システムカタログ | VACUUM実行状態確認 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| merge_request_diff_commits関連テーブル | DB | 削除またはNULL設定 |
| Sidekiqログ | ログ | 処理統計（stats）、vacuum_running |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. VACUUMステータス確認
   └─ PostgresAutovacuumActivity.for_tables(['merge_request_diff_commits'])
2. VACUUM実行中の場合
   └─ log_extra_metadata_on_done(:vacuum_running, true)
   └─ 早期リターン
3. ModificationTracker初期化
   └─ 通常のModificationTrackerを使用
4. 排他ロック取得
   └─ in_lock(self.class.name.underscore, ttl: lock_ttl)
   └─ ロック取得失敗時はスキップ（retries: 0）
5. ProcessDeletedRecordsService実行
   └─ ApplicationRecord.connection使用
   └─ worker_class: self.class を指定
6. 統計情報ログ出力
   └─ stats をメタデータとして記録
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{VACUUM実行中?}
    B -->|はい| C[vacuum_running=true記録]
    C --> Z[バッチ終了]
    B -->|いいえ| D[ModificationTracker初期化]
    D --> E{排他ロック取得}
    E -->|失敗| Z
    E -->|成功| F[ProcessDeletedRecordsService実行]
    F --> G[削除済みレコード処理]
    G --> H[統計ログ出力]
    H --> Z
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| VACUUM確認 | pg_stat_user_tables | SELECT | autovacuum状態確認 |
| 削除レコード取得 | loose_foreign_keys_deleted_records | SELECT | 削除対象の親レコードID取得 |
| 参照クリーンアップ | merge_request_diff_commits関連 | DELETE/UPDATE | 参照削除またはNULL設定 |

### テーブル別操作詳細

#### loose_foreign_keys_deleted_records

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, primary_key_value | merge_request_diff_commits関連のみ | BATCH_SIZE単位 |
| DELETE | id | 処理完了後 | 処理済みレコード削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ロック取得失敗 | 他インスタンスが実行中 | スキップして次回実行を待機 |
| - | VACUUM実行中 | autovacuumがテーブル処理中 | スキップしてログ記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（retry: false） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

バッチ失敗時は次回のCron実行まで待機。VACUUMとの競合を避けるため、無理にリトライしない設計。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ単位 |
| コミットタイミング | バッチ処理完了時 |
| ロールバック条件 | 例外発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | BATCH_SIZE（500件）× 処理サイクル |
| 目標処理時間 | max_runtime（ModificationTrackerで制御） |
| メモリ使用量上限 | バッチ処理のため低メモリ使用 |

## 排他制御

- ExclusiveLeaseHelperによる排他ロック
- ロック名: loose_foreign_keys/merge_request_diff_commit_cleanup_worker
- TTL: max_runtime + 10秒
- リトライ: 0回（取得失敗時はスキップ）
- VACUUMとの競合回避機能あり
- idempotent!が設定されており、重複実行は安全

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| VACUUMスキップログ | VACUUM実行中 | vacuum_running: true |
| 統計ログ | バッチ終了時 | stats（処理件数、削除件数等） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| VACUUMスキップ頻度 | 継続的なスキップ | システム管理者 |
| 処理遅延 | 長期間未処理 | Sidekiqモニタリング |

## 備考

- feature_category: code_review_workflow
- data_consistency: sticky
- idempotent: true
- retry: false
- merge_request_diff_commitsテーブル専用のクリーンアップワーカー
- VACUUM競合回避のための専用実装
